/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.powercell.blocks;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.api.power.IBigPower;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.infoscreen.CapabilityInformationScreenInfo;
import mcjty.rftoolsbase.api.infoscreen.IInformationScreenInfo;
import mcjty.rftoolspower.modules.powercell.PowerCellConfig;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellBlock;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellInformationScreenInfo;
import mcjty.rftoolspower.modules.powercell.data.PowerCellNetwork;
import mcjty.rftoolspower.modules.powercell.data.SideType;
import mcjty.rftoolspower.modules.powercell.data.Tier;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class PowerCellTileEntity
extends GenericTileEntity
implements ITickableTileEntity,
IBigPower {
    private PowerCellNetwork network = null;
    private long localEnergy = 0L;
    private final Tier tier;
    public static final ModelProperty<SideType> NORTH = new ModelProperty();
    public static final ModelProperty<SideType> SOUTH = new ModelProperty();
    public static final ModelProperty<SideType> WEST = new ModelProperty();
    public static final ModelProperty<SideType> EAST = new ModelProperty();
    public static final ModelProperty<SideType> UP = new ModelProperty();
    public static final ModelProperty<SideType> DOWN = new ModelProperty();
    public static final ModelProperty<Tier> TIER = new ModelProperty();
    private LazyOptional<IInformationScreenInfo> infoScreenInfo = LazyOptional.of(this::createScreenInfo);
    private LazyOptional<NullHandler> nullStorage = LazyOptional.of(this::createNullHandler);
    private LazyOptional<SidedHandler>[] sidedStorages;
    private SideType[] modes = new SideType[]{SideType.NONE, SideType.NONE, SideType.NONE, SideType.NONE, SideType.NONE, SideType.NONE};
    private int outputCount = 0;
    private static Set<BlockPos> alreadyReportedBad = new HashSet<BlockPos>();
    private static Set<BlockPos> alreadyReportedUnexpected = new HashSet<BlockPos>();

    public PowerCellTileEntity(Tier tier) {
        super(tier.getType());
        this.tier = tier;
        this.sidedStorages = new LazyOptional[OrientationTools.DIRECTION_VALUES.length];
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            this.sidedStorages[direction.ordinal()] = LazyOptional.of(() -> this.createSidedHandler(direction));
        }
    }

    public SideType getMode(Direction side) {
        return this.modes[side.ordinal()];
    }

    public void toggleMode(Direction side) {
        switch (this.modes[side.ordinal()]) {
            case NONE: {
                this.modes[side.ordinal()] = SideType.INPUT;
                break;
            }
            case INPUT: {
                this.modes[side.ordinal()] = SideType.OUTPUT;
                break;
            }
            case OUTPUT: {
                this.modes[side.ordinal()] = SideType.NONE;
            }
        }
        this.updateOutputCount();
        this.markDirtyClient();
    }

    private void updateOutputCount() {
        this.outputCount = 0;
        for (SideType mode : this.modes) {
            if (mode != SideType.OUTPUT) continue;
            ++this.outputCount;
        }
    }

    public Tier getTier() {
        return this.tier;
    }

    public static long safeCast(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        return 0L;
    }

    public long getLocalMaxEnergy() {
        switch (this.tier) {
            case TIER1: {
                return PowerCellTileEntity.safeCast(PowerCellConfig.TIER1_MAXRF.get());
            }
            case TIER2: {
                return PowerCellTileEntity.safeCast(PowerCellConfig.TIER2_MAXRF.get());
            }
            case TIER3: {
                return PowerCellTileEntity.safeCast(PowerCellConfig.TIER3_MAXRF.get());
            }
        }
        return 0L;
    }

    public long getRfPerTickPerSide() {
        switch (this.tier) {
            case TIER1: {
                return ((Integer)PowerCellConfig.TIER1_RFPERTICK.get()).intValue();
            }
            case TIER2: {
                return ((Integer)PowerCellConfig.TIER2_RFPERTICK.get()).intValue();
            }
            case TIER3: {
                return ((Integer)PowerCellConfig.TIER3_RFPERTICK.get()).intValue();
            }
        }
        return 0L;
    }

    public long getRfPerTickReal() {
        if ((Double)PowerCellConfig.RFPERTICK_SCALE.get() > 0.0) {
            return (long)((double)this.getRfPerTickPerSide() + (double)((long)(this.getNetwork().getPositions().size() - 1) * this.getRfPerTickPerSide()) * (Double)PowerCellConfig.RFPERTICK_SCALE.get());
        }
        return this.getRfPerTickPerSide();
    }

    public long getStoredPower() {
        return this.getNetwork().getEnergy();
    }

    public long getCapacity() {
        return this.getNetwork().getMaxEnergy();
    }

    private long receiveEnergyFacing(Direction from, long maxReceive, boolean simulate) {
        if (this.modes[from.ordinal()] != SideType.INPUT) {
            return 0L;
        }
        PowerCellNetwork network = this.getNetwork();
        if (network == null || !network.isValid()) {
            return 0L;
        }
        long received = this.receiveEnergyLocal(maxReceive = Math.min(maxReceive, this.getRfPerTickReal()), simulate);
        if (received > 0L) {
            if (!simulate) {
                network.addEnergy(received);
            }
            maxReceive -= received;
        }
        long totReceived = received;
        if (maxReceive > 0L) {
            for (Long l : network.getPositions()) {
                PowerCellTileEntity powercell;
                BlockPos p = BlockPos.func_218283_e((long)l);
                TileEntity te = this.field_145850_b.func_175625_s(p);
                if (!(te instanceof PowerCellTileEntity) || (received = (powercell = (PowerCellTileEntity)te).receiveEnergyLocal(maxReceive, simulate)) <= 0L) continue;
                if (!simulate) {
                    network.addEnergy(received);
                }
                maxReceive -= received;
                totReceived += received;
            }
        }
        return totReceived;
    }

    private long receiveEnergyLocal(long maxReceive, boolean simulate) {
        long maxInsert = Math.min(this.getLocalMaxEnergy() - this.localEnergy, maxReceive);
        if (maxInsert > 0L && !simulate) {
            this.localEnergy += maxInsert;
            this.markDirtyQuick();
        }
        return maxInsert;
    }

    private int getEnergyStoredAsInt() {
        return (int)Math.min(Integer.MAX_VALUE, this.getNetwork().getEnergy());
    }

    private int getMaxEnergyStoredAsInt() {
        return (int)Math.min(Integer.MAX_VALUE, this.getNetwork().getMaxEnergy());
    }

    public void func_73660_a() {
        PowerCellNetwork network;
        if (!this.field_145850_b.field_72995_K && this.outputCount > 0 && (network = this.getNetwork()) != null && network.isValid()) {
            long energyStored = network.getEnergy();
            if (energyStored <= 0L) {
                return;
            }
            this.sendOutEnergy(energyStored);
        }
    }

    public void redistributeNetwork() {
        PowerCellNetwork network = this.getNetwork();
        if (network == null || network.getPositions().isEmpty()) {
            return;
        }
        long[] energy = new long[]{0L, 0L, 0L};
        int[] count = new int[]{0, 0, 0};
        network.getPositions().stream().forEach(l -> {
            BlockPos p = BlockPos.func_218283_e((long)l);
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (te instanceof PowerCellTileEntity) {
                int t;
                PowerCellTileEntity powercell = (PowerCellTileEntity)te;
                int n = t = powercell.getTier().ordinal();
                energy[n] = energy[n] + powercell.getLocalEnergy();
                int n2 = t;
                count[n2] = count[n2] + 1;
            }
        });
        for (Tier tier : Tier.values()) {
            if (count[tier.ordinal()] <= 0) continue;
            long energyPerBlock = energy[tier.ordinal()] / (long)count[tier.ordinal()];
            long[] energyToSet = new long[]{energyPerBlock + energy[tier.ordinal()] % (long)count[tier.ordinal()]};
            network.getPositions().stream().forEach(l -> {
                PowerCellTileEntity powercell;
                BlockPos p = BlockPos.func_218283_e((long)l);
                TileEntity te = this.field_145850_b.func_175625_s(p);
                if (te instanceof PowerCellTileEntity && (powercell = (PowerCellTileEntity)te).getTier() == tier) {
                    powercell.setLocalEnergy(energyToSet[0]);
                    powercell.markDirtyQuick();
                    energyToSet[0] = energyPerBlock;
                }
            });
        }
    }

    private void validateNetwork() {
        long[] energy = new long[]{0L};
        long[] maxEnergy = new long[]{0L};
        this.getNetwork().getPositions().stream().forEach(l -> {
            BlockPos p = BlockPos.func_218283_e((long)l);
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (te instanceof PowerCellTileEntity) {
                PowerCellTileEntity powercell = (PowerCellTileEntity)te;
                energy[0] = energy[0] + powercell.getLocalEnergy();
                maxEnergy[0] = maxEnergy[0] + powercell.getLocalMaxEnergy();
                if (powercell.network != this.network) {
                    System.out.println("##### Network doesn't match at: " + p);
                }
            } else {
                System.out.println("##### Not a powercell: " + p);
            }
        });
        if (this.network.getEnergy() != energy[0]) {
            System.out.println("##### Energy mismatch! Got " + energy[0] + ", expected " + this.network.getEnergy());
        }
        if (this.network.getMaxEnergy() != maxEnergy[0]) {
            System.out.println("##### Max energy mismatch! Got " + maxEnergy[0] + ", expected " + this.network.getMaxEnergy());
        }
    }

    private void sendOutEnergy(long energyStored) {
        long[] stored = new long[]{energyStored};
        long[] energyExtracted = new long[]{0L};
        for (Direction face : Direction.values()) {
            if (this.modes[face.ordinal()] != SideType.OUTPUT) continue;
            BlockPos pos = this.func_174877_v().func_177972_a(face);
            TileEntity te = this.func_145831_w().func_175625_s(pos);
            Direction opposite = face.func_176734_d();
            if (te == null) continue;
            te.getCapability(CapabilityEnergy.ENERGY, opposite).ifPresent(e -> {
                if (!(te instanceof PowerCellTileEntity)) {
                    long rfPerTick = this.getRfPerTickReal();
                    long rfToGive = Math.min(rfPerTick, stored[0]);
                    long received = EnergyTools.receiveEnergy((TileEntity)te, (Direction)opposite, (long)rfToGive);
                    stored[0] = stored[0] - received;
                    energyExtracted[0] = energyExtracted[0] + received;
                }
            });
            if (stored[0] <= 0L) break;
        }
        if (energyExtracted[0] > 0L) {
            this.network.extractEnergy(energyExtracted[0]);
            this.extractEnergyFromNetwork(energyExtracted[0]);
        }
    }

    private void extractEnergyFromNetwork(long energyExtracted) {
        long toExtractLocal = Math.min(energyExtracted, this.localEnergy);
        if (toExtractLocal > 0L) {
            this.localEnergy -= toExtractLocal;
            energyExtracted -= toExtractLocal;
            this.markDirtyQuick();
        }
        if (energyExtracted > 0L) {
            for (Long l : this.network.getPositions()) {
                BlockPos p = BlockPos.func_218283_e((long)l);
                TileEntity te = this.field_145850_b.func_175625_s(p);
                if (!(te instanceof PowerCellTileEntity)) continue;
                PowerCellTileEntity powercell = (PowerCellTileEntity)te;
                toExtractLocal = Math.min(energyExtracted, powercell.localEnergy);
                if (toExtractLocal > 0L) {
                    powercell.localEnergy -= toExtractLocal;
                    energyExtracted -= toExtractLocal;
                    powercell.markDirtyQuick();
                }
                if (energyExtracted > 0L) continue;
                break;
            }
        }
    }

    public long getLocalEnergy() {
        return this.localEnergy;
    }

    public void setLocalEnergy(long localEnergy) {
        this.localEnergy = localEnergy;
    }

    public PowerCellNetwork getNetwork() {
        if (this.network == null) {
            this.buildNetwork(new PowerCellNetwork(), this.field_174879_c);
        }
        return this.network;
    }

    public void setNetwork(PowerCellNetwork network) {
        this.network = network;
    }

    public void onReplaced(World world, BlockPos pos, BlockState state, BlockState newstate) {
        BlockState stateDown;
        BlockState stateUp;
        if (state.func_177230_c() == newstate.func_177230_c()) {
            return;
        }
        if (this.getNetwork() != null) {
            this.dismantleNetwork(this.getNetwork());
        }
        if ((stateUp = world.func_180495_p(pos.func_177984_a())).func_177230_c() instanceof PowerCellBlock) {
            world.func_184138_a(pos.func_177984_a(), stateUp, stateUp, 3);
        }
        if ((stateDown = world.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof PowerCellBlock) {
            world.func_184138_a(pos.func_177977_b(), stateDown, stateDown, 3);
        }
    }

    public void dismantleNetwork(PowerCellNetwork network) {
        network.getPositions().stream().map(BlockPos::func_218283_e).forEach(pos -> {
            TileEntity te = this.field_145850_b.func_175625_s(pos);
            if (te instanceof PowerCellTileEntity) {
                PowerCellTileEntity powercell = (PowerCellTileEntity)te;
                powercell.setNetwork(null);
            }
        });
    }

    private void buildNetwork(PowerCellNetwork network, BlockPos pos) {
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)te;
            if (network.contains(pos)) {
                if (powercell.network != network && !alreadyReportedBad.contains(pos)) {
                    System.out.println("Bad network at pos = " + pos + " (dimension " + this.field_145850_b.func_201675_m().func_186058_p() + ")");
                    alreadyReportedBad.add(pos);
                }
                return;
            }
            if (powercell.network == network) {
                if (!alreadyReportedUnexpected.contains(pos)) {
                    System.out.println("Unexpected network at pos = " + pos + " (dimension " + this.field_145850_b.func_201675_m().func_186058_p() + ")");
                    alreadyReportedUnexpected.add(pos);
                }
                return;
            }
            if (powercell.network != null) {
                this.dismantleNetwork(powercell.network);
            }
            powercell.setNetwork(network);
            network.add(pos);
            network.setEnergy(network.getEnergy() + powercell.getLocalEnergy());
            network.setMaxEnergy(network.getMaxEnergy() + powercell.getLocalMaxEnergy());
            for (Direction facing : OrientationTools.DIRECTION_VALUES) {
                this.buildNetwork(network, pos.func_177972_a(facing));
            }
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        SideType[] old = new SideType[]{this.modes[0], this.modes[1], this.modes[2], this.modes[3], this.modes[4], this.modes[5]};
        super.onDataPacket(net, packet);
        for (int i = 0; i < 6; ++i) {
            if (old[i] == this.modes[i]) continue;
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            return;
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(NORTH, (Object)this.getMode(Direction.NORTH)).withInitial(SOUTH, (Object)this.getMode(Direction.SOUTH)).withInitial(WEST, (Object)this.getMode(Direction.WEST)).withInitial(EAST, (Object)this.getMode(Direction.EAST)).withInitial(UP, (Object)this.getMode(Direction.UP)).withInitial(DOWN, (Object)this.getMode(Direction.DOWN)).withInitial(TIER, (Object)this.tier).build();
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        String mode = info.func_74779_i("mode");
        if (mode.length() >= 6) {
            for (int i = 0; i < 6; ++i) {
                this.modes[i] = SideType.VALUES[Integer.parseInt(mode.substring(i, i + 1))];
            }
        }
        this.updateOutputCount();
        this.localEnergy = info.func_74763_f("energy");
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        String mode = "";
        for (int i = 0; i < 6; ++i) {
            mode = mode + this.modes[i].ordinal();
        }
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74778_a("mode", mode);
        info.func_74772_a("energy", this.localEnergy);
        return super.func_189515_b(tagCompound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (facing == null) {
                return this.nullStorage.cast();
            }
            return this.sidedStorages[facing.ordinal()].cast();
        }
        if (capability == CapabilityInformationScreenInfo.INFORMATION_SCREEN_INFO_CAPABILITY) {
            return this.infoScreenInfo.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    private IInformationScreenInfo createScreenInfo() {
        return new PowerCellInformationScreenInfo(this);
    }

    private SidedHandler createSidedHandler(Direction facing) {
        return new SidedHandler(facing);
    }

    private NullHandler createNullHandler() {
        return new NullHandler();
    }

    class NullHandler
    implements IEnergyStorage {
        NullHandler() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return PowerCellTileEntity.this.getEnergyStoredAsInt();
        }

        public int getMaxEnergyStored() {
            return PowerCellTileEntity.this.getMaxEnergyStoredAsInt();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return false;
        }
    }

    class SidedHandler
    implements IEnergyStorage {
        private final Direction facing;

        public SidedHandler(Direction facing) {
            this.facing = facing;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return (int)PowerCellTileEntity.this.receiveEnergyFacing(this.facing, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return PowerCellTileEntity.this.getEnergyStoredAsInt();
        }

        public int getMaxEnergyStored() {
            return PowerCellTileEntity.this.getMaxEnergyStoredAsInt();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

