/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.powercell.blocks;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.powercell.PowerCellConfig;
import mcjty.rftoolspower.modules.powercell.PowerCellSetup;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellTileEntity;
import mcjty.rftoolspower.modules.powercell.data.Tier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class PowerCellBlock
extends BaseBlock
implements INBTPreservingIngredient {
    public static BooleanProperty UPPER = BooleanProperty.func_177716_a((String)"upper");
    public static BooleanProperty LOWER = BooleanProperty.func_177716_a((String)"lower");

    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    public PowerCellBlock(Tier tier) {
        super(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).tileEntitySupplier(() -> new PowerCellTileEntity(tier)));
    }

    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader player, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_190948_a(itemStack, player, list, flag);
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Energy: " + TextFormatting.YELLOW + tagCompound.func_74763_f("Energy")));
        }
        if (McJtyLib.proxy.isShiftKeyDown()) {
            long totpower = 0L;
            if (itemStack.func_77973_b() == Item.func_150898_a((Block)((Block)PowerCellSetup.CELL1.get()))) {
                totpower = PowerCellTileEntity.safeCast(PowerCellConfig.TIER1_MAXRF.get());
            } else if (itemStack.func_77973_b() == Item.func_150898_a((Block)((Block)PowerCellSetup.CELL2.get()))) {
                totpower = PowerCellTileEntity.safeCast(PowerCellConfig.TIER2_MAXRF.get());
            } else if (itemStack.func_77973_b() == Item.func_150898_a((Block)((Block)PowerCellSetup.CELL3.get()))) {
                totpower = PowerCellTileEntity.safeCast(PowerCellConfig.TIER3_MAXRF.get());
            }
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "This block can store power (" + totpower + " RF)"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "and can be combined with other cells to form a"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "big multiblock"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "Right click with a wrench to toggle"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "input/output mode for a side"));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "<Press Shift>"));
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)te;
            long energy = stack.func_77942_o() ? stack.func_77978_p().func_74763_f("energy") : 0L;
            powercell.setLocalEnergy(energy);
            powercell.getNetwork();
            powercell.markDirtyQuick();
        }
    }

    protected boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powerCellTileEntity = (PowerCellTileEntity)te;
            powerCellTileEntity.toggleMode(side);
        }
        return true;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        BlockState state = super.func_196258_a(context);
        World world = context.func_195991_k();
        return (BlockState)((BlockState)state.func_206870_a((IProperty)UPPER, (Comparable)Boolean.valueOf(world.func_180495_p((pos = context.func_195995_a()).func_177984_a()).func_177230_c() == this))).func_206870_a((IProperty)LOWER, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177977_b()).func_177230_c() == this));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (facing == Direction.UP) {
            return (BlockState)stateIn.func_206870_a((IProperty)UPPER, (Comparable)Boolean.valueOf(facingState.func_177230_c() == this));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.func_206870_a((IProperty)LOWER, (Comparable)Boolean.valueOf(facingState.func_177230_c() == this));
        }
        return stateIn;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{UPPER, LOWER});
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public Collection<String> getTagsToPreserve() {
        return Collections.singleton("Info");
    }
}

