/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell.client;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolspower.RFToolsPower;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellConfiguration;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellContainer;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellTileEntity;
import mcjty.rftoolspower.setup.RFToolsPowerMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;

public class GuiDimensionalCell
extends GenericGuiContainer<DimensionalCellTileEntity, DimensionalCellContainer> {
    public static final int POWERCELL_WIDTH = 180;
    public static final int POWERCELL_HEIGHT = 152;
    private EnergyBar energyBar;
    private Button stats;
    private static long lastTime = 0L;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolspower", "textures/gui/dimensionalcell.png");

    public GuiDimensionalCell(DimensionalCellTileEntity te, DimensionalCellContainer container, PlayerInventory inventory) {
        super((ModBase)RFToolsPower.instance, (GenericTileEntity)te, (Container)container, inventory, 0, "powercell");
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void init() {
        super.init();
        this.energyBar = ((EnergyBar)new EnergyBar(this.minecraft, (Screen)this).setVertical().setMaxValue(1000L).setLayoutHint(10, 7, 8, 54)).setShowText(false);
        this.energyBar.setValue(0L);
        Button allNone = (Button)((Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setName("allnone")).setText("None")).setTooltips(new String[]{"Set all sides to 'none'"})).setLayoutHint(140, 10, 32, 15);
        Button allInput = (Button)((Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setName("allinput")).setText("In")).setTooltips(new String[]{"Set all sides to", "accept energy"})).setLayoutHint(140, 27, 32, 15);
        Button allOutput = (Button)((Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setName("alloutput")).setText("Out")).setTooltips(new String[]{"Set all sides to", "send energy"})).setLayoutHint(140, 44, 32, 15);
        this.stats = (Button)((Button)((Button)((Button)new Button(this.minecraft, (Screen)this).setName("clearstats")).setText("Stats")).setTooltips(new String[]{"Power statistics. Press to clear:"})).setLayoutHint(100, 10, 32, 15);
        Label label = new Label(this.minecraft, (Screen)this);
        ((Label)((Label)label.setText("Link:")).setTooltips(new String[]{"Link a powercard to card", "on the left"})).setLayoutHint(26, 30, 40, 18);
        Panel toplevel = (Panel)((Panel)new Panel(this.minecraft, (Screen)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChildren(new Widget[]{this.energyBar, allNone, allInput, allOutput, label, this.stats});
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.action(RFToolsPowerMessages.INSTANCE, "allnone", this.tileEntity, "setNone");
        this.window.action(RFToolsPowerMessages.INSTANCE, "allinput", this.tileEntity, "setInput");
        this.window.action(RFToolsPowerMessages.INSTANCE, "alloutput", this.tileEntity, "setOutput");
        this.window.action(RFToolsPowerMessages.INSTANCE, "clearstats", this.tileEntity, "clearStats");
        this.requestRF();
    }

    private void requestRF() {
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            ((DimensionalCellTileEntity)this.tileEntity).requestDataFromServer(RFToolsPowerMessages.INSTANCE, "getInfo", TypedMap.EMPTY);
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
        this.requestRF();
        this.stats.setTooltips(new String[]{"Power statistics. Press to clear:", "Inserted: " + DimensionalCellTileEntity.tooltipInserted, "Extracted: " + DimensionalCellTileEntity.tooltipExtracted});
        int maxValue = (DimensionalCellTileEntity.tooltipBlocks - DimensionalCellTileEntity.tooltipAdvancedBlocks - DimensionalCellTileEntity.tooltipSimpleBlocks) * (Integer)DimensionalCellConfiguration.rfPerNormalCell.get();
        maxValue += DimensionalCellTileEntity.tooltipAdvancedBlocks * (Integer)DimensionalCellConfiguration.rfPerNormalCell.get() * (Integer)DimensionalCellConfiguration.advancedFactor.get();
        this.energyBar.setMaxValue((long)(maxValue += DimensionalCellTileEntity.tooltipSimpleBlocks * (Integer)DimensionalCellConfiguration.rfPerNormalCell.get() / (Integer)DimensionalCellConfiguration.simpleFactor.get()));
        this.energyBar.setValue((long)DimensionalCellTileEntity.tooltipEnergy);
    }
}

