/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell.blocks;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.module.CapabilityModuleSupport;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.api.smartwrench.ISmartWrenchSelector;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.IAction;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.TeleportationTools;
import mcjty.rftoolsbase.api.infoscreen.CapabilityInformationScreenInfo;
import mcjty.rftoolsbase.api.infoscreen.IInformationScreenInfo;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.machineinfo.IMachineInformation;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellConfiguration;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellNetwork;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellSetup;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellBlock;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellContainer;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellInformationScreenInfo;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellType;
import mcjty.rftoolspower.modules.dimensionalcell.items.PowerCellCardItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;

public class DimensionalCellTileEntity
extends GenericTileEntity
implements ITickableTileEntity,
ISmartWrenchSelector {
    public static final String CMD_GET_INFO = "getInfo";
    public static final Key<Integer> PARAM_ENERGY = new Key("energy", Type.INTEGER);
    public static final Key<Integer> PARAM_BLOCKS = new Key("block", Type.INTEGER);
    public static final Key<Integer> PARAM_SIMPLEBLOCKS = new Key("simpleblocks", Type.INTEGER);
    public static final Key<Integer> PARAM_ADVANCEDBLOCKS = new Key("advancedblocks", Type.INTEGER);
    public static final Key<Long> PARAM_TOTAL_INSERTED = new Key("totalinserted", Type.LONG);
    public static final Key<Long> PARAM_TOTAL_EXTRACTED = new Key("totalextracted", Type.LONG);
    public static final Key<Integer> PARAM_RFPERTICK = new Key("rfpertick", Type.INTEGER);
    public static final Key<Double> PARAM_COSTFACTOR = new Key("costfactor", Type.DOUBLE);
    public static final String ACTION_SETNONE = "setNone";
    public static final String ACTION_SETINPUT = "setInput";
    public static final String ACTION_SETOUTPUT = "setOutput";
    public static final String ACTION_CLEARSTATS = "clearStats";
    public static int tooltipEnergy = 0;
    public static int tooltipBlocks = 0;
    public static int tooltipSimpleBlocks = 0;
    public static int tooltipAdvancedBlocks = 0;
    public static long tooltipInserted = 0L;
    public static long tooltipExtracted = 0L;
    public static int tooltipRfPerTick = 0;
    public static float tooltipCostFactor = 0.0f;
    private NoDirectionItemHander items = this.createItemHandler();
    private LazyOptional<NoDirectionItemHander> itemHandler = LazyOptional.of(() -> this.items);
    private LazyOptional<AutomationFilterItemHander> automationItemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private LazyOptional<IInformationScreenInfo> infoScreenInfo = LazyOptional.of(this::createScreenInfo);
    private LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    private LazyOptional<NullHandler> nullStorage = LazyOptional.of(() -> new NullHandler());
    private LazyOptional<IMachineInformation> infoHandler = LazyOptional.of(this::createMachineInfo);
    private LazyOptional<SidedHandler>[] sidedStorages = new LazyOptional[]{LazyOptional.of(() -> new SidedHandler(Direction.DOWN)), LazyOptional.of(() -> new SidedHandler(Direction.UP)), LazyOptional.of(() -> new SidedHandler(Direction.NORTH)), LazyOptional.of(() -> new SidedHandler(Direction.SOUTH)), LazyOptional.of(() -> new SidedHandler(Direction.WEST)), LazyOptional.of(() -> new SidedHandler(Direction.EAST))};
    private LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Dimensional Cell").containerSupplier((windowId, player) -> new DimensionalCellContainer((int)windowId, DimensionalCellContainer.CONTAINER_FACTORY, this.func_174877_v(), this)).itemHandler(this.itemHandler));
    private LazyOptional<IModuleSupport> moduleSupportHandler = LazyOptional.of(() -> new DefaultModuleSupport(0){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof PowerCellCardItem;
        }
    });
    private int networkId = -1;
    private int energy = 0;
    private long totalExtracted = 0L;
    private long totalInserted = 0L;
    private int lastRfPerTickIn = 0;
    private int lastRfPerTickOut = 0;
    private int powerIn = 0;
    private int powerOut = 0;
    private long lastTime = 0L;
    private static final EnumProperty<Mode>[] MODES = new EnumProperty[]{DimensionalCellBlock.DOWN, DimensionalCellBlock.UP, DimensionalCellBlock.NORTH, DimensionalCellBlock.SOUTH, DimensionalCellBlock.WEST, DimensionalCellBlock.EAST};

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction(ACTION_SETNONE, this::setAllNone), new DefaultAction(ACTION_SETINPUT, this::setAllInput), new DefaultAction(ACTION_SETOUTPUT, this::setAllOutput), new DefaultAction(ACTION_CLEARSTATS, () -> {
            this.totalExtracted = 0L;
            this.totalInserted = 0L;
            this.func_70296_d();
        })};
    }

    public DimensionalCellTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public int getLastRfPerTickIn() {
        return this.lastRfPerTickIn;
    }

    public int getLastRfPerTickOut() {
        return this.lastRfPerTickOut;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(int networkId) {
        this.networkId = networkId;
        this.func_70296_d();
    }

    @Nullable
    public DimensionalCellNetwork.Network getNetwork() {
        if (this.field_145850_b.field_72995_K) {
            return null;
        }
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return null;
        }
        DimensionalCellNetwork generatorNetwork = DimensionalCellNetwork.get(this.field_145850_b);
        return generatorNetwork.getOrCreateNetwork(networkId);
    }

    protected void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.energy = info.func_74762_e("energy");
        this.totalInserted = info.func_74763_f("totIns");
        this.totalExtracted = info.func_74763_f("totExt");
        this.networkId = info.func_74762_e("networkId");
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("energy", this.energy);
        info.func_74772_a("totIns", this.totalInserted);
        info.func_74772_a("totExt", this.totalExtracted);
        info.func_74768_a("networkId", this.networkId);
    }

    public Mode getMode(Direction side) {
        return (Mode)((Object)this.func_195044_w().func_177229_b(MODES[side.ordinal()]));
    }

    public void toggleMode(Direction side) {
        Mode mode = this.getMode(side);
        switch (mode) {
            case MODE_NONE: {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(MODES[side.ordinal()], (Comparable)((Object)Mode.MODE_INPUT)), 3);
                break;
            }
            case MODE_INPUT: {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(MODES[side.ordinal()], (Comparable)((Object)Mode.MODE_OUTPUT)), 3);
                break;
            }
            case MODE_OUTPUT: {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(MODES[side.ordinal()], (Comparable)((Object)Mode.MODE_NONE)), 3);
            }
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int energyStored;
            long time = this.field_145850_b.func_82737_E();
            if (this.lastTime == 0L) {
                this.lastTime = time;
            } else if (time > this.lastTime + 40L) {
                this.lastRfPerTickIn = (int)((long)this.powerIn / (time - this.lastTime));
                this.lastRfPerTickOut = (int)((long)this.powerOut / (time - this.lastTime));
                this.lastTime = time;
                this.powerIn = 0;
                this.powerOut = 0;
            }
            if (this.getDimensionalCellType().isCreative()) {
                int gain = 1000000;
                int networkId = this.getNetworkId();
                if (networkId == -1) {
                    this.receiveEnergyLocal(gain, false);
                } else {
                    this.receiveEnergyMulti(gain, false);
                }
            }
            if ((energyStored = this.getEnergyStored()) <= 0) {
                return;
            }
            this.handleChargingItem();
            this.sendOutEnergy();
        }
    }

    private void handleChargingItem() {
        ItemStack stack = this.items.getStackInSlot(2);
        if (stack.func_190926_b()) {
            return;
        }
        int rfToGive = Math.min((Integer)DimensionalCellConfiguration.CHARGEITEMPERTICK.get(), this.getEnergyStored());
        int received = (int)EnergyTools.receiveEnergy((ItemStack)stack, (long)rfToGive);
        if (received == 0) {
            return;
        }
        this.extractEnergyInternal(received, false, (Integer)DimensionalCellConfiguration.CHARGEITEMPERTICK.get());
    }

    private void sendOutEnergy() {
        int energyStored = this.getEnergyStored();
        for (Direction face : OrientationTools.DIRECTION_VALUES) {
            int rfToGive;
            int received;
            Direction opposite;
            BlockPos pos;
            TileEntity te;
            if (this.getMode(face) != Mode.MODE_OUTPUT || !EnergyTools.isEnergyTE((TileEntity)(te = this.field_145850_b.func_175625_s(pos = this.func_174877_v().func_177972_a(face))), (Direction)(opposite = face.func_176734_d())) || te instanceof DimensionalCellTileEntity && this.getNetworkId() != -1 && ((DimensionalCellTileEntity)te).getNetworkId() == this.getNetworkId()) continue;
            float factor = this.getCostFactor();
            int rfPerTick = this.getRfPerTickPerSide();
            if ((energyStored -= this.extractEnergyInternal(received = (int)EnergyTools.receiveEnergy((TileEntity)te, (Direction)opposite, (long)(rfToGive = Math.min(rfPerTick, (int)((float)energyStored / factor)))), false, Integer.MAX_VALUE)) <= 0) break;
        }
    }

    public float getCostFactor() {
        float factor;
        float infusedFactor = this.getInfusedFactor().floatValue();
        if (this.getNetworkId() == -1) {
            factor = 1.0f;
        } else {
            factor = this.getNetwork().calculateCostFactor(this.field_145850_b, this.getGlobalPos());
            factor = (factor - 1.0f) * (1.0f - infusedFactor / 2.0f) + 1.0f;
        }
        return factor;
    }

    private Float getInfusedFactor() {
        return (Float)this.infusableHandler.map(h -> Float.valueOf(h.getInfusedFactor())).orElse((Object)Float.valueOf(0.0f));
    }

    public int getRfPerTickPerSide() {
        return (int)((double)((Integer)DimensionalCellConfiguration.rfPerTick.get() * this.getPowerFactor() / (Integer)DimensionalCellConfiguration.simpleFactor.get()) * ((double)this.getInfusedFactor().floatValue() * 0.5 + 1.0));
    }

    private void handleCardRemoval() {
        DimensionalCellNetwork.Network network;
        if (!this.field_145850_b.field_72995_K && (network = this.getNetwork()) != null) {
            this.energy = network.extractEnergySingleBlock(this.getDimensionalCellType());
            network.remove(this.field_145850_b, this.getGlobalPos(), this.getDimensionalCellType());
            DimensionalCellNetwork.get(this.field_145850_b).save();
        }
        this.networkId = -1;
        this.func_70296_d();
    }

    private void handleCardInsertion() {
        ItemStack stack = this.items.getStackInSlot(0);
        int id = PowerCellCardItem.getId(stack);
        if (!this.field_145850_b.field_72995_K) {
            DimensionalCellNetwork channels = DimensionalCellNetwork.get(this.field_145850_b);
            if (id == -1) {
                id = channels.newChannel();
                PowerCellCardItem.setId(stack, id);
            }
            this.networkId = id;
            DimensionalCellNetwork.Network network = this.getNetwork();
            network.add(this.field_145850_b, this.getGlobalPos(), this.getDimensionalCellType());
            network.receiveEnergy(this.energy);
            channels.save();
        } else {
            this.networkId = id;
        }
        this.func_70296_d();
    }

    private DimensionalCellType getDimensionalCellType() {
        return DimensionalCellBlock.getType(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
    }

    private int getPowerFactor() {
        if (this.getDimensionalCellType().isSimple()) {
            return 1;
        }
        return this.getDimensionalCellType().isAdvanced() ? (Integer)DimensionalCellConfiguration.advancedFactor.get() * (Integer)DimensionalCellConfiguration.simpleFactor.get() : (Integer)DimensionalCellConfiguration.simpleFactor.get();
    }

    public int getEnergy() {
        return this.energy;
    }

    public GlobalCoordinate getGlobalPos() {
        return new GlobalCoordinate(this.func_174877_v(), this.field_145850_b.func_201675_m().func_186058_p());
    }

    public long getTotalExtracted() {
        return this.totalExtracted;
    }

    public long getTotalInserted() {
        return this.totalInserted;
    }

    public void resetTotalExtracted() {
        this.totalExtracted = 0L;
    }

    public void resetTotalInserted() {
        this.totalInserted = 0L;
    }

    public int receiveEnergyFacing(Direction from, int maxReceive, boolean simulate) {
        if (this.getMode(from) != Mode.MODE_INPUT) {
            return 0;
        }
        maxReceive = Math.min(maxReceive, this.getRfPerTickPerSide());
        int networkId = this.getNetworkId();
        int received = networkId == -1 ? this.receiveEnergyLocal(maxReceive, simulate) : this.receiveEnergyMulti(maxReceive, simulate);
        if (!simulate) {
            this.totalInserted += (long)received;
            this.powerIn += received;
            this.func_70296_d();
        }
        return received;
    }

    private int receiveEnergyMulti(int maxReceive, boolean simulate) {
        if (this.field_145850_b.field_72995_K) {
            return 0;
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        int totEnergy = network.calculateMaximumEnergy();
        int maxInsert = Math.min(totEnergy - network.getEnergy(), maxReceive);
        if (maxInsert > 0 && !simulate) {
            maxInsert = network.receiveEnergy(maxInsert);
            DimensionalCellNetwork.get(this.field_145850_b).save();
        }
        return this.getDimensionalCellType().isCreative() ? maxReceive : maxInsert;
    }

    private int receiveEnergyLocal(int maxReceive, boolean simulate) {
        long capacityL = (long)((Integer)DimensionalCellConfiguration.rfPerNormalCell.get()).intValue() * (long)this.getPowerFactor() / (long)((Integer)DimensionalCellConfiguration.simpleFactor.get()).intValue();
        int capacity = capacityL > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)capacityL;
        int maxInsert = Math.min(capacity - this.energy, maxReceive);
        if (maxInsert > 0 && !simulate) {
            this.energy += maxInsert;
            this.func_70296_d();
        }
        return this.getDimensionalCellType().isCreative() ? maxReceive : maxInsert;
    }

    private int extractEnergyInternal(int maxExtract, boolean simulate, int maximum) {
        int networkId = this.getNetworkId();
        int extracted = networkId == -1 ? this.extractEnergyLocal(maxExtract, simulate, maximum) : this.extractEnergyMulti(maxExtract, simulate, maximum);
        if (!simulate) {
            this.totalExtracted += (long)extracted;
            this.powerOut += extracted;
            this.func_70296_d();
        }
        return extracted;
    }

    private int extractEnergyMulti(int maxExtract, boolean simulate, int maximum) {
        if (this.field_145850_b.field_72995_K) {
            return 0;
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        if (maxExtract > maximum) {
            maxExtract = maximum;
        }
        if (!simulate) {
            maxExtract = network.extractEnergy(maxExtract);
            DimensionalCellNetwork.get(this.field_145850_b).save();
        }
        return maxExtract;
    }

    private int extractEnergyLocal(int maxExtract, boolean simulate, int maximum) {
        if (maxExtract > this.energy) {
            maxExtract = this.energy;
        }
        if (maxExtract > maximum) {
            maxExtract = maximum;
        }
        if (!simulate) {
            this.energy -= maxExtract;
            this.func_70296_d();
        }
        return maxExtract;
    }

    public int getEnergyStored() {
        if (this.field_145850_b.field_72995_K) {
            return 0;
        }
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return this.energy;
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        return network.getEnergy();
    }

    public int getMaxEnergyStored() {
        if (this.field_145850_b.field_72995_K) {
            return 0;
        }
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return (Integer)DimensionalCellConfiguration.rfPerNormalCell.get() * this.getPowerFactor() / (Integer)DimensionalCellConfiguration.simpleFactor.get();
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        return network.calculateMaximumEnergy();
    }

    public void setAllOutput() {
        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_195044_w().func_206870_a(DimensionalCellBlock.DOWN, (Comparable)((Object)Mode.MODE_OUTPUT))).func_206870_a(DimensionalCellBlock.UP, (Comparable)((Object)Mode.MODE_OUTPUT))).func_206870_a(DimensionalCellBlock.NORTH, (Comparable)((Object)Mode.MODE_OUTPUT))).func_206870_a(DimensionalCellBlock.SOUTH, (Comparable)((Object)Mode.MODE_OUTPUT))).func_206870_a(DimensionalCellBlock.WEST, (Comparable)((Object)Mode.MODE_OUTPUT))).func_206870_a(DimensionalCellBlock.EAST, (Comparable)((Object)Mode.MODE_OUTPUT)), 3);
    }

    private void setAllInput() {
        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_195044_w().func_206870_a(DimensionalCellBlock.DOWN, (Comparable)((Object)Mode.MODE_INPUT))).func_206870_a(DimensionalCellBlock.UP, (Comparable)((Object)Mode.MODE_INPUT))).func_206870_a(DimensionalCellBlock.NORTH, (Comparable)((Object)Mode.MODE_INPUT))).func_206870_a(DimensionalCellBlock.SOUTH, (Comparable)((Object)Mode.MODE_INPUT))).func_206870_a(DimensionalCellBlock.WEST, (Comparable)((Object)Mode.MODE_INPUT))).func_206870_a(DimensionalCellBlock.EAST, (Comparable)((Object)Mode.MODE_INPUT)), 3);
    }

    private void setAllNone() {
        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_195044_w().func_206870_a(DimensionalCellBlock.DOWN, (Comparable)((Object)Mode.MODE_NONE))).func_206870_a(DimensionalCellBlock.UP, (Comparable)((Object)Mode.MODE_NONE))).func_206870_a(DimensionalCellBlock.NORTH, (Comparable)((Object)Mode.MODE_NONE))).func_206870_a(DimensionalCellBlock.SOUTH, (Comparable)((Object)Mode.MODE_NONE))).func_206870_a(DimensionalCellBlock.WEST, (Comparable)((Object)Mode.MODE_NONE))).func_206870_a(DimensionalCellBlock.EAST, (Comparable)((Object)Mode.MODE_NONE)), 3);
    }

    public void selectBlock(PlayerEntity player, BlockPos pos) {
        DimensionalCellTileEntity.dumpNetwork(player, this);
    }

    public static void dumpNetwork(PlayerEntity player, DimensionalCellTileEntity dimensionalCellTileEntity) {
        DimensionalCellNetwork.Network network = dimensionalCellTileEntity.getNetwork();
        Set<GlobalCoordinate> blocks = network.getBlocks();
        blocks.forEach(b -> {
            String msg;
            World w = TeleportationTools.getWorldForDimension((DimensionType)b.getDimension());
            if (w == null) {
                msg = "dimension missing!";
            } else {
                Block block = w.func_180495_p(b.getCoordinate()).func_177230_c();
                msg = block == DimensionalCellSetup.DIMENSIONAL_CELL.get() ? "normal" : (block == DimensionalCellSetup.DIMENSIONAL_CELL_ADVANCED.get() ? "advanced" : (block == DimensionalCellSetup.DIMENSIONAL_CELL_CREATIVE.get() ? "creative" : "not a powercell!"));
                TileEntity te = w.func_175625_s(b.getCoordinate());
                if (te instanceof DimensionalCellTileEntity) {
                    DimensionalCellTileEntity power = (DimensionalCellTileEntity)te;
                    msg = msg + " (+:" + power.getTotalInserted() + ", -:" + power.getTotalExtracted() + ")";
                }
            }
            Logging.message((PlayerEntity)player, (String)("Block: " + BlockPosTools.toString((BlockPos)b.getCoordinate()) + " (" + b.getDimension() + "): " + msg));
        });
    }

    public TypedMap executeWithResult(String command, TypedMap args) {
        TypedMap rc = super.executeWithResult(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GET_INFO.equals(command)) {
            if (this.networkId == -1) {
                return TypedMap.builder().put(PARAM_ENERGY, (Object)this.getEnergy()).put(PARAM_BLOCKS, (Object)1).put(PARAM_SIMPLEBLOCKS, (Object)(this.getDimensionalCellType().isSimple() ? 1 : 0)).put(PARAM_ADVANCEDBLOCKS, (Object)(this.getDimensionalCellType().isAdvanced() ? 1 : 0)).put(PARAM_TOTAL_INSERTED, (Object)this.getTotalInserted()).put(PARAM_TOTAL_EXTRACTED, (Object)this.getTotalExtracted()).put(PARAM_RFPERTICK, (Object)this.getRfPerTickPerSide()).put(PARAM_COSTFACTOR, (Object)1.0).build();
            }
            DimensionalCellNetwork.Network network = this.getNetwork();
            return TypedMap.builder().put(PARAM_ENERGY, (Object)network.getEnergy()).put(PARAM_BLOCKS, (Object)network.getBlockCount()).put(PARAM_SIMPLEBLOCKS, (Object)network.getSimpleBlockCount()).put(PARAM_ADVANCEDBLOCKS, (Object)network.getAdvancedBlockCount()).put(PARAM_TOTAL_INSERTED, (Object)this.getTotalInserted()).put(PARAM_TOTAL_EXTRACTED, (Object)this.getTotalExtracted()).put(PARAM_RFPERTICK, (Object)this.getRfPerTickPerSide()).put(PARAM_COSTFACTOR, (Object)this.getCostFactor()).build();
        }
        return null;
    }

    public boolean receiveDataFromServer(String command, @Nonnull TypedMap result) {
        boolean rc = super.receiveDataFromServer(command, result);
        if (rc) {
            return true;
        }
        if (CMD_GET_INFO.equals(command)) {
            tooltipEnergy = (Integer)result.get(PARAM_ENERGY);
            tooltipBlocks = (Integer)result.get(PARAM_BLOCKS);
            tooltipSimpleBlocks = (Integer)result.get(PARAM_SIMPLEBLOCKS);
            tooltipAdvancedBlocks = (Integer)result.get(PARAM_ADVANCEDBLOCKS);
            tooltipInserted = (Long)result.get(PARAM_TOTAL_INSERTED);
            tooltipExtracted = (Long)result.get(PARAM_TOTAL_EXTRACTED);
            tooltipRfPerTick = (Integer)result.get(PARAM_RFPERTICK);
            tooltipCostFactor = ((Double)result.get(PARAM_COSTFACTOR)).floatValue();
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (facing == null) {
                return this.nullStorage.cast();
            }
            return this.sidedStorages[facing.ordinal()].cast();
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.automationItemHandler.cast();
        }
        if (capability == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        if (capability == CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY) {
            return this.infoHandler.cast();
        }
        if (capability == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (capability == CapabilityModuleSupport.MODULE_CAPABILITY) {
            return this.moduleSupportHandler.cast();
        }
        if (capability == CapabilityInformationScreenInfo.INFORMATION_SCREEN_INFO_CAPABILITY) {
            return this.infoScreenInfo.cast();
        }
        return super.getCapability(capability, facing);
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander(this, DimensionalCellContainer.CONTAINER_FACTORY){

            public boolean isItemValid(int index, @Nonnull ItemStack stack) {
                if (index == 0 && stack.func_77973_b() != DimensionalCellSetup.POWERCELL_CARD.get()) {
                    return false;
                }
                return index != 1 || stack.func_77973_b() == DimensionalCellSetup.POWERCELL_CARD.get();
            }

            protected void onUpdate(int index) {
                super.onUpdate(index);
                if (index == 0) {
                    if (this.getStackInSlot(index).func_190926_b()) {
                        DimensionalCellTileEntity.this.handleCardRemoval();
                    } else {
                        DimensionalCellTileEntity.this.handleCardInsertion();
                    }
                } else if (index == 1 && !this.getStackInSlot(index).func_190926_b()) {
                    PowerCellCardItem.setId(this.getStackInSlot(index), DimensionalCellTileEntity.this.networkId);
                }
            }
        };
    }

    @Nonnull
    private IInformationScreenInfo createScreenInfo() {
        return new DimensionalCellInformationScreenInfo(this);
    }

    private IMachineInformation createMachineInfo() {
        return new IMachineInformation(){
            private final String[] TAGS = new String[]{"rfpertick_out", "rfpertick_in", "rftotal_in", "rftotal_out"};
            private final String[] TAG_DESCRIPTIONS = new String[]{"The current RF/t output given by this block (last 2 seconds)", "The current RF/t input received by this block (last 2 seconds)", "The total RF/t output given by this block", "The current RF/t input received by this block"};

            public int getTagCount() {
                return this.TAGS.length;
            }

            public String getTagName(int index) {
                return this.TAGS[index];
            }

            public String getTagDescription(int index) {
                return this.TAG_DESCRIPTIONS[index];
            }

            public String getData(int index, long millis) {
                switch (index) {
                    case 0: {
                        return DimensionalCellTileEntity.this.lastRfPerTickOut + "RF/t";
                    }
                    case 1: {
                        return DimensionalCellTileEntity.this.lastRfPerTickIn + "RF/t";
                    }
                    case 2: {
                        return DimensionalCellTileEntity.this.totalExtracted + "RF";
                    }
                    case 3: {
                        return DimensionalCellTileEntity.this.totalInserted + "RF";
                    }
                }
                return null;
            }
        };
    }

    private class NullHandler
    implements IEnergyStorage {
        private NullHandler() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return DimensionalCellTileEntity.this.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return DimensionalCellTileEntity.this.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return false;
        }
    }

    private class SidedHandler
    implements IEnergyStorage {
        private final Direction facing;

        private SidedHandler(Direction facing) {
            this.facing = facing;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return DimensionalCellTileEntity.this.receiveEnergyFacing(this.facing, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return DimensionalCellTileEntity.this.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return DimensionalCellTileEntity.this.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }

    public static enum Mode implements IStringSerializable
    {
        MODE_NONE("none", "overlay_none"),
        MODE_INPUT("input", "overlay_in"),
        MODE_OUTPUT("output", "overlay_out");

        private final String name;
        private final String overlayName;

        private Mode(String name, String overlayName) {
            this.name = name;
            this.overlayName = overlayName;
        }

        public String getOverlayName() {
            return this.overlayName;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

