/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.TeleportationTools;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolspower.RFToolsPower;
import mcjty.rftoolspower.compat.RFToolsDimensionChecker;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellConfiguration;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellSetup;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellBlock;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellType;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class DimensionalCellNetwork
extends AbstractWorldData<DimensionalCellNetwork> {
    private static final String DIMENSIONALCELL_NETWORK_NAME = "RFToolsDimensionalCellNetwork";
    private int lastId = 0;
    private final Map<Integer, Network> networks = new HashMap<Integer, Network>();

    public DimensionalCellNetwork() {
        super(DIMENSIONALCELL_NETWORK_NAME);
    }

    public static DimensionalCellNetwork get(World world) {
        return (DimensionalCellNetwork)DimensionalCellNetwork.getData((World)world, DimensionalCellNetwork::new, (String)DIMENSIONALCELL_NETWORK_NAME);
    }

    public Network getOrCreateNetwork(int id) {
        Network channel = this.networks.get(id);
        if (channel == null) {
            channel = new Network();
            this.networks.put(id, channel);
        }
        return channel;
    }

    public Network getChannel(int id) {
        return this.networks.get(id);
    }

    public void deleteChannel(int id) {
        this.networks.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    public void func_76184_a(CompoundNBT tagCompound) {
        this.networks.clear();
        ListNBT lst = tagCompound.func_150295_c("networks", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundNBT tc = lst.func_150305_b(i);
            int channel = tc.func_74762_e("channel");
            Network value = new Network();
            value.readFromNBT(tc);
            this.networks.put(channel, value);
        }
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public CompoundNBT func_189551_b(CompoundNBT tagCompound) {
        ListNBT lst = new ListNBT();
        for (Map.Entry<Integer, Network> entry : this.networks.entrySet()) {
            CompoundNBT tc = new CompoundNBT();
            tc.func_74768_a("channel", entry.getKey().intValue());
            entry.getValue().writeToNBT(tc);
            lst.add((Object)tc);
        }
        tagCompound.func_218657_a("networks", (INBT)lst);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }

    public static class Network {
        private int energy = 0;
        private Set<GlobalCoordinate> blocks = new HashSet<GlobalCoordinate>();
        private int simpleBlocks = 0;
        private int advancedBlocks = 0;
        private Map<GlobalCoordinate, Float> costFactor = null;

        public Set<GlobalCoordinate> getBlocks() {
            return this.blocks;
        }

        public int getBlockCount() {
            return this.blocks.size();
        }

        public int getAdvancedBlockCount() {
            return this.advancedBlocks;
        }

        public int getSimpleBlockCount() {
            return this.simpleBlocks;
        }

        public int calculateMaximumEnergy() {
            long totEnergyLong = (long)((Integer)DimensionalCellConfiguration.rfPerNormalCell.get()).intValue() * (long)(this.getBlockCount() - this.getAdvancedBlockCount() - this.getSimpleBlockCount()) + (long)((Integer)DimensionalCellConfiguration.rfPerNormalCell.get()).intValue() * (long)((Integer)DimensionalCellConfiguration.advancedFactor.get()).intValue() * (long)this.getAdvancedBlockCount() + (long)((Integer)DimensionalCellConfiguration.rfPerNormalCell.get()).intValue() * (long)this.getSimpleBlockCount() / (long)((Integer)DimensionalCellConfiguration.simpleFactor.get()).intValue();
            if (totEnergyLong > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)totEnergyLong;
        }

        public void updateNetwork(World w) {
            this.advancedBlocks = 0;
            this.simpleBlocks = 0;
            HashSet<GlobalCoordinate> copy = new HashSet<GlobalCoordinate>(this.blocks);
            this.blocks.clear();
            for (GlobalCoordinate c : copy) {
                World world = TeleportationTools.getWorldForDimension((DimensionType)c.getDimension());
                BlockState state = world.func_180495_p(c.getCoordinate());
                if (state.func_177230_c() == DimensionalCellSetup.DIMENSIONAL_CELL.get()) {
                    this.blocks.add(c);
                    continue;
                }
                if (DimensionalCellBlock.getType(state.func_177230_c()).isAdvanced()) {
                    this.blocks.add(c);
                    ++this.advancedBlocks;
                    continue;
                }
                if (DimensionalCellBlock.getType(state.func_177230_c()).isSimple()) {
                    this.blocks.add(c);
                    ++this.simpleBlocks;
                    continue;
                }
                Logging.log((String)"Warning! Powercell network data was not up-to-date!");
            }
        }

        public void add(World world, GlobalCoordinate g, DimensionalCellType type) {
            if (!this.blocks.contains(g)) {
                this.blocks.add(g);
                this.costFactor = null;
                if (type.isAdvanced()) {
                    ++this.advancedBlocks;
                }
                if (type.isSimple()) {
                    ++this.simpleBlocks;
                }
                this.updateNetwork(world);
            }
        }

        public void remove(World world, GlobalCoordinate g, DimensionalCellType type) {
            if (this.blocks.contains(g)) {
                this.blocks.remove(g);
                this.costFactor = null;
                if (type.isAdvanced()) {
                    --this.advancedBlocks;
                }
                if (type.isSimple()) {
                    --this.simpleBlocks;
                }
                this.updateNetwork(world);
            }
        }

        private double calculateBlobDistance(World world, Set<GlobalCoordinate> blob1, Set<GlobalCoordinate> blob2) {
            GlobalCoordinate c1 = blob1.iterator().next();
            GlobalCoordinate c2 = blob2.iterator().next();
            boolean dim1rftools = RFToolsPower.setup.rftoolsDimensions && RFToolsDimensionChecker.isRFToolsDimension(world, c1.getDimension());
            boolean dim2rftools = RFToolsPower.setup.rftoolsDimensions && RFToolsDimensionChecker.isRFToolsDimension(world, c2.getDimension());
            double rftoolsdimMult = 1.0;
            if (dim1rftools) {
                rftoolsdimMult *= ((Double)DimensionalCellConfiguration.powerCellRFToolsDimensionAdvantage.get()).doubleValue();
            }
            if (dim2rftools) {
                rftoolsdimMult *= ((Double)DimensionalCellConfiguration.powerCellRFToolsDimensionAdvantage.get()).doubleValue();
            }
            if (c1.getDimension() != c2.getDimension()) {
                return (Double)DimensionalCellConfiguration.powerCellDistanceCap.get() * rftoolsdimMult;
            }
            double dist = Math.sqrt(c1.getCoordinate().func_177951_i((Vec3i)c2.getCoordinate()));
            if (dist > (Double)DimensionalCellConfiguration.powerCellDistanceCap.get()) {
                dist = (Double)DimensionalCellConfiguration.powerCellDistanceCap.get();
            } else if (dist < (Double)DimensionalCellConfiguration.powerCellMinDistance.get()) {
                dist = (Double)DimensionalCellConfiguration.powerCellMinDistance.get();
            }
            return dist * rftoolsdimMult;
        }

        private void updateCostFactor(World world) {
            if (this.costFactor == null) {
                this.costFactor = new HashMap<GlobalCoordinate, Float>();
                ArrayList<Set<GlobalCoordinate>> blobs = new ArrayList<Set<GlobalCoordinate>>();
                this.getBlobs(blobs);
                for (Set set : blobs) {
                    double totalfactor = 1.0;
                    for (Set set2 : blobs) {
                        if (set2 == set) continue;
                        double dist = this.calculateBlobDistance(world, set, set2);
                        double part = (double)set2.size() / (double)this.blocks.size();
                        double factor = 1.0 + dist / (Double)DimensionalCellConfiguration.powerCellDistanceCap.get() * ((Double)DimensionalCellConfiguration.powerCellCostFactor.get() - 1.0) * part;
                        totalfactor += factor;
                    }
                    totalfactor /= (double)blobs.size();
                    for (GlobalCoordinate globalCoordinate : set) {
                        this.costFactor.put(globalCoordinate, Float.valueOf((float)totalfactor));
                    }
                }
            }
        }

        private void getBlob(Set<GlobalCoordinate> todo, Set<GlobalCoordinate> blob, GlobalCoordinate coordinate) {
            blob.add(coordinate);
            for (Direction facing : OrientationTools.DIRECTION_VALUES) {
                GlobalCoordinate offset = new GlobalCoordinate(coordinate.getCoordinate().func_177972_a(facing), coordinate.getDimension());
                if (!todo.contains(offset)) continue;
                todo.remove(offset);
                this.getBlob(todo, blob, offset);
            }
        }

        private void getBlobs(List<Set<GlobalCoordinate>> blobs) {
            HashSet<GlobalCoordinate> todo = new HashSet<GlobalCoordinate>(this.blocks);
            while (!todo.isEmpty()) {
                GlobalCoordinate coordinate = (GlobalCoordinate)todo.iterator().next();
                todo.remove(coordinate);
                HashSet<GlobalCoordinate> blob = new HashSet<GlobalCoordinate>();
                this.getBlob(todo, blob, coordinate);
                blobs.add(blob);
            }
        }

        public float calculateCostFactor(World world, GlobalCoordinate g) {
            this.updateCostFactor(world);
            Float f = this.costFactor.get(g);
            return f == null ? 1.0f : f.floatValue();
        }

        public int getEnergySingleBlock(DimensionalCellType type) {
            int simpleBlockCount = Math.max(1, (this.blocks.size() - this.advancedBlocks - this.simpleBlocks) * (Integer)DimensionalCellConfiguration.simpleFactor.get() + this.advancedBlocks * (Integer)DimensionalCellConfiguration.advancedFactor.get() * (Integer)DimensionalCellConfiguration.simpleFactor.get() + this.simpleBlocks);
            long rc = this.energy / simpleBlockCount;
            if (type.isAdvanced()) {
                rc *= (long)((Integer)DimensionalCellConfiguration.advancedFactor.get() * (Integer)DimensionalCellConfiguration.simpleFactor.get());
            } else if (!type.isSimple()) {
                rc *= (long)((Integer)DimensionalCellConfiguration.simpleFactor.get()).intValue();
            }
            return rc > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)rc;
        }

        public int extractEnergySingleBlock(DimensionalCellType type) {
            return this.extractEnergy(this.getEnergySingleBlock(type));
        }

        public int getEnergy() {
            return this.energy;
        }

        public int extractEnergy(int amount) {
            if (amount > this.energy) {
                amount = this.energy;
            }
            this.energy -= amount;
            return amount;
        }

        public int receiveEnergy(int amount) {
            if (amount > Integer.MAX_VALUE - this.energy) {
                amount = Integer.MAX_VALUE - this.energy;
            }
            this.energy += amount;
            return amount;
        }

        public void setEnergy(int energy) {
            this.energy = energy;
        }

        public void writeToNBT(CompoundNBT tagCompound) {
            tagCompound.func_74768_a("energy", this.energy);
            tagCompound.func_74768_a("advanced", this.advancedBlocks);
            tagCompound.func_74768_a("simple", this.simpleBlocks);
            ListNBT list = new ListNBT();
            for (GlobalCoordinate block : this.blocks) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74778_a("dim", block.getDimension().getRegistryName().toString());
                tag.func_74768_a("x", block.getCoordinate().func_177958_n());
                tag.func_74768_a("y", block.getCoordinate().func_177956_o());
                tag.func_74768_a("z", block.getCoordinate().func_177952_p());
                list.add((Object)tag);
            }
            tagCompound.func_218657_a("blocks", (INBT)list);
        }

        public void readFromNBT(CompoundNBT tagCompound) {
            this.energy = tagCompound.func_74762_e("energy");
            this.advancedBlocks = tagCompound.func_74762_e("advanced");
            this.simpleBlocks = tagCompound.func_74762_e("simple");
            this.blocks.clear();
            ListNBT list = tagCompound.func_150295_c("blocks", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT tag = list.func_150305_b(i);
                ResourceLocation id = new ResourceLocation(tag.func_74779_i("dim"));
                DimensionType type = DimensionType.func_193417_a((ResourceLocation)id);
                if (type == null) {
                    Logging.logError((String)("Unknown dimension '" + id.toString() + "'!"));
                    continue;
                }
                this.blocks.add(new GlobalCoordinate(new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")), type));
            }
        }
    }
}

