/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.datagen;

import mcjty.lib.datagen.BaseBlockStateProvider;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellSetup;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellBlock;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellTileEntity;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class BlockStates
extends BaseBlockStateProvider {
    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "rftoolspower", exFileHelper);
    }

    protected void registerStatesAndModels() {
        BlockModelBuilder dimCellFrame = (BlockModelBuilder)this.models().getBuilder("block/dimcell/main");
        this.floatingCube(dimCellFrame, 0.0f, 0.0f, 0.0f, 1.0f, 16.0f, 1.0f);
        this.floatingCube(dimCellFrame, 15.0f, 0.0f, 0.0f, 16.0f, 16.0f, 1.0f);
        this.floatingCube(dimCellFrame, 0.0f, 0.0f, 15.0f, 1.0f, 16.0f, 16.0f);
        this.floatingCube(dimCellFrame, 15.0f, 0.0f, 15.0f, 16.0f, 16.0f, 16.0f);
        this.floatingCube(dimCellFrame, 1.0f, 0.0f, 0.0f, 15.0f, 1.0f, 1.0f);
        this.floatingCube(dimCellFrame, 1.0f, 15.0f, 0.0f, 15.0f, 16.0f, 1.0f);
        this.floatingCube(dimCellFrame, 1.0f, 0.0f, 15.0f, 15.0f, 1.0f, 16.0f);
        this.floatingCube(dimCellFrame, 1.0f, 15.0f, 15.0f, 15.0f, 16.0f, 16.0f);
        this.floatingCube(dimCellFrame, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 15.0f);
        this.floatingCube(dimCellFrame, 15.0f, 0.0f, 1.0f, 16.0f, 1.0f, 15.0f);
        this.floatingCube(dimCellFrame, 0.0f, 15.0f, 1.0f, 1.0f, 16.0f, 15.0f);
        this.floatingCube(dimCellFrame, 15.0f, 15.0f, 1.0f, 16.0f, 16.0f, 15.0f);
        this.floatingCube(dimCellFrame, 1.0f, 1.0f, 1.0f, 15.0f, 15.0f, 15.0f);
        dimCellFrame.texture("window", this.modLoc("block/dimensionalcellwindows"));
        this.createDimensionalCellModel((Block)DimensionalCellSetup.DIMENSIONAL_CELL.get(), "", dimCellFrame);
        this.createDimensionalCellModel((Block)DimensionalCellSetup.DIMENSIONAL_CELL_SIMPLE.get(), "simple", dimCellFrame);
        this.createDimensionalCellModel((Block)DimensionalCellSetup.DIMENSIONAL_CELL_ADVANCED.get(), "advanced", dimCellFrame);
        this.createDimensionalCellModel((Block)DimensionalCellSetup.DIMENSIONAL_CELL_CREATIVE.get(), "creative", dimCellFrame);
    }

    private void floatingCube(BlockModelBuilder builder, float fx, float fy, float fz, float tx, float ty, float tz) {
        builder.element().from(fx, fy, fz).to(tx, ty, tz).allFaces((direction, faceBuilder) -> faceBuilder.texture("#window")).end();
    }

    private void createDimensionalCellModel(Block block, String suffix, BlockModelBuilder dimCellFrame) {
        BlockModelBuilder singleNone = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/dimcell/singlenone" + suffix)).element().from(3.0f, 3.0f, 3.0f).to(13.0f, 13.0f, 13.0f).face(Direction.DOWN).texture("#single").end().end()).texture("single", this.modLoc("block/dimensionalcell" + suffix));
        BlockModelBuilder singleIn = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/dimcell/singlein" + suffix)).element().from(3.0f, 3.0f, 3.0f).to(13.0f, 13.0f, 13.0f).face(Direction.DOWN).texture("#single").end().end()).texture("single", this.modLoc("block/dimensionalcellin" + suffix));
        BlockModelBuilder singleOut = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/dimcell/singleout" + suffix)).element().from(3.0f, 3.0f, 3.0f).to(13.0f, 13.0f, 13.0f).face(Direction.DOWN).texture("#single").end().end()).texture("single", this.modLoc("block/dimensionalcellout" + suffix));
        MultiPartBlockStateBuilder bld = this.getMultipartBuilder(block);
        bld.part().modelFile((ModelFile)dimCellFrame).addModel();
        BlockModelBuilder[] models = new BlockModelBuilder[]{singleNone, singleIn, singleOut};
        for (DimensionalCellTileEntity.Mode mode : DimensionalCellTileEntity.Mode.values()) {
            ((MultiPartBlockStateBuilder.PartBuilder)bld.part().modelFile((ModelFile)models[mode.ordinal()]).addModel()).condition(DimensionalCellBlock.DOWN, (Comparable[])new DimensionalCellTileEntity.Mode[]{mode});
            ((MultiPartBlockStateBuilder.PartBuilder)bld.part().modelFile((ModelFile)models[mode.ordinal()]).rotationX(180).addModel()).condition(DimensionalCellBlock.UP, (Comparable[])new DimensionalCellTileEntity.Mode[]{mode});
            ((MultiPartBlockStateBuilder.PartBuilder)bld.part().modelFile((ModelFile)models[mode.ordinal()]).rotationX(90).addModel()).condition(DimensionalCellBlock.SOUTH, (Comparable[])new DimensionalCellTileEntity.Mode[]{mode});
            ((MultiPartBlockStateBuilder.PartBuilder)bld.part().modelFile((ModelFile)models[mode.ordinal()]).rotationX(270).addModel()).condition(DimensionalCellBlock.NORTH, (Comparable[])new DimensionalCellTileEntity.Mode[]{mode});
            ((MultiPartBlockStateBuilder.PartBuilder)bld.part().modelFile((ModelFile)models[mode.ordinal()]).rotationY(90).rotationX(90).addModel()).condition(DimensionalCellBlock.WEST, (Comparable[])new DimensionalCellTileEntity.Mode[]{mode});
            ((MultiPartBlockStateBuilder.PartBuilder)bld.part().modelFile((ModelFile)models[mode.ordinal()]).rotationY(270).rotationX(90).addModel()).condition(DimensionalCellBlock.EAST, (Comparable[])new DimensionalCellTileEntity.Mode[]{mode});
        }
    }
}

