/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.client.FluxColorHandler;
import sonar.fluxnetworks.client.gui.GuiFluxAdminHome;
import sonar.fluxnetworks.client.gui.GuiFluxConfiguratorHome;
import sonar.fluxnetworks.client.gui.GuiFluxConnectorHome;
import sonar.fluxnetworks.client.mui.MUIIntegration;
import sonar.fluxnetworks.client.render.FluxStorageTileRenderer;
import sonar.fluxnetworks.common.item.AdminConfiguratorItem;
import sonar.fluxnetworks.common.item.FluxConfiguratorItem;
import sonar.fluxnetworks.common.registry.RegistryBlocks;
import sonar.fluxnetworks.common.registry.RegistryItems;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

@Mod.EventBusSubscriber(modid="fluxnetworks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientRegistration {
    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        FluxNetworks.LOGGER.info("Started Client Setup Event");
        FluxNetworks.LOGGER.info("Registering TileEntity Renderers");
        ClientRegistry.bindTileEntityRenderer(RegistryBlocks.BASIC_FLUX_STORAGE_TILE, FluxStorageTileRenderer::new);
        ClientRegistry.bindTileEntityRenderer(RegistryBlocks.HERCULEAN_FLUX_STORAGE_TILE, FluxStorageTileRenderer::new);
        ClientRegistry.bindTileEntityRenderer(RegistryBlocks.GARGANTUAN_FLUX_STORAGE_TILE, FluxStorageTileRenderer::new);
        FluxNetworks.LOGGER.info("Registering Render Types");
        RenderTypeLookup.setRenderLayer((Block)RegistryBlocks.FLUX_PLUG, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RegistryBlocks.FLUX_POINT, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RegistryBlocks.FLUX_CONTROLLER, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RegistryBlocks.BASIC_FLUX_STORAGE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RegistryBlocks.HERCULEAN_FLUX_STORAGE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RegistryBlocks.GARGANTUAN_FLUX_STORAGE, (RenderType)RenderType.func_228643_e_());
        FluxNetworks.LOGGER.info("Registering Screens");
        if (FluxConfig.enableGuiDebug && FluxNetworks.modernUILoaded) {
            MUIIntegration.init(event);
        } else {
            ScreenManager.func_216911_a(RegistryBlocks.CONTAINER_CONNECTOR, (container, inventory, windowID) -> {
                if (container == null) {
                    return null;
                }
                Object connector = container.connector;
                if (connector instanceof TileFluxCore) {
                    return new GuiFluxConnectorHome(inventory.field_70458_d, (TileFluxCore)connector);
                }
                if (connector instanceof FluxConfiguratorItem.ContainerProvider) {
                    return new GuiFluxConfiguratorHome(inventory.field_70458_d, (FluxConfiguratorItem.ContainerProvider)connector);
                }
                if (connector instanceof AdminConfiguratorItem.ContainerProvider) {
                    return new GuiFluxAdminHome(inventory.field_70458_d, (INetworkConnector)connector);
                }
                return null;
            });
        }
        FluxNetworks.LOGGER.info("Finished Client Setup Event");
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(ColorHandlerEvent.Item event) {
        FluxNetworks.LOGGER.info("Starting Registering Item Color Handlers");
        event.getItemColors().func_199877_a((IItemColor)FluxColorHandler.INSTANCE, new IItemProvider[]{RegistryBlocks.FLUX_CONTROLLER, RegistryBlocks.FLUX_POINT, RegistryBlocks.FLUX_PLUG, RegistryBlocks.BASIC_FLUX_STORAGE, RegistryBlocks.HERCULEAN_FLUX_STORAGE, RegistryBlocks.GARGANTUAN_FLUX_STORAGE});
        event.getItemColors().func_199877_a(FluxColorHandler::colorMultiplierForConfigurator, new IItemProvider[]{RegistryItems.FLUX_CONFIGURATOR});
        FluxNetworks.LOGGER.info("Finished Registering Item Color Handlers");
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(ColorHandlerEvent.Block event) {
        FluxNetworks.LOGGER.info("Starting Registering Block Color Handlers");
        event.getBlockColors().func_186722_a((IBlockColor)FluxColorHandler.INSTANCE, new Block[]{RegistryBlocks.FLUX_CONTROLLER, RegistryBlocks.FLUX_POINT, RegistryBlocks.FLUX_PLUG, RegistryBlocks.BASIC_FLUX_STORAGE, RegistryBlocks.HERCULEAN_FLUX_STORAGE, RegistryBlocks.GARGANTUAN_FLUX_STORAGE});
        FluxNetworks.LOGGER.info("Finished Registering Block Color Handlers");
    }
}

