/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.various.items;

import javax.annotation.Nonnull;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsbase.modules.various.items.FilterModuleContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Hand;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class FilterModuleInventory
implements IItemHandlerModifiable {
    private ItemStackList stacks = ItemStackList.create((int)30);
    private final PlayerEntity entityPlayer;

    public FilterModuleInventory(PlayerEntity player) {
        this.entityPlayer = player;
        CompoundNBT tagCompound = this.entityPlayer.func_184586_b(Hand.MAIN_HAND).func_196082_o();
        ListNBT bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.size(); ++i) {
            CompoundNBT nbtTagCompound = bufferTagList.func_150305_b(i);
            this.stacks.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)nbtTagCompound));
        }
    }

    public void setStackInSlot(int index, @Nonnull ItemStack stack) {
        if (index >= this.stacks.size()) {
            return;
        }
        if (FilterModuleContainer.CONTAINER_FACTORY.isGhostSlot(index)) {
            if (!stack.func_190926_b()) {
                ItemStack stack1 = stack.func_77946_l();
                if (index < 9) {
                    stack1.func_190920_e(1);
                }
                this.stacks.set(index, (Object)stack1);
            } else {
                this.stacks.set(index, (Object)ItemStack.field_190927_a);
            }
        } else {
            this.stacks.set(index, (Object)stack);
            if (!stack.func_190926_b() && stack.func_190916_E() > this.getSlots()) {
                int amount = this.getSlotLimit(index);
                if (amount <= 0) {
                    stack.func_190920_e(0);
                } else {
                    stack.func_190920_e(amount);
                }
            }
        }
        this.markDirty();
    }

    public int getSlots() {
        return 30;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.func_190926_b()) {
            if (stackInSlot.func_190916_E() >= Math.min(stackInSlot.func_77976_d(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    this.setStackInSlot(slot, copy);
                    this.markDirty();
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                this.setStackInSlot(slot, copy);
                this.markDirty();
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.setStackInSlot(slot, stack.func_77979_a(m));
                this.markDirty();
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(slot, stack);
            this.markDirty();
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (stackInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            if (stackInSlot.func_190916_E() < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.func_190916_E(), amount);
        ItemStack decrStackSize = this.decrStackSize(slot, m);
        this.markDirty();
        return decrStackSize;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public ItemStack getStackInSlot(int index) {
        return (ItemStack)this.stacks.get(index);
    }

    private ItemStack decrStackSize(int index, int amount) {
        if (index >= this.stacks.size()) {
            return ItemStack.field_190927_a;
        }
        if (!((ItemStack)this.stacks.get(index)).func_190926_b()) {
            if (((ItemStack)this.stacks.get(index)).func_190916_E() <= amount) {
                ItemStack old = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, (Object)ItemStack.field_190927_a);
                this.markDirty();
                return old;
            }
            ItemStack its = ((ItemStack)this.stacks.get(index)).func_77979_a(amount);
            if (((ItemStack)this.stacks.get(index)).func_190926_b()) {
                this.stacks.set(index, (Object)ItemStack.field_190927_a);
            }
            this.markDirty();
            return its;
        }
        return ItemStack.field_190927_a;
    }

    private void markDirty() {
        ItemStack heldItem = this.entityPlayer.func_184586_b(Hand.MAIN_HAND);
        if (!heldItem.func_190926_b()) {
            CompoundNBT tagCompound = heldItem.func_77978_p();
            FilterModuleInventory.convertItemsToNBT(tagCompound, this.stacks);
        }
    }

    public static void convertItemsToNBT(CompoundNBT tagCompound, ItemStackList stacks) {
        ListNBT bufferTagList = new ListNBT();
        for (ItemStack stack : stacks) {
            CompoundNBT nbtTagCompound = new CompoundNBT();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.add((Object)nbtTagCompound);
        }
        tagCompound.func_218657_a("Items", (INBT)bufferTagList);
    }

    private ItemStack removeStackFromSlot(int index) {
        ItemStack stack = this.getStackInSlot(index);
        this.setStackInSlot(index, ItemStack.field_190927_a);
        return stack;
    }
}

