/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.various;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.varia.ItemStackList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;

public class FilterModuleCache {
    private boolean matchDamage = true;
    private boolean oredictMode = false;
    private boolean blacklistMode = true;
    private boolean nbtMode = false;
    private boolean modMode = false;
    private ItemStackList stacks;
    private Set<Integer> oredictMatches = new HashSet<Integer>();

    public FilterModuleCache(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            ItemStack s;
            CompoundNBT nbtTagCompound;
            int i;
            this.matchDamage = tagCompound.func_74767_n("damageMode");
            this.oredictMode = tagCompound.func_74767_n("oredictMode");
            this.nbtMode = tagCompound.func_74767_n("nbtMode");
            this.modMode = tagCompound.func_74767_n("modMode");
            this.blacklistMode = "Black".equals(tagCompound.func_74779_i("blacklistMode"));
            ListNBT bufferTagList = tagCompound.func_150295_c("Items", 10);
            int cnt = 0;
            for (i = 0; i < bufferTagList.size(); ++i) {
                nbtTagCompound = bufferTagList.func_150305_b(i);
                s = ItemStack.func_199557_a((CompoundNBT)nbtTagCompound);
                if (s.func_190926_b()) continue;
                ++cnt;
            }
            this.stacks = ItemStackList.create((int)cnt);
            cnt = 0;
            for (i = 0; i < bufferTagList.size(); ++i) {
                nbtTagCompound = bufferTagList.func_150305_b(i);
                s = ItemStack.func_199557_a((CompoundNBT)nbtTagCompound);
                if (s.func_190926_b()) continue;
                this.stacks.set(cnt++, (Object)s);
                if (!this.oredictMode) continue;
            }
        } else {
            this.stacks = ItemStackList.EMPTY;
        }
    }

    public boolean match(ItemStack stack) {
        if (!stack.func_190926_b()) {
            boolean match = false;
            String modName = "";
            if (this.modMode) {
                modName = stack.func_77973_b().getRegistryName().func_110624_b();
            }
            match = this.oredictMode ? this.itemMatches(stack, modName) : this.itemMatches(stack, modName);
            return match != this.blacklistMode;
        }
        return false;
    }

    private boolean itemMatches(ItemStack stack, String modName) {
        if (this.stacks != null) {
            for (ItemStack itemStack : this.stacks) {
                if (this.matchDamage && itemStack.func_77952_i() != stack.func_77952_i() || this.nbtMode && !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)stack) || !(this.modMode ? modName.equals(itemStack.func_77973_b().getRegistryName().func_110624_b()) : itemStack.func_77973_b().equals(stack.func_77973_b()))) continue;
                return true;
            }
        }
        return false;
    }
}

