/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.informationscreen.blocks;

import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.infoscreen.CapabilityInformationScreenInfo;
import mcjty.rftoolsbase.api.infoscreen.IInformationScreenInfo;
import mcjty.rftoolsbase.modules.informationscreen.InformationScreenSetup;
import mcjty.rftoolsbase.modules.informationscreen.blocks.DefaultPowerInformationScreenInfo;
import mcjty.rftoolsbase.modules.informationscreen.blocks.InformationScreenBlock;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;

public class InformationScreenTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    private int mode = 0;
    private int cnt = 0;
    private long lastHudTime = 0L;
    private TypedMap clientData;

    public InformationScreenTileEntity() {
        super((TileEntityType)InformationScreenSetup.TYPE_INFORMATION_SCREEN.get());
    }

    public Direction getBlockOrientation() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof InformationScreenBlock) {
            return OrientationTools.getOrientationHoriz((BlockState)state);
        }
        return null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            --this.cnt;
            if (this.cnt <= 0) {
                this.cnt = 10;
                BlockPos offset = this.func_174877_v().func_177972_a(this.getBlockOrientation().func_176734_d());
                TileEntity te = this.field_145850_b.func_175625_s(offset);
                if (te != null) {
                    te.getCapability(CapabilityInformationScreenInfo.INFORMATION_SCREEN_INFO_CAPABILITY).ifPresent(h -> h.tick());
                }
            }
        }
    }

    public void toggleMode() {
        this.getInfo().ifPresent(h -> {
            int[] modes = h.getSupportedModes();
            int found = -1;
            for (int i = 0; i < modes.length; ++i) {
                if (modes[i] != this.mode) continue;
                found = i;
                break;
            }
            if (found != -1) {
                this.mode = modes[++found % modes.length];
                this.markDirtyClient();
            }
        });
    }

    public int getMode() {
        return this.mode;
    }

    protected void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.mode = info.func_74771_c("mode");
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.func_74774_a("mode", (byte)this.mode);
    }

    public void setClientData(TypedMap power) {
        this.clientData = power;
    }

    public TypedMap getClientData() {
        return this.clientData;
    }

    public long getLastUpdateTime() {
        return this.lastHudTime;
    }

    public void setLastUpdateTime(long t) {
        this.lastHudTime = t;
    }

    public LazyOptional<IInformationScreenInfo> getInfo() {
        BlockPos offset = this.func_174877_v().func_177972_a(this.getBlockOrientation().func_176734_d());
        TileEntity te = this.field_145850_b.func_175625_s(offset);
        if (te != null) {
            LazyOptional capability = te.getCapability(CapabilityInformationScreenInfo.INFORMATION_SCREEN_INFO_CAPABILITY);
            if (capability.isPresent()) {
                return capability.cast();
            }
            if (EnergyTools.isEnergyTE((TileEntity)te, (Direction)this.getBlockOrientation())) {
                return LazyOptional.of(() -> new DefaultPowerInformationScreenInfo(te));
            }
        }
        return LazyOptional.empty();
    }
}

