/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.util.FakePlayerManager;
import me.desht.modularrouters.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;

public class BlockUtil {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    private static BlockState getPlaceableState(BlockItemUseContext ctx) {
        try {
            BlockState res = null;
            World world = ctx.func_195991_k();
            BlockPos pos = ctx.func_195995_a();
            Item item = ctx.func_195996_i().func_77973_b();
            if (item instanceof BlockItem) {
                Block block = ((BlockItem)item).func_179223_d();
                res = block.func_196258_a(ctx);
            } else if (item instanceof IPlantable) {
                res = ((IPlantable)item).getPlant((IBlockReader)world, pos);
            } else if (item == Items.field_196130_bo) {
                res = BlockUtil.getCocoaBeanState(ctx);
            }
            if (res != null && !res.func_196955_c((IWorldReader)world, pos)) {
                res = null;
            }
            return res;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static BlockState getCocoaBeanState(BlockItemUseContext ctx) {
        for (Direction f : HORIZONTALS) {
            BlockState state = ctx.func_195991_k().func_180495_p(ctx.func_195995_a().func_177972_a(f));
            if (state.func_177230_c() != Blocks.field_196620_N) continue;
            ctx.func_195999_j().field_70177_z = BlockUtil.getYawFromFacing(f);
            return Blocks.field_150375_by.func_196258_a(ctx);
        }
        return null;
    }

    private static float getYawFromFacing(Direction facing) {
        switch (facing) {
            case WEST: {
                return 90.0f;
            }
            case NORTH: {
                return 180.0f;
            }
            case EAST: {
                return 270.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public static BlockState tryPlaceAsBlock(ItemStack toPlace, World world, BlockPos pos, Direction facing, Direction horizFacing) {
        BlockState currentState = world.func_180495_p(pos);
        FakePlayerManager.RouterFakePlayer fakePlayer = FakePlayerManager.getFakePlayer((ServerWorld)world, pos);
        if (fakePlayer == null) {
            return null;
        }
        fakePlayer.field_70177_z = BlockUtil.getYawFromFacing(facing);
        fakePlayer.func_184611_a(Hand.MAIN_HAND, toPlace);
        float hitX = (float)(fakePlayer.func_226277_ct_() - (double)pos.func_177958_n());
        float hitY = (float)(fakePlayer.func_226278_cu_() - (double)pos.func_177956_o());
        float hitZ = (float)(fakePlayer.func_226281_cx_() - (double)pos.func_177952_p());
        BlockRayTraceResult brtr = new BlockRayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, pos, false);
        BlockItemUseContext ctx = new BlockItemUseContext(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, brtr));
        if (!currentState.func_196953_a(ctx)) {
            return null;
        }
        BlockState newState = BlockUtil.getPlaceableState(ctx);
        if (newState != null) {
            BlockSnapshot snap = new BlockSnapshot((IWorld)world, pos, newState);
            fakePlayer.func_184611_a(Hand.MAIN_HAND, toPlace);
            BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(snap, Blocks.field_150350_a.func_176223_P(), (Entity)fakePlayer);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled() && world.func_180501_a(pos, newState, 3)) {
                fakePlayer.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                BlockItem.func_179224_a((World)world, (PlayerEntity)fakePlayer, (BlockPos)pos, (ItemStack)toPlace);
                newState.func_177230_c().func_180633_a(world, pos, newState, (LivingEntity)fakePlayer, toPlace);
                return newState;
            }
        }
        return null;
    }

    public static boolean tryPlaceBlock(BlockState newState, World world, BlockPos pos) {
        FakePlayerManager.RouterFakePlayer fakePlayer = FakePlayerManager.getFakePlayer((ServerWorld)world, pos);
        if (fakePlayer == null) {
            return false;
        }
        BlockSnapshot snap = new BlockSnapshot((IWorld)world, pos, newState);
        BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(snap, Blocks.field_150350_a.func_176223_P(), (Entity)fakePlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled() && world.func_175656_a(pos, newState);
    }

    public static BreakResult tryBreakBlock(World world, BlockPos pos, Filter filter, ItemStack pickaxe) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockReader)world, pos) || state.func_185887_b((IBlockReader)world, pos) < 0.0f || block instanceof FlowingFluidBlock) {
            return BreakResult.NOT_BROKEN;
        }
        FakePlayerManager.RouterFakePlayer fakePlayer = FakePlayerManager.getFakePlayer((ServerWorld)world, pos);
        fakePlayer.func_184611_a(Hand.MAIN_HAND, pickaxe);
        if (MRConfig.Common.Module.breakerHarvestLevelLimit && !ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)fakePlayer, (IBlockReader)world, (BlockPos)pos)) {
            return BreakResult.NOT_BROKEN;
        }
        List<ItemStack> allDrops = BlockUtil.getDrops(world, pos, (PlayerEntity)fakePlayer, pickaxe);
        Map<Boolean, List<ItemStack>> groups = allDrops.stream().collect(Collectors.partitioningBy(filter));
        if (allDrops.isEmpty() || !groups.get(true).isEmpty()) {
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(world, pos, state, (PlayerEntity)fakePlayer);
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            if (!breakEvent.isCanceled()) {
                world.func_217377_a(pos, false);
                return new BreakResult(true, groups);
            }
        }
        return BreakResult.NOT_BROKEN;
    }

    private static List<ItemStack> getDrops(World world, BlockPos pos, PlayerEntity player, ItemStack pickaxe) {
        BlockState state = world.func_180495_p(pos);
        LootContext.Builder builder = new LootContext.Builder((ServerWorld)world).func_216015_a(LootParameters.field_216286_f, (Object)pos).func_216015_a(LootParameters.field_216287_g, (Object)state).func_216015_a(LootParameters.field_216289_i, (Object)pickaxe).func_216015_a(LootParameters.field_216281_a, (Object)player);
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            builder = builder.func_216015_a(LootParameters.field_216288_h, (Object)te);
        }
        List drops = state.func_215693_a(builder);
        NonNullList dropsN = NonNullList.func_191196_a();
        dropsN.addAll((Collection)drops);
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)pickaxe);
        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)pickaxe) > 0;
        float dropChance = ForgeEventFactory.fireBlockHarvesting((NonNullList)dropsN, (World)world, (BlockPos)pos, (BlockState)state, (int)fortune, (float)1.0f, (boolean)silkTouch, (PlayerEntity)player);
        return drops.stream().filter(s -> world.field_73012_v.nextFloat() <= dropChance).collect(Collectors.toList());
    }

    public static String getBlockName(World w, BlockPos pos) {
        return w == null ? "" : w.func_180495_p(pos).func_177230_c().func_149739_a();
    }

    public static class BreakResult {
        static final BreakResult NOT_BROKEN = new BreakResult(false, Collections.emptyMap());
        private final boolean blockBroken;
        private final Map<Boolean, List<ItemStack>> drops;

        BreakResult(boolean blockBroken, Map<Boolean, List<ItemStack>> drops) {
            this.blockBroken = blockBroken;
            this.drops = drops;
        }

        public boolean isBlockBroken() {
            return this.blockBroken;
        }

        List<ItemStack> getFilteredDrops(boolean passed) {
            return this.drops.getOrDefault(passed, Collections.emptyList());
        }

        public void processDrops(World world, BlockPos pos, IItemHandler handler) {
            for (ItemStack drop : this.getFilteredDrops(true)) {
                ItemStack excess = handler.insertItem(0, drop, false);
                if (excess.func_190926_b()) continue;
                InventoryUtils.dropItems(world, pos, excess);
            }
            for (ItemStack drop : this.getFilteredDrops(false)) {
                InventoryUtils.dropItems(world, pos, drop);
            }
        }
    }
}

