/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.tile;

import com.buuz135.portality.gui.TileAssetProvider;
import com.buuz135.portality.proxy.CommonProxy;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.GeneratorTile;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;

public class LowEfficiencyGeneratorTile
extends GeneratorTile<LowEfficiencyGeneratorTile> {
    @Save
    private SidedInventoryComponent<LowEfficiencyGeneratorTile> fuel = (SidedInventoryComponent)new SidedInventoryComponent("fuel", 46, 22, 1, 0).setColor(DyeColor.ORANGE).setColorGuiEnabled(false).setInputFilter((itemStack, integer) -> FurnaceTileEntity.func_213991_b((ItemStack)itemStack)).setComponentHarness((IComponentHarness)this);

    public LowEfficiencyGeneratorTile() {
        super((BasicTileBlock)CommonProxy.BLOCK_GENERATOR);
        this.addInventory((InventoryComponent)this.fuel);
    }

    public ActionResultType onActivated(PlayerEntity playerIn, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) != ActionResultType.SUCCESS) {
            this.openGui(playerIn);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public IAssetProvider getAssetProvider() {
        return TileAssetProvider.PROVIDER;
    }

    @Nonnull
    public LowEfficiencyGeneratorTile getSelf() {
        return this;
    }

    public int consumeFuel() {
        int time = FurnaceTileEntity.func_214001_f().getOrDefault(this.fuel.getStackInSlot(0).func_77973_b(), 100);
        this.fuel.getStackInSlot(0).func_190918_g(1);
        return time;
    }

    public boolean canStart() {
        return !this.fuel.getStackInSlot(0).func_190926_b() && FurnaceTileEntity.func_214001_f().get(this.fuel.getStackInSlot(0).func_77973_b()) != null;
    }

    public int getEnergyProducedEveryTick() {
        return 40;
    }

    public ProgressBarComponent<LowEfficiencyGeneratorTile> getProgressBar() {
        return new ProgressBarComponent(30, 20, 0, 100).setComponentHarness((IComponentHarness)this).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.CYAN);
    }

    public int getEnergyCapacity() {
        return 100000;
    }

    public int getExtractingEnergy() {
        return 100000;
    }
}

