/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.tools.extra.fluid;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class FluidUtils {
    public static FluidStack read(CompoundNBT tag) {
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)tag);
        return stack == null ? FluidStack.EMPTY : stack;
    }

    public static CompoundNBT write(FluidStack fluid, CompoundNBT tag) {
        return fluid == null || fluid.getFluid() == null ? tag : fluid.writeToNBT(tag);
    }

    public static int getLuminosity(FluidStack stack, double density) {
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return 0;
        }
        int light = fluid.getAttributes().getLuminosity(stack);
        if (fluid.getAttributes().isGaseous()) {
            light = (int)((double)light * density);
        }
        return light;
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void color(int color) {
        RenderSystem.color4f((float)FluidUtils.getRed(color), (float)FluidUtils.getGreen(color), (float)FluidUtils.getBlue(color), (float)FluidUtils.getAlpha(color));
    }

    public static void color(@Nonnull FluidStack fluid) {
        if (!fluid.isEmpty()) {
            FluidUtils.color(fluid.getFluid().getAttributes().getColor(fluid));
        }
    }

    @Nullable
    public static TextureAtlasSprite getFluidTexture(FluidStack stack) {
        FluidAttributes fa = stack.getFluid().getAttributes();
        ResourceLocation still = fa.getStillTexture(stack);
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(still);
    }
}

