/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.tools.extra.fluid;

import edivad.dimstorage.tools.extra.fluid.FluidUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ExtendedFluidTank
implements IFluidTank {
    private FluidStack fluid;
    private boolean changeType;
    private int capacity;

    public ExtendedFluidTank(FluidStack type, int capacity) {
        if (type == null) {
            type = FluidStack.EMPTY;
            this.changeType = true;
        }
        this.fluid = new FluidStack(type, 0);
        this.capacity = capacity;
    }

    public ExtendedFluidTank(int capacity) {
        this(null, capacity);
    }

    public FluidStack getFluid() {
        return this.fluid.copy();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isFluidValid(FluidStack stack) {
        return stack == null || this.fluid.getAmount() == 0 && this.changeType || this.fluid.isFluidEqual(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || !this.isFluidValid(resource)) {
            return 0;
        }
        int toFill = Math.min(this.getCapacity() - this.fluid.getAmount(), resource.getAmount());
        if (action == IFluidHandler.FluidAction.EXECUTE && toFill > 0) {
            if (!this.fluid.isFluidEqual(resource)) {
                this.fluid = new FluidStack(resource, this.fluid.getAmount() + toFill);
            } else {
                this.fluid.grow(toFill);
            }
            this.onLiquidChanged();
        }
        return toFill;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.fluid.getAmount() == 0 || maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        int toDrain = Math.min(maxDrain, this.fluid.getAmount());
        if (action == IFluidHandler.FluidAction.EXECUTE && toDrain > 0) {
            this.fluid.shrink(toDrain);
            this.onLiquidChanged();
        }
        return new FluidStack(this.fluid, toDrain);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    public void onLiquidChanged() {
    }

    public void fromTag(CompoundNBT tag) {
        this.fluid = FluidUtils.read(tag);
    }

    public CompoundNBT toTag() {
        return FluidUtils.write(this.fluid, new CompoundNBT());
    }

    public int getFluidAmount() {
        return this.fluid.getAmount();
    }
}

