/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.tools.extra;

import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraftforge.items.wrapper.InvWrapper;

public class InventoryUtils {
    public static void readItemStacksFromTag(ItemStack[] items, ListNBT tagList) {
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tag = tagList.func_150305_b(i);
            short b = tag.func_74765_d("Slot");
            items[b] = ItemStack.func_199557_a((CompoundNBT)tag);
            INBT quant = tag.func_74781_a("Quantity");
            if (!(quant instanceof NumberNBT)) continue;
            items[b].func_190920_e(((NumberNBT)quant).func_150287_d());
        }
    }

    public static ListNBT writeItemStacksToTag(ItemStack[] items) {
        return InventoryUtils.writeItemStacksToTag(items, 64);
    }

    public static ListNBT writeItemStacksToTag(ItemStack[] items, int maxQuantity) {
        ListNBT tagList = new ListNBT();
        for (int i = 0; i < items.length; ++i) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74777_a("Slot", (short)i);
            items[i].func_77955_b(tag);
            if (maxQuantity > Short.MAX_VALUE) {
                tag.func_74768_a("Quantity", items[i].func_190916_E());
            } else if (maxQuantity > 127) {
                tag.func_74777_a("Quantity", (short)items[i].func_190916_E());
            }
            tagList.add((Object)tag);
        }
        return tagList;
    }

    public static ItemStack removeStackFromSlot(IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        inv.func_70299_a(slot, ItemStack.field_190927_a);
        return stack;
    }

    @Nonnull
    public static ItemStack decrStackSize(IInventory inv, int slot, int size) {
        ItemStack item = inv.func_70301_a(slot);
        if (!item.func_190926_b()) {
            if (item.func_190916_E() <= size) {
                inv.func_70299_a(slot, ItemStack.field_190927_a);
                inv.func_70296_d();
                return item;
            }
            ItemStack itemstack1 = item.func_77979_a(size);
            if (item.func_190916_E() == 0) {
                inv.func_70299_a(slot, ItemStack.field_190927_a);
            } else {
                inv.func_70299_a(slot, item);
            }
            inv.func_70296_d();
            return itemstack1;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean mergeItemStack(ItemStack stack, int startIndex, int endIndex, InvWrapper wrapper) {
        int i;
        boolean flag = false;
        if (stack.func_77985_e()) {
            for (i = startIndex; !stack.func_190926_b() && i < endIndex; ++i) {
                int maxSize;
                ItemStack itemstack = wrapper.getStackInSlot(i);
                if (itemstack.func_190926_b() || !Container.func_195929_a((ItemStack)stack, (ItemStack)itemstack)) continue;
                int j = itemstack.func_190916_E() + stack.func_190916_E();
                if (j <= (maxSize = stack.func_77976_d())) {
                    stack.func_190920_e(0);
                    itemstack.func_190920_e(j);
                    flag = true;
                    continue;
                }
                if (itemstack.func_190916_E() >= maxSize) continue;
                stack.func_190918_g(maxSize - itemstack.func_190916_E());
                itemstack.func_190920_e(maxSize);
                flag = true;
            }
        }
        if (!stack.func_190926_b()) {
            for (i = startIndex; i < endIndex && !flag; ++i) {
                ItemStack itemstack1 = wrapper.getStackInSlot(i).getStack();
                if (!itemstack1.func_190926_b() || !wrapper.isItemValid(i, stack)) continue;
                if (stack.func_190916_E() > 64) {
                    wrapper.setStackInSlot(i, stack.func_77979_a(64));
                } else {
                    wrapper.setStackInSlot(i, stack.func_77979_a(stack.func_190916_E()));
                }
                flag = true;
            }
        }
        return flag;
    }
}

