/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.tile;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.container.ContainerDimTank;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.network.PacketHandler;
import edivad.dimstorage.network.TankState;
import edivad.dimstorage.network.packet.SyncLiquidTank;
import edivad.dimstorage.setup.Registration;
import edivad.dimstorage.storage.DimTankStorage;
import edivad.dimstorage.tile.TileFrequencyOwner;
import edivad.dimstorage.tools.extra.fluid.FluidUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class TileEntityDimTank
extends TileFrequencyOwner {
    public DimTankState liquidState = new DimTankState();
    public boolean autoEject = false;

    public TileEntityDimTank() {
        super((TileEntityType)Registration.DIMTANK_TILE.get());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.autoEject) {
            this.ejectLiquid();
        }
        this.liquidState.update(this.field_145850_b.field_72995_K);
    }

    private void ejectLiquid() {
        for (Direction side : Direction.values()) {
            int qty;
            FluidStack liquid;
            IFluidHandler handler;
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (tile == null || !this.checkSameFrequency(tile) || (handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d()).orElse(null)) == null || (liquid = this.getStorage().drain(100, IFluidHandler.FluidAction.SIMULATE)).getAmount() <= 0 || (qty = handler.fill(liquid, IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
            this.getStorage().drain(qty, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private boolean checkSameFrequency(TileEntity tile) {
        if (tile instanceof TileEntityDimTank) {
            TileEntityDimTank otherTank = (TileEntityDimTank)tile;
            return !this.frequency.equals(otherTank.frequency);
        }
        return true;
    }

    @Override
    public void setFreq(Frequency frequency) {
        super.setFreq(frequency);
        if (!this.field_145850_b.field_72995_K) {
            this.liquidState.setFrequency(frequency);
        }
    }

    @Override
    public DimTankStorage getStorage() {
        return (DimTankStorage)DimStorageManager.instance(this.field_145850_b.field_72995_K).getStorage(this.frequency, "fluid");
    }

    public int getComparatorInput() {
        int amount = this.getStorage().getFluidInTank(0).getAmount();
        return amount / 1000;
    }

    public void swapAutoEject() {
        this.autoEject = !this.autoEject;
        this.func_70296_d();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("autoEject", this.autoEject);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.liquidState.setFrequency(this.frequency);
        this.autoEject = tag.func_74767_n("autoEject");
    }

    public int getLightValue() {
        if (this.liquidState.serverLiquid.getAmount() > 0) {
            return FluidUtils.getLuminosity(this.liquidState.clientLiquid, (double)this.liquidState.serverLiquid.getAmount() / 16.0);
        }
        return 0;
    }

    @Override
    public ActionResultType activate(PlayerEntity player, World worldIn, BlockPos pos, Hand hand) {
        boolean result = FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)this.getStorage());
        if (!result) {
            if (this.canAccess(player)) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> buf.func_179255_a(this.func_174877_v()).writeBoolean(false));
            } else {
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Access Denied!"));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.locked && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.getStorage()).cast();
        }
        return super.getCapability(cap, side);
    }

    public final SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT root = new CompoundNBT();
        root.func_218657_a("Frequency", (INBT)this.frequency.writeToNBT(new CompoundNBT()));
        root.func_74757_a("locked", this.locked);
        root.func_74757_a("autoEject", this.autoEject);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, root);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        this.setFreq(new Frequency(tag.func_74775_l("Frequency")));
        this.locked = tag.func_74767_n("locked");
        this.autoEject = tag.func_74767_n("autoEject");
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_74757_a("autoEject", this.autoEject);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundNBT tag) {
        this.setFreq(new Frequency(tag.func_74775_l("Frequency")));
        this.locked = tag.func_74767_n("locked");
        this.autoEject = tag.func_74767_n("autoEject");
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerDimTank(id, playerInventory, this, false);
    }

    public class DimTankState
    extends TankState {
        @Override
        public void sendSyncPacket() {
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncLiquidTank(TileEntityDimTank.this.func_174877_v(), this.serverLiquid));
        }

        @Override
        public void onLiquidChanged() {
            TileEntityDimTank.this.field_145850_b.func_184138_a(TileEntityDimTank.this.func_174877_v(), TileEntityDimTank.this.func_195044_w(), TileEntityDimTank.this.func_195044_w(), 3);
        }
    }
}

