/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.storage;

import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.tools.extra.fluid.ExtendedFluidTank;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DimTankStorage
extends AbstractDimStorage
implements IFluidHandler {
    public static final int CAPACITY = 16000;
    private Tank tank = new Tank(16000);

    public DimTankStorage(DimStorageManager manager, Frequency freq) {
        super(manager, freq);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tank.getFluid();
    }

    public int getTankCapacity(int tank) {
        return 16000;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.tank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.tank.drain(maxDrain, action);
    }

    @Override
    public void clearStorage() {
        this.tank = new Tank(16000);
        this.setDirty();
    }

    @Override
    public String type() {
        return "fluid";
    }

    @Override
    public CompoundNBT saveToTag() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("tank", (INBT)this.tank.toTag());
        return compound;
    }

    @Override
    public void loadFromTag(CompoundNBT tag) {
        this.tank.fromTag(tag.func_74775_l("tank"));
    }

    private class Tank
    extends ExtendedFluidTank {
        public Tank(int capacity) {
            super(capacity);
        }

        @Override
        public void onLiquidChanged() {
            DimTankStorage.this.setDirty();
        }
    }
}

