/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.storage;

import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.network.PacketHandler;
import edivad.dimstorage.network.packet.OpenChest;
import edivad.dimstorage.tools.extra.ArrayUtils;
import edivad.dimstorage.tools.extra.InventoryUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fml.network.PacketDistributor;

public class DimChestStorage
extends AbstractDimStorage
implements IInventory {
    private ItemStack[] items;
    private int open;

    public DimChestStorage(DimStorageManager manager, Frequency freq) {
        super(manager, freq);
        this.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStorage() {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            this.empty();
            this.setDirty();
        }
    }

    @Override
    public void loadFromTag(CompoundNBT tag) {
        this.empty();
        InventoryUtils.readItemStacksFromTag(this.items, tag.func_150295_c("Items", 10));
    }

    @Override
    public String type() {
        return "item";
    }

    @Override
    public CompoundNBT saveToTag() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("Items", (INBT)InventoryUtils.writeItemStacksToTag(this.items));
        return compound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70301_a(int slot) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            return this.items[slot];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70304_b(int index) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            return InventoryUtils.removeStackFromSlot(this, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70299_a(int slot, ItemStack stack) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            this.items[slot] = stack;
            this.func_70296_d();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openInventory() {
        if (this.manager.client) {
            return;
        }
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            ++this.open;
            if (this.open >= 1) {
                PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new OpenChest(this.freq, true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInventory() {
        if (this.manager.client) {
            return;
        }
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            --this.open;
            if (this.open <= 0) {
                PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new OpenChest(this.freq, false));
            }
        }
    }

    public int getNumOpen() {
        return this.open;
    }

    public int func_70302_i_() {
        return 54;
    }

    public boolean func_191420_l() {
        return ArrayUtils.count(this.items, stack -> !stack.func_190926_b()) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70298_a(int slot, int size) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            return InventoryUtils.decrStackSize(this, slot, size);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.setDirty();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void empty() {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            this.items = new ItemStack[this.func_70302_i_()];
            ArrayUtils.fill(this.items, ItemStack.field_190927_a);
        }
    }

    public void setClientOpen(int i) {
        if (this.manager.client) {
            this.open = i;
        }
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void func_174888_l() {
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }
}

