/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network.packet;

import edivad.dimstorage.Main;
import edivad.dimstorage.tile.TileEntityDimTank;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncLiquidTank {
    private BlockPos pos;
    private FluidStack fluidStack;

    public SyncLiquidTank(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.fluidStack = buf.readFluidStack();
    }

    public SyncLiquidTank(BlockPos pos, FluidStack fluidStack) {
        this.pos = pos;
        this.fluidStack = fluidStack;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeFluidStack(this.fluidStack);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te;
            World world = Main.proxy.getClientWorld();
            if (world.func_195588_v(this.pos) && (te = world.func_175625_s(this.pos)) instanceof TileEntityDimTank) {
                TileEntityDimTank tank = (TileEntityDimTank)te;
                tank.liquidState.sync(this.fluidStack);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

