/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.compat.top;

import edivad.dimstorage.blocks.DimChest;
import edivad.dimstorage.blocks.DimTank;
import edivad.dimstorage.compat.top.FluidElement;
import edivad.dimstorage.tile.TileEntityDimChest;
import edivad.dimstorage.tile.TileEntityDimTank;
import java.util.function.Function;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class TOPProvider
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider((IProbeInfoProvider)this);
        FluidElement.ID = probe.registerElementFactory(FluidElement::new);
        return null;
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TileEntity te;
        if (blockState.func_177230_c() instanceof DimChest) {
            TileEntity te2 = world.func_175625_s(data.getPos());
            if (te2 instanceof TileEntityDimChest) {
                TileEntityDimChest tile = (TileEntityDimChest)te2;
                if (tile.frequency.hasOwner()) {
                    if (tile.canAccess(player)) {
                        probeInfo.horizontal().text(TextFormatting.GREEN + "Owner: " + tile.frequency.getOwner());
                    } else {
                        probeInfo.horizontal().text(TextFormatting.RED + "Owner: " + tile.frequency.getOwner());
                    }
                }
                probeInfo.horizontal().text("Frequency: " + tile.frequency.getChannel());
                if (tile.locked) {
                    probeInfo.horizontal().text("Locked: Yes");
                }
                probeInfo.horizontal().text("Collecting: " + (tile.collect ? "Yes" : "No"));
            }
        } else if (blockState.func_177230_c() instanceof DimTank && (te = world.func_175625_s(data.getPos())) instanceof TileEntityDimTank) {
            TileEntityDimTank tank = (TileEntityDimTank)te;
            if (tank.frequency.hasOwner()) {
                if (tank.canAccess(player)) {
                    probeInfo.horizontal().text(TextFormatting.GREEN + "Owner: " + tank.frequency.getOwner());
                } else {
                    probeInfo.horizontal().text(TextFormatting.RED + "Owner: " + tank.frequency.getOwner());
                }
            }
            probeInfo.horizontal().text("Frequency: " + tank.frequency.getChannel());
            if (tank.locked) {
                probeInfo.horizontal().text("Locked: Yes");
            }
            if (tank.autoEject) {
                probeInfo.horizontal().text("Auto-eject: Yes");
            }
            if (!tank.liquidState.serverLiquid.isEmpty()) {
                probeInfo.element((IElement)new FluidElement(tank.liquidState.serverLiquid, 16000));
            }
        }
    }

    public String getID() {
        return "dimstorage:default";
    }
}

