/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.compat.top;

import edivad.dimstorage.compat.top.TOPElement;
import edivad.dimstorage.tools.extra.fluid.FluidUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class FluidElement
extends TOPElement {
    public static int ID;
    @Nonnull
    protected final FluidStack fluid;
    protected final int capacity;

    public FluidElement(@Nonnull FluidStack fluid, int capacity) {
        super(-16777216, 0xFFFFFF);
        this.fluid = fluid;
        this.capacity = capacity;
    }

    public FluidElement(PacketBuffer buf) {
        this(buf.readFluidStack(), buf.readInt());
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeFluidStack(this.fluid);
        buf.writeInt(this.capacity);
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.capacity == 0 || this.fluid.getAmount() == Integer.MAX_VALUE) {
            return level;
        }
        return this.fluid.getAmount() * level / this.capacity;
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return this.fluid.isEmpty() ? null : FluidUtils.getFluidTexture(this.fluid);
    }

    @Override
    public ITextComponent getText() {
        String liquidText = this.fluid.getDisplayName().func_150254_d();
        int amount = this.fluid.getAmount();
        return new StringTextComponent(String.format("%s: %dmB", liquidText, amount));
    }

    @Override
    protected boolean applyRenderColor() {
        FluidUtils.color(this.fluid);
        return true;
    }

    public int getID() {
        return ID;
    }
}

