/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen.pattern;

import edivad.dimstorage.client.screen.element.button.ChangeButton;
import edivad.dimstorage.client.screen.element.button.LockButton;
import edivad.dimstorage.client.screen.element.button.OwnerButton;
import edivad.dimstorage.client.screen.element.textfield.FrequencyText;
import edivad.dimstorage.client.screen.pattern.PanelScreen;
import edivad.dimstorage.network.PacketHandler;
import edivad.dimstorage.network.packet.UpdateDimChest;
import edivad.dimstorage.network.packet.UpdateDimTank;
import edivad.dimstorage.tile.TileEntityDimChest;
import edivad.dimstorage.tile.TileEntityDimTank;
import edivad.dimstorage.tile.TileFrequencyOwner;
import edivad.dimstorage.tools.Translate;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class FrequencyScreen<T extends Container>
extends PanelScreen<T> {
    private TileFrequencyOwner tileOwner;
    private String owner;
    private String freq;
    private String locked;
    private FrequencyText freqTextField;

    public FrequencyScreen(T container, TileFrequencyOwner tileOwner, PlayerInventory invPlayer, ITextComponent text, ResourceLocation background, boolean drawSettings) {
        super(container, invPlayer, text, background, drawSettings);
        this.tileOwner = tileOwner;
    }

    protected void init() {
        super.init();
        this.owner = Translate.translateToLocal("gui.dimstorage.owner");
        this.freq = Translate.translateToLocal("gui.dimstorage.frequency");
        this.locked = Translate.translateToLocal("gui.dimstorage.locked");
        this.clearComponent();
        this.addComponent((Widget)new OwnerButton(this.width / 2 + 95, this.height / 2 - 53, this.tileOwner));
        this.addComponent((Widget)new ChangeButton(this.width / 2 + 95, this.height / 2 + 7, b -> this.changeFrequency()));
        this.addComponent((Widget)new LockButton(this.width / 2 + 95, this.height / 2 + 46, this.tileOwner));
        this.freqTextField = new FrequencyText(this.width / 2 + 95, this.height / 2 - 12, this.tileOwner.frequency);
        this.addComponent((Widget)this.freqTextField);
        this.drawSettings(this.drawSettings);
    }

    private void changeFrequency() {
        int prevChannel = this.tileOwner.frequency.getChannel();
        try {
            int newFreq = Math.abs(Integer.parseInt(this.freqTextField.func_146179_b()));
            this.tileOwner.setFreq(this.tileOwner.frequency.copy().setChannel(newFreq));
            if (this.tileOwner instanceof TileEntityDimChest) {
                PacketHandler.INSTANCE.sendToServer((Object)new UpdateDimChest((TileEntityDimChest)this.tileOwner));
            } else if (this.tileOwner instanceof TileEntityDimTank) {
                PacketHandler.INSTANCE.sendToServer((Object)new UpdateDimTank((TileEntityDimTank)this.tileOwner));
            }
        }
        catch (Exception e) {
            this.freqTextField.func_146180_a(String.valueOf(prevChannel));
        }
    }

    public void tick() {
        super.tick();
        this.freqTextField.func_146178_a();
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.freqTextField.render(mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        this.freqTextField.mouseClicked(mouseX, mouseY, clickedButton);
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.drawSettings) {
            int posY = 45;
            this.font.func_211126_b(this.owner, 185.0f, (float)posY, 0x404040);
            this.hLine(185, 185 + this.font.func_78256_a(this.owner), posY += 9, -13421773);
            this.font.func_211126_b(this.freq, 185.0f, (float)(posY += 31), 0x404040);
            this.hLine(185, 185 + this.font.func_78256_a(this.freq), posY += 9, -13421773);
            this.font.func_211126_b(this.locked, 185.0f, (float)(posY += 50), 0x404040);
            this.hLine(185, 185 + this.font.func_78256_a(this.locked), posY += 9, -13421773);
        }
    }
}

