/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen;

import edivad.dimstorage.client.screen.element.button.AutoEjectButton;
import edivad.dimstorage.client.screen.pattern.FrequencyScreen;
import edivad.dimstorage.container.ContainerDimTank;
import edivad.dimstorage.tile.TileEntityDimTank;
import edivad.dimstorage.tools.Translate;
import edivad.dimstorage.tools.extra.fluid.FluidUtils;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class ScreenDimTank
extends FrequencyScreen<ContainerDimTank> {
    private TileEntityDimTank ownerTile;
    private String liquid;
    private String amount;
    private String temperature;
    private String luminosity;
    private String gaseous;
    private String empty;
    private String yes;
    private String no;

    public ScreenDimTank(ContainerDimTank container, PlayerInventory invPlayer, ITextComponent text) {
        super(container, container.owner, invPlayer, text, new ResourceLocation("dimstorage", "textures/gui/dimtank.png"), container.isOpen);
        this.ownerTile = container.owner;
    }

    @Override
    protected void init() {
        super.init();
        this.addComponent((Widget)new AutoEjectButton(this.width / 2 + 95, this.height / 2 + 75, this.ownerTile));
        this.drawSettings(this.drawSettings);
        this.liquid = Translate.translateToLocal("gui.dimstorage.liquid");
        this.amount = Translate.translateToLocal("gui.dimstorage.amount");
        this.temperature = Translate.translateToLocal("gui.dimstorage.temperature");
        this.luminosity = Translate.translateToLocal("gui.dimstorage.luminosity");
        this.gaseous = Translate.translateToLocal("gui.dimstorage.gas");
        this.empty = Translate.translateToLocal("gui.dimstorage.empty");
        this.yes = Translate.translateToLocal("gui.dimstorage.yes");
        this.no = Translate.translateToLocal("gui.dimstorage.no");
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        FluidStack liquidStack = this.ownerTile.liquidState.clientLiquid;
        FluidAttributes liquidAttributes = liquidStack.getFluid().getAttributes();
        if (!liquidStack.getFluid().func_207187_a(Fluids.field_204541_a)) {
            this.font.func_211126_b(this.liquid + " " + liquidStack.getDisplayName().func_150254_d(), 50.0f, 25.0f, 0x404040);
            this.font.func_211126_b(this.amount + " " + liquidStack.getAmount() + " mB", 50.0f, 35.0f, 0x404040);
            this.font.func_211126_b(this.temperature + " " + (liquidAttributes.getTemperature() - 273) + "\u00b0C", 50.0f, 45.0f, 0x404040);
            this.font.func_211126_b(this.luminosity + " " + liquidAttributes.getLuminosity(), 50.0f, 55.0f, 0x404040);
            this.font.func_211126_b(this.gaseous + " " + (liquidAttributes.isGaseous() ? this.yes : this.no), 50.0f, 65.0f, 0x404040);
        } else {
            this.font.func_211126_b(this.liquid + " " + this.empty, 50.0f, 25.0f, 0x404040);
        }
    }

    @Override
    protected void func_146976_a(float f, int i, int j) {
        super.func_146976_a(f, i, j);
        FluidStack fluid = this.ownerTile.liquidState.clientLiquid;
        int z = ScreenDimTank.getFluidScaled(60, fluid.getAmount());
        TextureAtlasSprite fluidTexture = FluidUtils.getFluidTexture(fluid);
        this.minecraft.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        FluidUtils.color(fluid);
        ScreenDimTank.blit((int)(this.field_147003_i + 11), (int)(this.field_147009_r + 21 + z), (int)176, (int)16, (int)(60 - z), (TextureAtlasSprite)fluidTexture);
    }

    private static int getFluidScaled(int pixels, int currentLiquidAmount) {
        int maxLiquidAmount = 16000;
        int x = currentLiquidAmount * pixels / maxLiquidAmount;
        return pixels - x;
    }
}

