/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public final class RenderUtils {
    private RenderUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static void renderGuiTank(IFluidHandler fluidHandler, int tank, double x, double y, double zLevel, double width, double height) {
        FluidStack stack = fluidHandler.getFluidInTank(tank);
        int tankCapacity = fluidHandler.getTankCapacity(tank);
        RenderUtils.renderGuiTank(stack, tankCapacity, x, y, zLevel, width, height);
    }

    public static void renderGuiTank(FluidStack stack, int tankCapacity, double x, double y, double zLevel, double width, double height) {
        int amount = stack.getAmount();
        if (stack.getFluid() == null || amount <= 0) {
            return;
        }
        TextureAtlasSprite icon = RenderUtils.getFluidTexture(stack);
        if (icon == null) {
            return;
        }
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)tankCapacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        int color = stack.getFluid().getAttributes().getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color3f((float)r, (float)g, (float)b);
        RenderSystem.enableBlend();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                float minU = icon.func_94209_e();
                float maxU = icon.func_94212_f();
                float minV = icon.func_94206_g();
                float maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder tes = tessellator.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                tes.func_225582_a_((double)drawX, (double)(drawY + drawHeight), 0.0).func_225583_a_(minU, minV + (maxV - minV) * (float)drawHeight / 16.0f).func_181675_d();
                tes.func_225582_a_((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_225583_a_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV + (maxV - minV) * (float)drawHeight / 16.0f).func_181675_d();
                tes.func_225582_a_((double)(drawX + drawWidth), (double)drawY, 0.0).func_225583_a_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV).func_181675_d();
                tes.func_225582_a_((double)drawX, (double)drawY, 0.0).func_225583_a_(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        RenderSystem.disableBlend();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Nullable
    public static TextureAtlasSprite getFluidTexture(FluidStack stack) {
        TextureAtlasSprite[] sprites = ForgeHooksClient.getFluidSprites((ILightReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)BlockPos.field_177992_a, (IFluidState)stack.getFluid().func_207188_f());
        return sprites.length > 0 ? sprites[0] : null;
    }
}

