/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.fluid.block;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class MagmaFluidBlock
extends FlowingFluidBlock {
    VoxelShape[] shapes = new VoxelShape[16];

    public MagmaFluidBlock(Supplier<? extends FlowingFluid> supplier, Block.Properties props) {
        super(supplier, props);
        int max = 15;
        float offset = 0.875f;
        for (int i = 0; i <= max; ++i) {
            this.shapes[i] = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)(offset - (float)i / 8.0f), 1.0));
        }
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[(Integer)state.func_177229_b((IProperty)field_176367_b)];
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.shapes[(Integer)state.func_177229_b((IProperty)field_176367_b)];
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IParticleData getDripParticleData() {
        return ParticleTypes.field_197617_j;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        int level;
        LivingEntity ent;
        if (entityIn instanceof LivingEntity && !(ent = (LivingEntity)entityIn).func_70027_ad() && !ent.func_70045_F() && (level = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_77329_d, (LivingEntity)ent)) < 4) {
            ent.func_70015_d(MathHelper.func_76128_c((double)(worldIn.field_73012_v.nextDouble() * 10.0)));
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    public int func_149738_a(IWorldReader worldIn) {
        return super.func_149738_a(worldIn) * 8;
    }

    public static class Source
    extends ForgeFlowingFluid.Source {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int func_185698_b(IWorldReader worldIn) {
            return 2;
        }

        public int func_204528_b(IWorldReader worldIn) {
            return 1;
        }
    }

    public static class Flowing
    extends ForgeFlowingFluid.Flowing {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int func_185698_b(IWorldReader worldIn) {
            return 2;
        }

        public int func_204528_b(IWorldReader worldIn) {
            return 7;
        }
    }
}

