/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.constructor.base;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.core.util.math.BlockOffset;
import com.valkyrieofnight.vlib.multiblock.Structure;
import com.valkyrieofnight.vlib.multiblock.component.Component;
import java.util.Map;
import java.util.Queue;
import net.minecraft.nbt.CompoundNBT;

public class Formation
implements INBTSerializer {
    protected Map<BlockOffset, Boolean> claimed = Maps.newHashMap();

    public boolean isFormed() {
        return !this.claimed.containsValue(false) && !this.claimed.isEmpty();
    }

    public boolean isPartiallyFormed() {
        return this.claimed.containsValue(true) && this.claimed.containsKey(false);
    }

    public boolean isPartiallyUnformed() {
        return this.claimed.containsValue(false);
    }

    public boolean isUnformed() {
        return !this.claimed.containsValue(true);
    }

    public void setup(Structure structure) {
        this.claimed = structure.getBlankClaimedStateMap();
    }

    public void setClaimed(BlockOffset offset, boolean opt) {
        if (this.claimed.containsKey(offset)) {
            this.claimed.put(offset, opt);
        }
    }

    public boolean check(BlockOffset offset) {
        if (!this.claimed.containsKey(offset)) {
            return false;
        }
        return this.claimed.get(offset);
    }

    public void populateQueueWithAll(Structure structure, Queue<Map.Entry<BlockOffset, Component>> q) {
        for (BlockOffset bo : this.claimed.keySet()) {
            Component comp = structure.getComponent(bo);
            q.add(Maps.immutableEntry((Object)bo, (Object)comp));
        }
    }

    public void populateQueueWithClaimed(Structure structure, Queue<Map.Entry<BlockOffset, Component>> q) {
        for (BlockOffset bo : this.claimed.keySet()) {
            if (!this.claimed.get(bo).booleanValue()) continue;
            q.add(Maps.immutableEntry((Object)bo, (Object)structure.getComponent(bo)));
        }
    }

    public void populateQueueWithUnClaimed(Structure structure, Queue<Map.Entry<BlockOffset, Component>> q) {
        for (BlockOffset bo : this.claimed.keySet()) {
            if (this.claimed.get(bo).booleanValue()) continue;
            q.add(Maps.immutableEntry((Object)bo, (Object)structure.getComponent(bo)));
        }
    }

    public void setFormed(boolean opt) {
        for (BlockOffset o : this.claimed.keySet()) {
            this.claimed.put(o, opt);
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.isFormed()) {
            nbt.func_74757_a("formed", true);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("formed")) {
            this.setFormed(true);
        }
    }
}

