/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.RatsMod;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageAutoCurdlerFluid {
    public long blockPos;
    public FluidStack fluid;

    public MessageAutoCurdlerFluid(long blockPos, FluidStack fluid) {
        this.blockPos = blockPos;
        this.fluid = fluid;
    }

    public static MessageAutoCurdlerFluid read(PacketBuffer packetBuffer) {
        return new MessageAutoCurdlerFluid(packetBuffer.readLong(), FluidStack.readFromPacket((PacketBuffer)packetBuffer));
    }

    public static void write(MessageAutoCurdlerFluid message, PacketBuffer packetBuffer) {
        packetBuffer.writeLong(message.blockPos);
        message.fluid.writeToPacket(packetBuffer);
    }

    public static class Handler {
        public static void handle(MessageAutoCurdlerFluid message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            RatsMod.PROXY.handlePacketAutoCurdlerFluid(message.blockPos, message.fluid);
        }
    }
}

