/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.IPirat;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityDutchratSword
extends Entity {
    @Nullable
    private LivingEntity creator;
    @Nullable
    private Entity target;
    private UUID ownerUniqueId;

    public EntityDutchratSword(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public EntityDutchratSword(FMLPlayMessages.SpawnEntity spawnEntity, World worldIn) {
        this(RatsEntityRegistry.DUTCHRAT_SWORD, worldIn);
    }

    public EntityDutchratSword(EntityType type, World worldIn, double x, double y, double z) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
    }

    public EntityDutchratSword(EntityType type, World worldIn, double x, double y, double z, LivingEntity creator) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
        this.setCreator(creator);
    }

    public void func_70071_h_() {
        RayTraceResult raytraceresult;
        super.func_70071_h_();
        this.field_70145_X = true;
        if (this.field_70173_aa > 300) {
            // empty if block
        }
        if (this.field_70173_aa > 5 && (raytraceresult = ProjectileHelper.func_221266_a((Entity)this, (boolean)true, (this.field_70173_aa >= 25 ? 1 : 0) != 0, (Entity)this.getCreator(), (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER)) != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.onImpact(raytraceresult);
        }
        if (this.field_70170_p.field_72995_K) {
            RatsMod.PROXY.addParticle("pirat_ghost", this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() / 2.0, this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() / 2.0, 0.0, 0.0, 0.0);
        }
        if ((this.target == null || this.getCreator() != null && !this.target.func_70028_i((Entity)((MobEntity)this.getCreator()).func_70638_az())) && this.getCreator() != null && this.getCreator() instanceof MobEntity) {
            LivingEntity target = ((MobEntity)this.getCreator()).func_70638_az();
            if (target == null && this.getCreator() instanceof MonsterEntity) {
                target = this.field_70170_p.func_217362_a((Entity)this, 30.0);
            }
            this.target = target;
        }
        if (this.target != null) {
            double d0 = this.target.func_226277_ct_() - this.func_226277_ct_();
            double d1 = this.target.func_226278_cu_() - this.func_226278_cu_();
            double d2 = this.target.func_226281_cx_() - this.func_226281_cx_();
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
            double speed = 0.1;
            this.func_213317_d(this.func_213322_ci().func_72441_c(d0 / d3 * speed, d1 / d3 * speed, d2 / d3 * speed));
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            this.field_70177_z = f % 360.0f;
            this.field_70126_B = f % 360.0f;
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    private void onImpact(RayTraceResult raytraceresult) {
        DamageSource source = DamageSource.field_76376_m;
        if (this.getCreator() != null) {
            source = DamageSource.func_76358_a((LivingEntity)this.getCreator());
        }
        boolean hit = false;
        for (Entity hitMobs : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0))) {
            if (hitMobs instanceof IPirat) continue;
            hitMobs.func_70097_a(source, RatConfig.dutchratAttack);
            hit = true;
        }
        if (hit) {
            this.field_70170_p.func_217385_a((Entity)this.getCreator(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 2.0f, Explosion.Mode.NONE);
            this.func_70106_y();
        }
    }

    @Nullable
    public LivingEntity getCreator() {
        Entity entity;
        if (this.creator == null && this.ownerUniqueId != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerUniqueId)) instanceof LivingEntity) {
            this.creator = (LivingEntity)entity;
        }
        return this.creator;
    }

    public void setCreator(@Nullable LivingEntity ownerIn) {
        this.creator = ownerIn;
        this.ownerUniqueId = ownerIn == null ? null : ownerIn.func_110124_au();
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.field_70173_aa = compound.func_74762_e("Age");
        this.ownerUniqueId = compound.func_186857_a("OwnerUUID");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Age", this.field_70173_aa);
        if (this.ownerUniqueId != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUniqueId);
        }
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    protected void func_70088_a() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

