/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.type;

import com.github.alexthe666.rats.client.render.tile.RenderRatlantisPortal;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RatsRenderType
extends RenderType {
    protected static final RenderState.TexturingState RAINBOW_GLINT_TEXTURING = new RenderState.TexturingState("rainbow_glint_texturing", () -> RatsRenderType.setupRainbowRendering(0.16f), () -> {
        RenderSystem.matrixMode((int)5890);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
    });
    public static final RenderType GREEN_ENTITY_GLINT = RatsRenderType.func_228632_a_((String)"green_glint", (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("rats:textures/entity/rat/green_glint.png"), true, false)).func_228727_a_(field_228496_F_).func_228714_a_(field_228491_A_).func_228715_a_(field_228493_C_).func_228726_a_(field_228513_e_).func_228725_a_(field_228527_s_).func_228728_a_(false));
    public static final RenderType RAINBOW_GLINT = RatsRenderType.func_228632_a_((String)"rainbow_glint", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("rats:textures/entity/rat/rainbow_glint.png"), true, false)).func_228727_a_(field_228496_F_).func_228714_a_(field_228491_A_).func_228715_a_(field_228493_C_).func_228726_a_(field_228513_e_).func_228725_a_(RAINBOW_GLINT_TEXTURING).func_228716_a_(field_228532_x_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228723_a_(field_228520_l_).func_228728_a_(false));

    private static void setupRainbowRendering(float scaleIn) {
        RenderSystem.matrixMode((int)5890);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        long i = Util.func_211177_b() * 8L;
        float f = (float)(i % 110000L) / 110000.0f;
        float f1 = (float)(i % 10000L) / 10000.0f;
        RenderSystem.translatef((float)0.0f, (float)f1, (float)0.0f);
        RenderSystem.rotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.scalef((float)scaleIn, (float)scaleIn, (float)scaleIn);
        RenderSystem.matrixMode((int)5888);
    }

    public RatsRenderType(String p_i225992_1_, VertexFormat p_i225992_2_, int p_i225992_3_, int p_i225992_4_, boolean p_i225992_5_, boolean p_i225992_6_, Runnable p_i225992_7_, Runnable p_i225992_8_) {
        super(p_i225992_1_, p_i225992_2_, p_i225992_3_, p_i225992_4_, p_i225992_5_, p_i225992_6_, p_i225992_7_, p_i225992_8_);
    }

    public static RenderType getRatlantisPortal(int iterationIn) {
        RenderState.TextureState renderstate$texturestate;
        RenderState.TransparencyState renderstate$transparencystate;
        if (iterationIn <= 1) {
            renderstate$transparencystate = field_228515_g_;
            renderstate$texturestate = new RenderState.TextureState(RenderRatlantisPortal.END_SKY_TEXTURE, false, false);
        } else {
            renderstate$transparencystate = field_228511_c_;
            renderstate$texturestate = new RenderState.TextureState(RenderRatlantisPortal.END_PORTAL_TEXTURE, false, false);
        }
        return RatsRenderType.func_228633_a_((String)"ratlantis_portal", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(renderstate$transparencystate).func_228724_a_(renderstate$texturestate).func_228725_a_((RenderState.TexturingState)new RatlantisPortalTexturingState(iterationIn)).func_228728_a_(false));
    }

    public static RenderType getGlowingTranslucent(ResourceLocation locationIn) {
        RenderState.TextureState renderstate$texturestate = new RenderState.TextureState(locationIn, false, false);
        return RatsRenderType.func_228633_a_((String)"eyes", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(renderstate$texturestate).func_228726_a_(field_228515_g_).func_228727_a_(field_228495_E_).func_228713_a_(field_228517_i_).func_228722_a_(field_228530_v_).func_228717_a_(field_228503_M_).func_228728_a_(false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class RatlantisPortalTexturingState
    extends RenderState.TexturingState {
        private final int iteration;

        public RatlantisPortalTexturingState(int p_i225986_1_) {
            super("portal_texturing", () -> {
                RenderSystem.matrixMode((int)5890);
                RenderSystem.pushMatrix();
                RenderSystem.loadIdentity();
                RenderSystem.translatef((float)0.5f, (float)0.5f, (float)0.0f);
                RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
                RenderSystem.translatef((float)(17.0f / (float)p_i225986_1_), (float)((2.0f + (float)p_i225986_1_ / 0.5f) * ((float)(Util.func_211177_b() % 80000L) / 80000.0f)), (float)0.0f);
                RenderSystem.scalef((float)(4.5f - (float)p_i225986_1_ / 4.0f), (float)(4.5f - (float)p_i225986_1_ / 4.0f), (float)1.0f);
                RenderSystem.mulTextureByProjModelView();
                RenderSystem.matrixMode((int)5888);
                RenderSystem.setupEndPortalTexGen();
            }, () -> {
                RenderSystem.matrixMode((int)5890);
                RenderSystem.popMatrix();
                RenderSystem.matrixMode((int)5888);
                RenderSystem.clearTexGen();
            });
            this.iteration = p_i225986_1_;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && ((Object)((Object)this)).getClass() == p_equals_1_.getClass()) {
                RatlantisPortalTexturingState renderstate$portaltexturingstate = (RatlantisPortalTexturingState)((Object)p_equals_1_);
                return this.iteration == renderstate$portaltexturingstate.iteration;
            }
            return false;
        }

        public int hashCode() {
            return Integer.hashCode(this.iteration);
        }
    }
}

