/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.DelegatedTaskExecutor;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkTaskPriorityQueueSorter;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerWorldLightManager
extends WorldLightManager
implements AutoCloseable {
    private static final Logger field_215604_a = LogManager.getLogger();
    private final DelegatedTaskExecutor<Runnable> field_215605_b;
    private final ObjectList<Pair<Phase, Runnable>> field_215606_c = new ObjectArrayList();
    private final ChunkManager field_215607_d;
    private final ITaskExecutor<ChunkTaskPriorityQueueSorter.FunctionEntry<Runnable>> field_215608_e;
    private volatile int field_215609_f = 5;
    private final AtomicBoolean field_215610_g = new AtomicBoolean();

    public ServerWorldLightManager(IChunkLightProvider iChunkLightProvider, ChunkManager chunkManager, boolean bl, DelegatedTaskExecutor<Runnable> delegatedTaskExecutor, ITaskExecutor<ChunkTaskPriorityQueueSorter.FunctionEntry<Runnable>> iTaskExecutor) {
        super(iChunkLightProvider, true, bl);
        this.field_215607_d = chunkManager;
        this.field_215608_e = iTaskExecutor;
        this.field_215605_b = delegatedTaskExecutor;
    }

    @Override
    public void close() {
    }

    @Override
    public int func_215575_a(int n, boolean bl, boolean bl2) {
        throw Util.func_229757_c_(new UnsupportedOperationException("Ran authomatically on a different thread!"));
    }

    @Override
    public void func_215573_a(BlockPos blockPos, int n) {
        throw Util.func_229757_c_(new UnsupportedOperationException("Ran authomatically on a different thread!"));
    }

    @Override
    public void func_215568_a(BlockPos blockPos) {
        \u2603 = blockPos.func_185334_h();
        this.func_215586_a(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4, Phase.POST_UPDATE, Util.func_215075_a(() -> super.func_215568_a(\u2603), () -> "checkBlock " + \u2603));
    }

    protected void func_215581_a(ChunkPos chunkPos) {
        this.func_215600_a(chunkPos.field_77276_a, chunkPos.field_77275_b, () -> 0, Phase.PRE_UPDATE, Util.func_215075_a(() -> {
            int n;
            super.func_223115_b(chunkPos, false);
            super.func_215571_a(chunkPos, false);
            for (n = -1; n < 17; ++n) {
                super.func_215574_a(LightType.BLOCK, SectionPos.func_218156_a(chunkPos, n), null);
                super.func_215574_a(LightType.SKY, SectionPos.func_218156_a(chunkPos, n), null);
            }
            for (n = 0; n < 16; ++n) {
                super.func_215566_a(SectionPos.func_218156_a(chunkPos, n), true);
            }
        }, () -> "updateChunkStatus " + chunkPos + " " + true));
    }

    @Override
    public void func_215566_a(SectionPos sectionPos, boolean bl) {
        this.func_215600_a(sectionPos.func_218149_a(), sectionPos.func_218148_c(), () -> 0, Phase.PRE_UPDATE, Util.func_215075_a(() -> super.func_215566_a(sectionPos, bl), () -> "updateSectionStatus " + sectionPos + " " + bl));
    }

    @Override
    public void func_215571_a(ChunkPos chunkPos, boolean bl) {
        this.func_215586_a(chunkPos.field_77276_a, chunkPos.field_77275_b, Phase.PRE_UPDATE, Util.func_215075_a(() -> super.func_215571_a(chunkPos, bl), () -> "enableLight " + chunkPos + " " + bl));
    }

    @Override
    public void func_215574_a(LightType lightType, SectionPos sectionPos, @Nullable NibbleArray nibbleArray) {
        this.func_215600_a(sectionPos.func_218149_a(), sectionPos.func_218148_c(), () -> 0, Phase.PRE_UPDATE, Util.func_215075_a(() -> super.func_215574_a(lightType, sectionPos, nibbleArray), () -> "queueData " + sectionPos));
    }

    private void func_215586_a(int n, int n2, Phase phase, Runnable runnable) {
        this.func_215600_a(n, n2, this.field_215607_d.func_219191_c(ChunkPos.func_77272_a(n, n2)), phase, runnable);
    }

    private void func_215600_a(int n, int n2, IntSupplier intSupplier, Phase phase, Runnable runnable) {
        this.field_215608_e.func_212871_a_(ChunkTaskPriorityQueueSorter.func_219069_a(() -> {
            this.field_215606_c.add((Object)Pair.of((Object)((Object)phase), (Object)runnable));
            if (this.field_215606_c.size() >= this.field_215609_f) {
                this.func_215603_b();
            }
        }, ChunkPos.func_77272_a(n, n2), intSupplier));
    }

    @Override
    public void func_223115_b(ChunkPos chunkPos, boolean bl) {
        this.func_215600_a(chunkPos.field_77276_a, chunkPos.field_77275_b, () -> 0, Phase.PRE_UPDATE, Util.func_215075_a(() -> super.func_223115_b(chunkPos, bl), () -> "retainData " + chunkPos));
    }

    public CompletableFuture<IChunk> func_215593_a(IChunk iChunk, boolean bl) {
        ChunkPos chunkPos = iChunk.func_76632_l();
        iChunk.func_217305_b(false);
        this.func_215586_a(chunkPos.field_77276_a, chunkPos.field_77275_b, Phase.PRE_UPDATE, Util.func_215075_a(() -> {
            ChunkPos chunkPos2;
            ChunkSection[] chunkSectionArray = iChunk.func_76587_i();
            for (int i = 0; i < 16; ++i) {
                ChunkSection chunkSection = chunkSectionArray[i];
                if (ChunkSection.func_222628_a(chunkSection)) continue;
                super.func_215566_a(SectionPos.func_218156_a(chunkPos, i), false);
            }
            super.func_215571_a(chunkPos, true);
            if (!bl) {
                iChunk.func_217304_m().forEach(blockPos -> super.func_215573_a((BlockPos)blockPos, iChunk.func_217298_h((BlockPos)blockPos)));
            }
            this.field_215607_d.func_219209_c(chunkPos);
        }, () -> "lightChunk " + chunkPos + " " + bl));
        return CompletableFuture.supplyAsync(() -> {
            iChunk.func_217305_b(true);
            super.func_223115_b(chunkPos, false);
            return iChunk;
        }, runnable -> this.func_215586_a(chunkPos.field_77276_a, chunkPos.field_77275_b, Phase.POST_UPDATE, runnable));
    }

    public void func_215588_z_() {
        if ((!this.field_215606_c.isEmpty() || super.func_215570_a()) && this.field_215610_g.compareAndSet(false, true)) {
            this.field_215605_b.func_212871_a_(() -> {
                this.func_215603_b();
                this.field_215610_g.set(false);
            });
        }
    }

    private void func_215603_b() {
        int n;
        Pair pair;
        int n2 = Math.min(this.field_215606_c.size(), this.field_215609_f);
        ObjectListIterator \u26032 = this.field_215606_c.iterator();
        for (n = 0; \u26032.hasNext() && n < n2; ++n) {
            pair = (Pair)\u26032.next();
            if (pair.getFirst() != Phase.PRE_UPDATE) continue;
            ((Runnable)pair.getSecond()).run();
        }
        \u26032.back(n);
        super.func_215575_a(Integer.MAX_VALUE, true, true);
        for (n = 0; \u26032.hasNext() && n < n2; ++n) {
            pair = (Pair)\u26032.next();
            if (pair.getFirst() == Phase.POST_UPDATE) {
                ((Runnable)pair.getSecond()).run();
            }
            \u26032.remove();
        }
    }

    public void func_215598_a(int n) {
        this.field_215609_f = n;
    }

    static enum Phase {
        PRE_UPDATE,
        POST_UPDATE;

    }
}

