/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.ai.goal.BreakBlockGoal;
import net.minecraft.entity.ai.goal.BreakDoorGoal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ZombieEntity
extends MonsterEntity {
    protected static final IAttribute field_110186_bp = new RangedAttribute(null, "zombie.spawnReinforcements", 0.0, 0.0, 1.0).func_111117_a("Spawn Reinforcements Chance");
    private static final UUID field_110187_bq = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier field_110188_br = new AttributeModifier(field_110187_bq, "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final DataParameter<Boolean> field_184737_bv = EntityDataManager.func_187226_a(ZombieEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_184738_bw = EntityDataManager.func_187226_a(ZombieEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_204709_bA = EntityDataManager.func_187226_a(ZombieEntity.class, DataSerializers.field_187198_h);
    private static final Predicate<Difficulty> field_213699_bC = difficulty -> difficulty == Difficulty.HARD;
    private final BreakDoorGoal field_146075_bs = new BreakDoorGoal(this, field_213699_bC);
    private boolean field_146076_bu;
    private int field_204707_bD;
    private int field_204708_bE;

    public ZombieEntity(EntityType<? extends ZombieEntity> entityType, World world) {
        super((EntityType<? extends MonsterEntity>)entityType, world);
    }

    public ZombieEntity(World world) {
        this((EntityType<? extends ZombieEntity>)EntityType.field_200725_aD, world);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, new AttackTurtleEggGoal((CreatureEntity)this, 1.0, 3));
        this.field_70714_bg.func_75776_a(8, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, new LookRandomlyGoal(this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(2, new ZombieAttackGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, new MoveThroughVillageGoal(this, 1.0, true, 4, this::func_146072_bX));
        this.field_70714_bg.func_75776_a(7, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, new Class[0]).func_220794_a(ZombiePigmanEntity.class));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<AbstractVillagerEntity>((MobEntity)this, AbstractVillagerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<IronGolemEntity>((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(5, new NearestAttackableTargetGoal<TurtleEntity>(this, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.func_110140_aT().func_111150_b(field_110186_bp).func_111128_a(this.field_70146_Z.nextDouble() * (double)0.1f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(field_184737_bv, false);
        this.func_184212_Q().func_187214_a(field_184738_bw, 0);
        this.func_184212_Q().func_187214_a(field_204709_bA, false);
    }

    public boolean func_204706_dD() {
        return this.func_184212_Q().func_187225_a(field_204709_bA);
    }

    public boolean func_146072_bX() {
        return this.field_146076_bu;
    }

    public void func_146070_a(boolean bl) {
        if (this.func_204900_dz()) {
            if (this.field_146076_bu != bl) {
                this.field_146076_bu = bl;
                ((GroundPathNavigator)this.func_70661_as()).func_179688_b(bl);
                if (bl) {
                    this.field_70714_bg.func_75776_a(1, this.field_146075_bs);
                } else {
                    this.field_70714_bg.func_85156_a(this.field_146075_bs);
                }
            }
        } else if (this.field_146076_bu) {
            this.field_70714_bg.func_85156_a(this.field_146075_bs);
            this.field_146076_bu = false;
        }
    }

    protected boolean func_204900_dz() {
        return true;
    }

    @Override
    public boolean func_70631_g_() {
        return this.func_184212_Q().func_187225_a(field_184737_bv);
    }

    @Override
    protected int func_70693_a(PlayerEntity playerEntity) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(playerEntity);
    }

    public void func_82227_f(boolean bl) {
        this.func_184212_Q().func_187227_b(field_184737_bv, bl);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iAttributeInstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iAttributeInstance.func_111124_b(field_110188_br);
            if (bl) {
                iAttributeInstance.func_111121_a(field_110188_br);
            }
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_184737_bv.equals(dataParameter)) {
            this.func_213323_x_();
        }
        super.func_184206_a(dataParameter);
    }

    protected boolean func_204703_dA() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.func_204706_dD()) {
                --this.field_204708_bE;
                if (this.field_204708_bE < 0) {
                    this.func_207302_dI();
                }
            } else if (this.func_204703_dA()) {
                if (this.func_208600_a(FluidTags.field_206959_a)) {
                    ++this.field_204707_bD;
                    if (this.field_204707_bD >= 600) {
                        this.func_204704_a(300);
                    }
                } else {
                    this.field_204707_bD = -1;
                }
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void func_70636_d() {
        if (this.func_70089_S()) {
            boolean bl;
            boolean bl2 = bl = this.func_190730_o() && this.func_204609_dp();
            if (bl) {
                ItemStack itemStack = this.func_184582_a(EquipmentSlotType.HEAD);
                if (!itemStack.func_190926_b()) {
                    if (itemStack.func_77984_f()) {
                        itemStack.func_196085_b(itemStack.func_77952_i() + this.field_70146_Z.nextInt(2));
                        if (itemStack.func_77952_i() >= itemStack.func_77958_k()) {
                            this.func_213361_c(EquipmentSlotType.HEAD);
                            this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                        }
                    }
                    bl = false;
                }
                if (bl) {
                    this.func_70015_d(8);
                }
            }
        }
        super.func_70636_d();
    }

    private void func_204704_a(int n) {
        this.field_204708_bE = n;
        this.func_184212_Q().func_187227_b(field_204709_bA, true);
    }

    protected void func_207302_dI() {
        this.func_213698_b(EntityType.field_204724_o);
        this.field_70170_p.func_217378_a(null, 1040, new BlockPos(this), 0);
    }

    protected void func_213698_b(EntityType<? extends ZombieEntity> entityType) {
        if (this.field_70128_L) {
            return;
        }
        ZombieEntity zombieEntity = entityType.func_200721_a(this.field_70170_p);
        zombieEntity.func_82149_j(this);
        zombieEntity.func_98053_h(this.func_98052_bS());
        zombieEntity.func_146070_a(zombieEntity.func_204900_dz() && this.func_146072_bX());
        zombieEntity.func_207304_a(zombieEntity.field_70170_p.func_175649_E(new BlockPos(zombieEntity)).func_180170_c());
        zombieEntity.func_82227_f(this.func_70631_g_());
        zombieEntity.func_94061_f(this.func_175446_cd());
        for (EquipmentSlotType equipmentSlotType : EquipmentSlotType.values()) {
            ItemStack itemStack = this.func_184582_a(equipmentSlotType);
            if (itemStack.func_190926_b()) continue;
            zombieEntity.func_184201_a(equipmentSlotType, itemStack.func_77946_l());
            zombieEntity.func_184642_a(equipmentSlotType, this.func_205712_c(equipmentSlotType));
            itemStack.func_190920_e(0);
        }
        if (this.func_145818_k_()) {
            zombieEntity.func_200203_b(this.func_200201_e());
            zombieEntity.func_174805_g(this.func_174833_aM());
        }
        if (this.func_104002_bU()) {
            zombieEntity.func_110163_bv();
        }
        zombieEntity.func_184224_h(this.func_190530_aW());
        this.field_70170_p.func_217376_c(zombieEntity);
        this.func_70106_y();
    }

    @Override
    public boolean func_184645_a(PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        Item \u26032 = itemStack.func_77973_b();
        if (\u26032 instanceof SpawnEggItem && ((SpawnEggItem)\u26032).func_208077_a(itemStack.func_77978_p(), this.func_200600_R())) {
            if (!this.field_70170_p.field_72995_K && (\u2603 = (ZombieEntity)this.func_200600_R().func_200721_a(this.field_70170_p)) != null) {
                \u2603.func_82227_f(true);
                \u2603.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                this.field_70170_p.func_217376_c(\u2603);
                if (itemStack.func_82837_s()) {
                    \u2603.func_200203_b(itemStack.func_200301_q());
                }
                if (!playerEntity.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
            }
            return true;
        }
        return super.func_184645_a(playerEntity, hand);
    }

    protected boolean func_190730_o() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (super.func_70097_a(damageSource, f)) {
            LivingEntity livingEntity = this.func_70638_az();
            if (livingEntity == null && damageSource.func_76346_g() instanceof LivingEntity) {
                livingEntity = (LivingEntity)damageSource.func_76346_g();
            }
            if (livingEntity != null && this.field_70170_p.func_175659_aa() == Difficulty.HARD && (double)this.field_70146_Z.nextFloat() < this.func_110148_a(field_110186_bp).func_111126_e() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
                int n = MathHelper.func_76128_c(this.func_226277_ct_());
                \u2603 = MathHelper.func_76128_c(this.func_226278_cu_());
                \u2603 = MathHelper.func_76128_c(this.func_226281_cx_());
                ZombieEntity \u26032 = new ZombieEntity(this.field_70170_p);
                for (\u2603 = 0; \u2603 < 50; ++\u2603) {
                    \u2603 = n + MathHelper.func_76136_a(this.field_70146_Z, 7, 40) * MathHelper.func_76136_a(this.field_70146_Z, -1, 1);
                    BlockPos blockPos = new BlockPos(\u2603, (\u2603 = \u2603 + MathHelper.func_76136_a(this.field_70146_Z, 7, 40) * MathHelper.func_76136_a(this.field_70146_Z, -1, 1)) - 1, \u2603 = \u2603 + MathHelper.func_76136_a(this.field_70146_Z, 7, 40) * MathHelper.func_76136_a(this.field_70146_Z, -1, 1));
                    if (!this.field_70170_p.func_180495_p(blockPos).func_215682_a(this.field_70170_p, blockPos, \u26032) || this.field_70170_p.func_201696_r(new BlockPos(\u2603, \u2603, \u2603)) >= 10) continue;
                    \u26032.func_70107_b(\u2603, \u2603, \u2603);
                    if (this.field_70170_p.func_217358_a(\u2603, \u2603, \u2603, 7.0) || !this.field_70170_p.func_226668_i_(\u26032) || !this.field_70170_p.func_226669_j_(\u26032) || this.field_70170_p.func_72953_d(\u26032.func_174813_aQ())) continue;
                    this.field_70170_p.func_217376_c(\u26032);
                    \u26032.func_70624_b(livingEntity);
                    \u26032.func_213386_a(this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos(\u26032)), SpawnReason.REINFORCEMENT, null, null);
                    this.func_110148_a(field_110186_bp).func_111121_a(new AttributeModifier("Zombie reinforcement caller charge", -0.05f, AttributeModifier.Operation.ADDITION));
                    \u26032.func_110148_a(field_110186_bp).func_111121_a(new AttributeModifier("Zombie reinforcement callee charge", -0.05f, AttributeModifier.Operation.ADDITION));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean bl = super.func_70652_k(entity);
        if (bl) {
            float f = this.field_70170_p.func_175649_E(new BlockPos(this)).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entity.func_70015_d(2 * (int)f);
            }
        }
        return bl;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187934_hh;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    protected SoundEvent func_190731_di() {
        return SoundEvents.field_187939_hm;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(this.func_190731_di(), 0.15f, 1.0f);
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        super.func_180481_a(difficultyInstance);
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int n = this.field_70146_Z.nextInt(3);
            if (n == 0) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151040_l));
            } else {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151037_a));
            }
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        if (this.func_70631_g_()) {
            compoundNBT.func_74757_a("IsBaby", true);
        }
        compoundNBT.func_74757_a("CanBreakDoors", this.func_146072_bX());
        compoundNBT.func_74768_a("InWaterTime", this.func_70090_H() ? this.field_204707_bD : -1);
        compoundNBT.func_74768_a("DrownedConversionTime", this.func_204706_dD() ? this.field_204708_bE : -1);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        if (compoundNBT.func_74767_n("IsBaby")) {
            this.func_82227_f(true);
        }
        this.func_146070_a(compoundNBT.func_74767_n("CanBreakDoors"));
        this.field_204707_bD = compoundNBT.func_74762_e("InWaterTime");
        if (compoundNBT.func_150297_b("DrownedConversionTime", 99) && compoundNBT.func_74762_e("DrownedConversionTime") > -1) {
            this.func_204704_a(compoundNBT.func_74762_e("DrownedConversionTime"));
        }
    }

    @Override
    public void func_70074_a(LivingEntity livingEntity) {
        super.func_70074_a(livingEntity);
        if ((this.field_70170_p.func_175659_aa() == Difficulty.NORMAL || this.field_70170_p.func_175659_aa() == Difficulty.HARD) && livingEntity instanceof VillagerEntity) {
            if (this.field_70170_p.func_175659_aa() != Difficulty.HARD && this.field_70146_Z.nextBoolean()) {
                return;
            }
            VillagerEntity villagerEntity = (VillagerEntity)livingEntity;
            ZombieVillagerEntity \u26032 = EntityType.field_200727_aF.func_200721_a(this.field_70170_p);
            \u26032.func_82149_j(villagerEntity);
            villagerEntity.func_70106_y();
            \u26032.func_213386_a(this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos(\u26032)), SpawnReason.CONVERSION, new GroupData(false), null);
            \u26032.func_213792_a(villagerEntity.func_213700_eh());
            \u26032.func_223727_a((INBT)villagerEntity.func_223722_es().func_220914_a(NBTDynamicOps.field_210820_a).getValue());
            \u26032.func_213790_g(villagerEntity.func_213706_dY().func_222199_a());
            \u26032.func_213789_a(villagerEntity.func_213708_dV());
            \u26032.func_82227_f(villagerEntity.func_70631_g_());
            \u26032.func_94061_f(villagerEntity.func_175446_cd());
            if (villagerEntity.func_145818_k_()) {
                \u26032.func_200203_b(villagerEntity.func_200201_e());
                \u26032.func_174805_g(villagerEntity.func_174833_aM());
            }
            if (this.func_104002_bU()) {
                \u26032.func_110163_bv();
            }
            \u26032.func_184224_h(this.func_190530_aW());
            this.field_70170_p.func_217376_c(\u26032);
            this.field_70170_p.func_217378_a(null, 1026, new BlockPos(this), 0);
        }
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return this.func_70631_g_() ? 0.93f : 1.74f;
    }

    @Override
    protected boolean func_175448_a(ItemStack itemStack) {
        if (itemStack.func_77973_b() == Items.field_151110_aK && this.func_70631_g_() && this.func_184218_aH()) {
            return false;
        }
        return super.func_175448_a(itemStack);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld2, DifficultyInstance difficultyInstance2, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData2, @Nullable CompoundNBT compoundNBT) {
        Object object;
        ILivingEntityData iLivingEntityData2 = super.func_213386_a(iWorld2, difficultyInstance2, spawnReason, iLivingEntityData2, compoundNBT);
        float \u26032 = difficultyInstance2.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * \u26032);
        if (iLivingEntityData2 == null) {
            iLivingEntityData2 = new GroupData(iWorld2.func_201674_k().nextFloat() < 0.05f);
        }
        if (iLivingEntityData2 instanceof GroupData) {
            DifficultyInstance difficultyInstance2;
            object = (GroupData)iLivingEntityData2;
            if (((GroupData)object).field_142048_a) {
                IWorld iWorld2;
                List<Entity> list;
                this.func_82227_f(true);
                if ((double)iWorld2.func_201674_k().nextFloat() < 0.05) {
                    list = iWorld2.func_175647_a(ChickenEntity.class, this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0), EntityPredicates.field_152785_b);
                    if (!list.isEmpty()) {
                        ChickenEntity chickenEntity = (ChickenEntity)list.get(0);
                        chickenEntity.func_152117_i(true);
                        this.func_184220_m(chickenEntity);
                    }
                } else if ((double)iWorld2.func_201674_k().nextFloat() < 0.05) {
                    list = EntityType.field_200795_i.func_200721_a(this.field_70170_p);
                    ((Entity)((Object)list)).func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
                    ((AgeableEntity)((Object)list)).func_213386_a(iWorld2, difficultyInstance2, SpawnReason.JOCKEY, null, null);
                    ((ChickenEntity)((Object)list)).func_152117_i(true);
                    iWorld2.func_217376_c((Entity)((Object)list));
                    this.func_184220_m((Entity)((Object)list));
                }
            }
            this.func_146070_a(this.func_204900_dz() && this.field_70146_Z.nextFloat() < \u26032 * 0.1f);
            this.func_180481_a(difficultyInstance2);
            this.func_180483_b(difficultyInstance2);
        }
        if (this.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
            object = LocalDate.now();
            int \u26033 = ((LocalDate)object).get(ChronoField.DAY_OF_MONTH);
            int \u26034 = ((LocalDate)object).get(ChronoField.MONTH_OF_YEAR);
            if (\u26034 == 10 && \u26033 == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
                this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_196628_cT : Blocks.field_196625_cS));
                this.field_184655_bs[EquipmentSlotType.HEAD.func_188454_b()] = 0.0f;
            }
        }
        this.func_207304_a(\u26032);
        return iLivingEntityData2;
    }

    protected void func_207304_a(float f) {
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * (double)0.05f, AttributeModifier.Operation.ADDITION));
        double d = this.field_70146_Z.nextDouble() * 1.5 * (double)f;
        if (d > 1.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random zombie-spawn bonus", d, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.field_70146_Z.nextFloat() < f * 0.05f) {
            this.func_110148_a(field_110186_bp).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 0.25 + 0.5, AttributeModifier.Operation.ADDITION));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            this.func_146070_a(this.func_204900_dz());
        }
    }

    @Override
    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    @Override
    protected void func_213333_a(DamageSource damageSource, int n, boolean bl) {
        super.func_213333_a(damageSource, n, bl);
        Entity entity = damageSource.func_76346_g();
        if (entity instanceof CreeperEntity && (\u2603 = (CreeperEntity)entity).func_70650_aV()) {
            \u2603.func_175493_co();
            ItemStack itemStack = this.func_190732_dj();
            if (!itemStack.func_190926_b()) {
                this.func_199701_a_(itemStack);
            }
        }
    }

    protected ItemStack func_190732_dj() {
        return new ItemStack(Items.field_196186_dz);
    }

    class AttackTurtleEggGoal
    extends BreakBlockGoal {
        AttackTurtleEggGoal(CreatureEntity creatureEntity, double d, int n) {
            super(Blocks.field_203213_jA, creatureEntity, d, n);
        }

        @Override
        public void func_203114_b(IWorld iWorld, BlockPos blockPos) {
            iWorld.func_184133_a(null, blockPos, SoundEvents.field_203276_jU, SoundCategory.HOSTILE, 0.5f, 0.9f + ZombieEntity.this.field_70146_Z.nextFloat() * 0.2f);
        }

        @Override
        public void func_203116_c(World world, BlockPos blockPos) {
            world.func_184133_a(null, blockPos, SoundEvents.field_203281_iz, SoundCategory.BLOCKS, 0.7f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
        }

        @Override
        public double func_203110_f() {
            return 1.14;
        }
    }

    public class GroupData
    implements ILivingEntityData {
        public final boolean field_142048_a;

        private GroupData(boolean bl) {
            this.field_142048_a = bl;
        }
    }
}

