/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.ResourceLocation;

public class FunctionObject {
    private final IEntry[] field_193530_b;
    private final ResourceLocation field_197002_b;

    public FunctionObject(ResourceLocation resourceLocation, IEntry[] iEntryArray) {
        this.field_197002_b = resourceLocation;
        this.field_193530_b = iEntryArray;
    }

    public ResourceLocation func_197001_a() {
        return this.field_197002_b;
    }

    public IEntry[] func_193528_a() {
        return this.field_193530_b;
    }

    public static FunctionObject func_197000_a(ResourceLocation resourceLocation, FunctionManager functionManager, List<String> list) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        for (int i = 0; i < list.size(); ++i) {
            \u2603 = i + 1;
            String string = list.get(i).trim();
            StringReader \u26032 = new StringReader(string);
            if (!\u26032.canRead() || \u26032.peek() == '#') continue;
            if (\u26032.peek() == '/') {
                \u26032.skip();
                if (\u26032.peek() == '/') {
                    throw new IllegalArgumentException("Unknown or invalid command '" + string + "' on line " + \u2603 + " (if you intended to make a comment, use '#' not '//')");
                }
                \u2603 = \u26032.readUnquotedString();
                throw new IllegalArgumentException("Unknown or invalid command '" + string + "' on line " + \u2603 + " (did you mean '" + \u2603 + "'? Do not use a preceding forwards slash.)");
            }
            try {
                \u2603 = functionManager.func_195450_a().func_195571_aL().func_197054_a().parse(\u26032, (Object)functionManager.func_223402_g());
                if (\u2603.getReader().canRead()) {
                    throw Commands.func_227481_a_(\u2603);
                }
                arrayList.add(new CommandEntry((ParseResults<CommandSource>)\u2603));
                continue;
            }
            catch (CommandSyntaxException \u26033) {
                throw new IllegalArgumentException("Whilst parsing command on line " + \u2603 + ": " + \u26033.getMessage());
            }
        }
        return new FunctionObject(resourceLocation, arrayList.toArray(new IEntry[0]));
    }

    public static class CacheableFunction {
        public static final CacheableFunction field_193519_a = new CacheableFunction((ResourceLocation)null);
        @Nullable
        private final ResourceLocation field_193520_b;
        private boolean field_193521_c;
        private Optional<FunctionObject> field_193522_d = Optional.empty();

        public CacheableFunction(@Nullable ResourceLocation resourceLocation) {
            this.field_193520_b = resourceLocation;
        }

        public CacheableFunction(FunctionObject functionObject) {
            this.field_193521_c = true;
            this.field_193520_b = null;
            this.field_193522_d = Optional.of(functionObject);
        }

        public Optional<FunctionObject> func_218039_a(FunctionManager functionManager) {
            if (!this.field_193521_c) {
                if (this.field_193520_b != null) {
                    this.field_193522_d = functionManager.func_215361_a(this.field_193520_b);
                }
                this.field_193521_c = true;
            }
            return this.field_193522_d;
        }

        @Nullable
        public ResourceLocation func_200376_a() {
            return this.field_193522_d.map(functionObject -> ((FunctionObject)functionObject).field_197002_b).orElse(this.field_193520_b);
        }
    }

    public static class FunctionEntry
    implements IEntry {
        private final CacheableFunction field_193524_a;

        public FunctionEntry(FunctionObject functionObject) {
            this.field_193524_a = new CacheableFunction(functionObject);
        }

        @Override
        public void func_196998_a(FunctionManager functionManager, CommandSource commandSource, ArrayDeque<FunctionManager.QueuedCommand> arrayDeque, int n) {
            this.field_193524_a.func_218039_a(functionManager).ifPresent(functionObject -> {
                IEntry[] iEntryArray = functionObject.func_193528_a();
                int \u26032 = n - arrayDeque.size();
                int \u26033 = Math.min(iEntryArray.length, \u26032);
                for (int i = \u26033 - 1; i >= 0; --i) {
                    arrayDeque.addFirst(new FunctionManager.QueuedCommand(functionManager, commandSource, iEntryArray[i]));
                }
            });
        }

        public String toString() {
            return "function " + this.field_193524_a.func_200376_a();
        }
    }

    public static class CommandEntry
    implements IEntry {
        private final ParseResults<CommandSource> field_196999_a;

        public CommandEntry(ParseResults<CommandSource> parseResults) {
            this.field_196999_a = parseResults;
        }

        @Override
        public void func_196998_a(FunctionManager functionManager, CommandSource commandSource, ArrayDeque<FunctionManager.QueuedCommand> arrayDeque, int n) throws CommandSyntaxException {
            functionManager.func_195446_d().execute(new ParseResults(this.field_196999_a.getContext().withSource((Object)commandSource), this.field_196999_a.getReader(), this.field_196999_a.getExceptions()));
        }

        public String toString() {
            return this.field_196999_a.getReader().getString();
        }
    }

    public static interface IEntry {
        public void func_196998_a(FunctionManager var1, CommandSource var2, ArrayDeque<FunctionManager.QueuedCommand> var3, int var4) throws CommandSyntaxException;
    }
}

