/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.CampfireTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class CampfireBlock
extends ContainerBlock
implements IWaterLoggable {
    protected static final VoxelShape field_220100_a = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 7.0, 16.0);
    public static final BooleanProperty field_220101_b = BlockStateProperties.field_208190_q;
    public static final BooleanProperty field_220102_c = BlockStateProperties.field_222516_y;
    public static final BooleanProperty field_220103_d = BlockStateProperties.field_208198_y;
    public static final DirectionProperty field_220104_e = BlockStateProperties.field_208157_J;
    private static final VoxelShape field_226912_f_ = Block.func_208617_a(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);

    public CampfireBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_220101_b, true)).func_206870_a(field_220102_c, false)).func_206870_a(field_220103_d, false)).func_206870_a(field_220104_e, Direction.NORTH));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (blockState.func_177229_b(field_220101_b).booleanValue() && (\u2603 = world.func_175625_s(blockPos)) instanceof CampfireTileEntity && (\u2603 = (\u2603 = (CampfireTileEntity)\u2603).func_213980_a(\u2603 = playerEntity.func_184586_b(hand))).isPresent()) {
            if (!world.field_72995_K && \u2603.func_213984_a(playerEntity.field_71075_bZ.field_75098_d ? \u2603.func_77946_l() : \u2603, \u2603.get().func_222137_e())) {
                playerEntity.func_195066_a(Stats.field_219736_at);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    @Override
    public void func_196262_a(BlockState blockState, World world, BlockPos blockPos, Entity entity) {
        if (!entity.func_70045_F() && blockState.func_177229_b(field_220101_b).booleanValue() && entity instanceof LivingEntity && !EnchantmentHelper.func_189869_j((LivingEntity)entity)) {
            entity.func_70097_a(DamageSource.field_76372_a, 1.0f);
        }
        super.func_196262_a(blockState, world, blockPos, entity);
    }

    @Override
    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState.func_177230_c() == blockState2.func_177230_c()) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof CampfireTileEntity) {
            InventoryHelper.func_219961_a(world, blockPos, ((CampfireTileEntity)tileEntity).func_213985_c());
        }
        super.func_196243_a(blockState, world, blockPos, blockState2, bl);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        World world = blockItemUseContext.func_195991_k();
        boolean \u26032 = world.func_204610_c(\u2603 = blockItemUseContext.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(field_220103_d, \u26032)).func_206870_a(field_220102_c, this.func_220099_j(world.func_180495_p(\u2603.func_177977_b())))).func_206870_a(field_220101_b, !\u26032)).func_206870_a(field_220104_e, blockItemUseContext.func_195992_f());
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (blockState.func_177229_b(field_220103_d).booleanValue()) {
            iWorld.func_205219_F_().func_205360_a(blockPos, Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a(iWorld));
        }
        if (direction == Direction.DOWN) {
            return (BlockState)blockState.func_206870_a(field_220102_c, this.func_220099_j(blockState2));
        }
        return super.func_196271_a(blockState, direction, blockState2, iWorld, blockPos, blockPos2);
    }

    private boolean func_220099_j(BlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150407_cf;
    }

    @Override
    public int func_149750_m(BlockState blockState) {
        return blockState.func_177229_b(field_220101_b) != false ? super.func_149750_m(blockState) : 0;
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return field_220100_a;
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    @Override
    public boolean func_204509_a(IWorld iWorld2, BlockPos blockPos, BlockState blockState, IFluidState iFluidState) {
        if (!blockState.func_177229_b(BlockStateProperties.field_208198_y).booleanValue() && iFluidState.func_206886_c() == Fluids.field_204546_a) {
            boolean bl = blockState.func_177229_b(field_220101_b);
            if (bl) {
                IWorld iWorld2;
                if (iWorld2.func_201670_d()) {
                    for (int i = 0; i < 20; ++i) {
                        CampfireBlock.func_220098_a(iWorld2.func_201672_e(), blockPos, blockState.func_177229_b(field_220102_c), true);
                    }
                } else {
                    iWorld2.func_184133_a(null, blockPos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                TileEntity \u26032 = iWorld2.func_175625_s(blockPos);
                if (\u26032 instanceof CampfireTileEntity) {
                    ((CampfireTileEntity)\u26032).func_213986_d();
                }
            }
            iWorld2.func_180501_a(blockPos, (BlockState)((BlockState)blockState.func_206870_a(field_220103_d, true)).func_206870_a(field_220101_b, false), 3);
            iWorld2.func_205219_F_().func_205360_a(blockPos, iFluidState.func_206886_c(), iFluidState.func_206886_c().func_205569_a(iWorld2));
            return true;
        }
        return false;
    }

    @Nullable
    private Entity func_226913_a_(Entity entity) {
        if (entity instanceof AbstractFireballEntity) {
            return ((AbstractFireballEntity)entity).field_70235_a;
        }
        if (entity instanceof AbstractArrowEntity) {
            return ((AbstractArrowEntity)entity).func_212360_k();
        }
        return null;
    }

    @Override
    public void func_220066_a(World world, BlockState blockState, BlockRayTraceResult blockRayTraceResult, Entity entity) {
        if (!world.field_72995_K) {
            boolean bl = \u2603 = entity instanceof AbstractFireballEntity || entity instanceof AbstractArrowEntity && entity.func_70027_ad();
            if (\u2603) {
                \u2603 = this.func_226913_a_(entity);
                boolean bl2 = \u2603 = \u2603 == null || \u2603 instanceof PlayerEntity || world.func_82736_K().func_223586_b(GameRules.field_223599_b);
                if (\u2603 && !blockState.func_177229_b(field_220101_b).booleanValue() && !blockState.func_177229_b(field_220103_d).booleanValue()) {
                    BlockPos blockPos = blockRayTraceResult.func_216350_a();
                    world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(BlockStateProperties.field_208190_q, true), 11);
                }
            }
        }
    }

    public static void func_220098_a(World world, BlockPos blockPos, boolean bl, boolean bl2) {
        Random random = world.func_201674_k();
        BasicParticleType \u26032 = bl ? ParticleTypes.field_218418_af : ParticleTypes.field_218417_ae;
        world.func_217404_b(\u26032, true, (double)blockPos.func_177958_n() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)blockPos.func_177956_o() + random.nextDouble() + random.nextDouble(), (double)blockPos.func_177952_p() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (bl2) {
            world.func_195594_a(ParticleTypes.field_197601_L, (double)blockPos.func_177958_n() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), (double)blockPos.func_177956_o() + 0.4, (double)blockPos.func_177952_p() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean func_226914_b_(World world, BlockPos blockPos, int n) {
        for (\u2603 = 1; \u2603 <= n; ++\u2603) {
            BlockPos blockPos2 = blockPos.func_177979_c(\u2603);
            BlockState \u26032 = world.func_180495_p(blockPos2);
            if (CampfireBlock.func_226915_i_(\u26032)) {
                return true;
            }
            boolean \u26033 = VoxelShapes.func_197879_c(field_226912_f_, \u26032.func_215685_b(world, blockPos, ISelectionContext.func_216377_a()), IBooleanFunction.field_223238_i_);
            if (!\u26033) continue;
            BlockState \u26034 = world.func_180495_p(blockPos2.func_177977_b());
            return CampfireBlock.func_226915_i_(\u26034);
        }
        return false;
    }

    private static boolean func_226915_i_(BlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_222433_lV && blockState.func_177229_b(field_220101_b) != false;
    }

    @Override
    public IFluidState func_204507_t(BlockState blockState) {
        if (blockState.func_177229_b(field_220103_d).booleanValue()) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        return super.func_204507_t(blockState);
    }

    @Override
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.func_206870_a(field_220104_e, rotation.func_185831_a(blockState.func_177229_b(field_220104_e)));
    }

    @Override
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return blockState.func_185907_a(mirror.func_185800_a(blockState.func_177229_b(field_220104_e)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_220101_b, field_220102_c, field_220103_d, field_220104_e);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new CampfireTileEntity();
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

