/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees2.command;

import com.davenonymous.bonsaitrees2.block.ModObjects;
import com.davenonymous.bonsaitrees2.registry.sapling.SaplingDrop;
import com.davenonymous.bonsaitrees2.registry.sapling.SaplingInfo;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CommandListSaplingDrops
implements Command<CommandSource> {
    private static final CommandListSaplingDrops CMD = new CommandListSaplingDrops();

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"drops").then(Commands.func_197056_a((String)"type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            Stream<String> saplingIds = ModObjects.saplingRecipeHelper.getRecipeStream(((CommandSource)context.getSource()).func_197023_e().func_199532_z()).map(r -> r.func_199560_c().toString());
            return ISuggestionProvider.func_197013_a(saplingIds, (SuggestionsBuilder)builder);
        }).executes((Command)CMD))).requires(cs -> cs.func_197034_c(0))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        if (((CommandSource)context.getSource()).func_197023_e() == null) {
            return 0;
        }
        String type = StringArgumentType.getString(context, (String)"type");
        Optional<SaplingInfo> optSaplingInfo = ModObjects.saplingRecipeHelper.getRecipeStream(((CommandSource)context.getSource()).func_197023_e().func_199532_z()).filter(s -> s.func_199560_c().toString().equals(type)).findFirst();
        if (!optSaplingInfo.isPresent()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Unknown bonsai tree: " + type), false);
            return 0;
        }
        SaplingInfo saplingInfo = optSaplingInfo.get();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Registered drops for bonsai tree: " + type), false);
        for (SaplingDrop drop : saplingInfo.drops) {
            ITextComponent stackName = drop.resultStack.func_200301_q();
            stackName = stackName.func_150257_a((ITextComponent)new StringTextComponent(String.format(" [chance=%.2f, rolls=%d]", Float.valueOf(drop.chance), drop.rolls)));
            ((CommandSource)context.getSource()).func_197030_a(stackName, false);
        }
        return 1;
    }
}

