/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone;

import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.telepathicgrunt.bumblezone.ClientEvents;
import net.telepathicgrunt.bumblezone.biome.BzBaseBiome;
import net.telepathicgrunt.bumblezone.biome.BzBiomes;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;
import net.telepathicgrunt.bumblezone.blocks.SugarWaterEvents;
import net.telepathicgrunt.bumblezone.capabilities.CapabilityPlayerPosAndDim;
import net.telepathicgrunt.bumblezone.config.BzConfig;
import net.telepathicgrunt.bumblezone.effects.BzEffects;
import net.telepathicgrunt.bumblezone.features.BzFeatures;
import net.telepathicgrunt.bumblezone.items.BzItems;
import net.telepathicgrunt.bumblezone.items.SugarWaterBottleDispenseBehavior;
import net.telepathicgrunt.bumblezone.modcompatibility.ModChecking;
import net.telepathicgrunt.bumblezone.utils.ConfigHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="the_bumblezone")
public class Bumblezone {
    public static final String MODID = "the_bumblezone";
    public static final Logger LOGGER = LogManager.getLogger((String)"the_bumblezone");
    public static BzConfig.BzConfigValues BzConfig = null;

    public Bumblezone() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(this::setup);
        BzBlocks.BLOCKS.register(modEventBus);
        BzItems.ITEMS.register(modEventBus);
        BzBlocks.FLUIDS.register(modEventBus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEvents.subscribeClientEvents(modEventBus, forgeBus));
        BzConfig = ConfigHelper.register(ModConfig.Type.SERVER, (builder, subscriber) -> new BzConfig.BzConfigValues((ForgeConfigSpec.Builder)builder, (ConfigHelper.Subscriber)subscriber));
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityPlayerPosAndDim.register();
        SugarWaterEvents.setup();
        BzBaseBiome.addSprings();
        DefaultDispenseItemBehavior idispenseitembehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior field_218406_b = new DefaultDispenseItemBehavior();

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BucketItem bucketitem = (BucketItem)stack.func_77973_b();
                BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a));
                World world = source.func_197524_h();
                if (bucketitem.func_180616_a((PlayerEntity)null, world, blockpos, (BlockRayTraceResult)null)) {
                    bucketitem.func_203792_a(world, stack, blockpos);
                    return new ItemStack((IItemProvider)Items.field_151133_ar);
                }
                return this.field_218406_b.dispense(source, stack);
            }
        };
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)BzItems.SUGAR_WATER_BUCKET.get()), (IDispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)BzItems.SUGAR_WATER_BOTTLE.get()), (IDispenseItemBehavior)new SugarWaterBottleDispenseBehavior());
        DeferredWorkQueue.runLater(Bumblezone::lateSetup);
    }

    private static void lateSetup() {
        ModChecking.setupModCompat();
        BzBiomes.addVanillaSlimeMobs();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerBiomes(RegistryEvent.Register<Biome> event) {
            BzBiomes.registerBiomes(event);
        }

        @SubscribeEvent
        public static void onRegisterFeatures(RegistryEvent.Register<Feature<?>> event) {
            BzFeatures.registerFeatures(event);
        }

        @SubscribeEvent
        public static void onRegisterEffects(RegistryEvent.Register<Effect> event) {
            BzEffects.registerEffects(event);
        }
    }
}

