/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.items;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import wile.engineerstools.ModContent;
import wile.engineerstools.items.EtItem;
import wile.engineerstools.items.MusliBarItem;
import wile.engineerstools.libmc.detail.Auxiliaries;
import wile.engineerstools.libmc.detail.Networking;

public class MusliBarPressItem
extends EtItem {
    private static int max_seed_storage = 512;
    private static int max_food_storage = 128 * MusliBarItem.healing();
    private static int seeds_per_bar = 1;
    private static int food_per_bar = MusliBarItem.healing();

    public static void on_config(int seed_storage, int food_storage, int seeds_needed_per_bar, int food_value_needed_per_bar) {
        int healing = Math.max(1, MusliBarItem.healing());
        max_seed_storage = MathHelper.func_76125_a((int)seed_storage, (int)64, (int)1024);
        max_food_storage = MathHelper.func_76125_a((int)food_storage, (int)64, (int)1024) * healing;
        seeds_per_bar = MathHelper.func_76125_a((int)seeds_needed_per_bar, (int)1, (int)32);
        food_per_bar = MathHelper.func_76125_a((int)food_value_needed_per_bar, (int)healing, (int)128);
        Auxiliaries.logInfo("Musli Press: storage:" + max_food_storage + "hunger/" + max_seed_storage + "seeds, bar:" + food_per_bar + "hunger/" + seeds_per_bar + "seeds");
    }

    public MusliBarPressItem(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.func_201670_d()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent(MusliBarPressItem.this.getRegistryName().toString(), new Object[0]);
                }

                public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                    return new MusliBarPressContainer(id, inventory, player);
                }
            });
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    private static boolean isValidFood(ItemStack stack) {
        if (!stack.func_77973_b().func_219971_r() || stack.func_77973_b().func_219967_s() == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof MusliBarItem) {
            return false;
        }
        return !stack.func_77973_b().getTags().contains(new ResourceLocation(Auxiliaries.modid(), "musli_bar_food_blacklisted"));
    }

    private static boolean isValidSeeds(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151014_N) {
            return true;
        }
        return stack.func_77973_b().getTags().contains(new ResourceLocation(Auxiliaries.modid(), "musli_bar_seeds"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MusliBarPressGui
    extends ContainerScreen<MusliBarPressContainer> {
        private static final ResourceLocation BACKGROUND_IMAGE = new ResourceLocation(Auxiliaries.modid(), "textures/gui/musli_bar_press_gui.png");
        private final PlayerEntity player;

        public MusliBarPressGui(MusliBarPressContainer container, PlayerInventory player_inventory, ITextComponent title) {
            super((Container)container, player_inventory, title);
            this.player = player_inventory.field_70458_d;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            super.render(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_IMAGE);
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            int w = this.getXSize();
            int h = this.getYSize();
            this.blit(x0, y0, 0, 0, w, h);
            this.blit(x0 + 48, y0 + 45, 180, 45, this.seeds_px(43), 7);
            this.blit(x0 + 48, y0 + 54, 180, 54, this.food_px(43), 7);
            MusliBarPressContainer.ReadonlySlot slot = ((MusliBarPressContainer)this.func_212873_a_()).muslipress_slot_;
            if (slot != null) {
                this.blit(x0 + slot.field_75223_e, y0 + slot.field_75221_f, 181, 144, 16, 16);
            }
        }

        private int seeds_px(int pixels) {
            int v = MathHelper.func_76125_a((int)((MusliBarPressContainer)this.func_212873_a_()).seeds_stored, (int)0, (int)max_seed_storage);
            if (v <= 0 || max_seed_storage <= 0) {
                return 0;
            }
            return Math.max(1, (int)(Math.sqrt(v) / Math.sqrt(max_seed_storage) * (double)pixels));
        }

        private int food_px(int pixels) {
            int v = MathHelper.func_76125_a((int)((MusliBarPressContainer)this.func_212873_a_()).food_stored, (int)0, (int)max_food_storage);
            if (v <= 0 || max_food_storage <= 0) {
                return 0;
            }
            return Math.max(1, (int)(Math.sqrt(v) / Math.sqrt(max_food_storage) * (double)pixels));
        }
    }

    public static class MusliBarPressContainer
    extends Container
    implements Networking.INetworkSynchronisableContainer {
        private static final int INPUT_SLOTNO = 0;
        private static final int OUTPUT_SLOTNO = 1;
        private static final int PLAYER_INV_START_SLOTNO = 2;
        private PlayerEntity player;
        private PlayerInventory player_inventory;
        private Inventory inventory_ = new Inventory(2);
        private final ItemStack muslipress;
        private ReadonlySlot muslipress_slot_ = null;
        private int seeds_stored = 0;
        private int food_stored = 0;

        public MusliBarPressContainer(int cid, PlayerInventory player_inventory) {
            this(cid, player_inventory, player_inventory.field_70458_d);
        }

        public MusliBarPressContainer(int cid, PlayerInventory player_inventory, PlayerEntity player) {
            super(ModContent.CT_MUSLI_BAR_PRESS, cid);
            this.player_inventory = player_inventory;
            this.player = player;
            if (player_inventory.field_70461_c < 0 || player_inventory.field_70461_c >= player_inventory.func_70302_i_() || !(player_inventory.func_70301_a(player_inventory.field_70461_c).func_77973_b() instanceof MusliBarPressItem)) {
                this.muslipress = new ItemStack((IItemProvider)Items.field_190931_a);
                return;
            }
            this.muslipress = player_inventory.func_70301_a(player_inventory.field_70461_c);
            int i = -1;
            this.func_75146_a(new InputSlot(this, (IInventory)this.inventory_, ++i, 31, 45));
            this.func_75146_a(new OutputSlot(this, (IInventory)this.inventory_, ++i, 92, 45));
            for (int x = 0; x < 9; ++x) {
                int slot = x;
                if (player_inventory.field_70461_c != slot) {
                    this.func_75146_a(new Slot((IInventory)player_inventory, slot, 8 + x * 18, 144));
                    continue;
                }
                this.muslipress_slot_ = new ReadonlySlot((IInventory)player_inventory, slot, 8 + x * 18, 144);
                this.func_75146_a(this.muslipress_slot_);
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    int slot = x + y * 9 + 9;
                    if (player_inventory.field_70461_c != slot) {
                        this.func_75146_a(new Slot((IInventory)player_inventory, slot, 8 + x * 18, 86 + y * 18));
                        continue;
                    }
                    this.muslipress_slot_ = new ReadonlySlot((IInventory)player_inventory, slot, 8 + x * 18, 86 + y * 18);
                    this.func_75146_a(this.muslipress_slot_);
                }
            }
            this.read(this.muslipress.func_77978_p());
        }

        public boolean func_75145_c(PlayerEntity player) {
            return player == this.player;
        }

        public ItemStack func_82846_b(PlayerEntity player, int index) {
            Slot slot = this.func_75139_a(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(slot_stack, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 1) {
                if (!this.func_75135_a(slot_stack, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 2 && index < 38) {
                if (!MusliBarPressItem.isValidFood(slot_stack) && !MusliBarPressItem.isValidSeeds(slot_stack)) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(slot_stack, 0, 1, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }

        public void func_75134_a(PlayerEntity player) {
            super.func_75134_a(player);
            if (player.field_70170_p.func_201670_d()) {
                return;
            }
            this.muslipress.func_77982_d(this.write(this.muslipress.func_77978_p()));
        }

        @Override
        public void onClientPacketReceived(int windowId, PlayerEntity player, CompoundNBT pkg_nbt) {
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundNBT pkg_nbt) {
            if (!(this.muslipress.func_77973_b() instanceof MusliBarPressItem)) {
                return;
            }
            if (!pkg_nbt.func_74764_b("muslipress")) {
                return;
            }
            CompoundNBT nbt = pkg_nbt.func_74775_l("muslipress");
            this.read(nbt);
        }

        public CompoundNBT write(CompoundNBT nbt) {
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            nbt.func_74768_a("seeds_stored", this.seeds_stored);
            nbt.func_74768_a("food_stored", this.food_stored);
            nbt.func_218657_a("output_slot", (INBT)this.inventory_.func_70301_a(1).func_77955_b(new CompoundNBT()));
            nbt.func_218657_a("input_slot", (INBT)this.inventory_.func_70301_a(0).func_77955_b(new CompoundNBT()));
            return nbt;
        }

        public CompoundNBT read(CompoundNBT nbt) {
            if (nbt == null) {
                return nbt;
            }
            if (nbt.func_74764_b("seeds_stored")) {
                this.seeds_stored = nbt.func_74762_e("seeds_stored");
            }
            if (nbt.func_74764_b("food_stored")) {
                this.food_stored = nbt.func_74762_e("food_stored");
            }
            if (nbt.func_74764_b("output_slot")) {
                this.inventory_.func_70299_a(1, ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("output_slot")));
            }
            if (nbt.func_74764_b("input_slot")) {
                this.inventory_.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("input_slot")));
            }
            return nbt;
        }

        public void onSlotsChanged() {
            int hunger;
            if (this.player.field_70170_p.func_201670_d()) {
                return;
            }
            ItemStack stack = this.inventory_.func_70301_a(0);
            if (MusliBarPressItem.isValidSeeds(stack)) {
                this.seeds_stored += stack.func_190916_E();
                if (this.seeds_stored > max_seed_storage) {
                    stack.func_190920_e(this.seeds_stored - max_seed_storage);
                    this.seeds_stored = max_seed_storage;
                } else {
                    stack = ItemStack.field_190927_a;
                }
            } else if (MusliBarPressItem.isValidFood(stack) && (hunger = stack.func_77973_b().func_219967_s().func_221466_a()) > 0) {
                this.food_stored += stack.func_190916_E() * hunger;
                if (this.food_stored > max_food_storage) {
                    stack.func_190920_e((this.food_stored - max_food_storage) / hunger);
                    this.food_stored = max_food_storage;
                } else {
                    stack = ItemStack.field_190927_a;
                }
            }
            this.inventory_.func_70299_a(0, stack);
            while (this.inventory_.func_70301_a(1).func_190916_E() < 64 && this.food_stored >= food_per_bar && this.seeds_stored >= seeds_per_bar) {
                this.food_stored -= food_per_bar;
                this.seeds_stored -= seeds_per_bar;
                if (this.inventory_.func_70301_a(1).func_190926_b()) {
                    this.inventory_.func_70299_a(1, new ItemStack((IItemProvider)ModContent.MUSLI_BAR, 1));
                    continue;
                }
                this.inventory_.func_70301_a(1).func_190917_f(1);
            }
            CompoundNBT nbt = this.write(new CompoundNBT());
            this.muslipress.func_77982_d(nbt);
            this.player_inventory.func_70296_d();
            CompoundNBT pkg_nbt = new CompoundNBT();
            pkg_nbt.func_218657_a("muslipress", (INBT)nbt);
            Networking.PacketContainerSyncServerToClient.sendToPlayer(this.player, this.field_75152_c, pkg_nbt);
        }

        public static class ReadonlySlot
        extends Slot {
            public ReadonlySlot(IInventory inventory, int index, int xpos, int ypos) {
                super(inventory, index, xpos, ypos);
            }

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_75209_a(int amount) {
                return ItemStack.field_190927_a;
            }

            public boolean func_82869_a(PlayerEntity playerIn) {
                return false;
            }
        }

        public static class OutputSlot
        extends Slot {
            private final MusliBarPressContainer container;

            public OutputSlot(MusliBarPressContainer container, IInventory inventory, int index, int xpos, int ypos) {
                super(inventory, index, xpos, ypos);
                this.container = container;
            }

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public void func_75218_e() {
                this.field_75224_c.func_70296_d();
                this.container.onSlotsChanged();
            }
        }

        public static class InputSlot
        extends Slot {
            private final MusliBarPressContainer container;

            public InputSlot(MusliBarPressContainer container, IInventory inventory, int index, int xpos, int ypos) {
                super(inventory, index, xpos, ypos);
                this.container = container;
            }

            public boolean func_75214_a(ItemStack stack) {
                return MusliBarPressItem.isValidFood(stack) || MusliBarPressItem.isValidSeeds(stack);
            }

            public void func_75218_e() {
                this.field_75224_c.func_70296_d();
                this.container.onSlotsChanged();
            }
        }
    }
}

