/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.Dungeon;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModel;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlock;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlockType;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelRegistry;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.part.block.Spawner;
import xiroc.dungeoncrawl.part.block.WeightedRandomBlock;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.RotationHelper;
import xiroc.dungeoncrawl.util.Triple;

public class DungeonPieces {
    public static final CompoundNBT DEFAULT_NBT = DungeonPieces.getDefaultNBT();
    private static final Set<Block> BLOCKS_NEEDING_POSTPROCESSING = ImmutableSet.builder().add((Object)Blocks.field_150386_bk).add((Object)Blocks.field_150478_aa).add((Object)Blocks.field_196591_bQ).add((Object)Blocks.field_180407_aO).add((Object)Blocks.field_180408_aP).add((Object)Blocks.field_180406_aS).add((Object)Blocks.field_180405_aT).add((Object)Blocks.field_180404_aQ).add((Object)Blocks.field_180403_aR).add((Object)Blocks.field_150468_ap).add((Object)Blocks.field_150411_aY).add((Object)Blocks.field_150390_bg).add((Object)Blocks.field_196659_cl).add((Object)Blocks.field_150387_bl).add((Object)Blocks.field_150476_ad).add((Object)Blocks.field_150487_bG).add((Object)Blocks.field_150481_bH).add((Object)Blocks.field_150401_cl).add((Object)Blocks.field_150400_ck).add((Object)Blocks.field_150485_bF).add((Object)Blocks.field_203210_he).add((Object)Blocks.field_203211_hf).add((Object)Blocks.field_203212_hg).add((Object)Blocks.field_150372_bz).add((Object)Blocks.field_222439_lc).add((Object)Blocks.field_180396_cN).add((Object)Blocks.field_222408_kW).add((Object)Blocks.field_222443_lg).add((Object)Blocks.field_222441_le).add((Object)Blocks.field_222442_lf).add((Object)Blocks.field_222444_lh).add((Object)Blocks.field_222407_kV).add((Object)Blocks.field_222411_kZ).add((Object)Blocks.field_222409_kX).add((Object)Blocks.field_150473_bD).add((Object)Blocks.field_150488_af).build();

    public static CompoundNBT getDefaultNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("north", false);
        nbt.func_74757_a("east", false);
        nbt.func_74757_a("south", false);
        nbt.func_74757_a("west", false);
        nbt.func_74757_a("up", false);
        nbt.func_74757_a("down", false);
        nbt.func_74768_a("connectedSides", 0);
        nbt.func_74768_a("posX", -1);
        nbt.func_74768_a("posZ", -1);
        nbt.func_74768_a("theme", 0);
        nbt.func_74768_a("stage", -1);
        nbt.func_74768_a("rotation", 0);
        return nbt;
    }

    public static void addWalls(DungeonPiece piece, IWorld world, int theme) {
        int z;
        int y;
        int x;
        Theme buildTheme = Theme.get(theme);
        if (!piece.sides[0]) {
            for (x = 2; x < 6; ++x) {
                for (y = 2; y < 6; ++y) {
                    piece.setBlockState(buildTheme.solid.get(), world, null, piece.x + x, piece.y + y, piece.z, theme, 0, true);
                }
            }
        }
        if (!piece.sides[1]) {
            for (z = 2; z < 6; ++z) {
                for (y = 2; y < 6; ++y) {
                    piece.setBlockState(buildTheme.solid.get(), world, null, piece.x + 7, piece.y + y, piece.z + z, theme, 0, true);
                }
            }
        }
        if (!piece.sides[2]) {
            for (x = 2; x < 6; ++x) {
                for (y = 2; y < 6; ++y) {
                    piece.setBlockState(buildTheme.solid.get(), world, null, piece.x + x, piece.y + y, piece.z + 7, theme, 0, true);
                }
            }
        }
        if (!piece.sides[3]) {
            for (z = 2; z < 6; ++z) {
                for (y = 2; y < 6; ++y) {
                    piece.setBlockState(buildTheme.solid.get(), world, null, piece.x, piece.y + y, piece.z + z, theme, 0, true);
                }
            }
        }
    }

    public static void addColumns(DungeonPiece piece, IWorld world, int ySub, int theme) {
        Theme buildTheme = Theme.get(theme);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.stairs.get().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH)).func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, null, piece.x + 2, piece.y - ySub, piece.z + 2, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.stairs.get().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH)).func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, null, piece.x + 3, piece.y - ySub, piece.z + 2, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.stairs.get().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH)).func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, null, piece.x + 4, piece.y - ySub, piece.z + 2, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.stairs.get().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH)).func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, null, piece.x + 5, piece.y - ySub, piece.z + 2, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.stairs.get().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, null, piece.x + 2, piece.y - ySub, piece.z + 5, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.stairs.get().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, null, piece.x + 3, piece.y - ySub, piece.z + 5, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.stairs.get().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, null, piece.x + 4, piece.y - ySub, piece.z + 5, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.stairs.get().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, null, piece.x + 5, piece.y - ySub, piece.z + 5, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.stairs.get().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.EAST)).func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, null, piece.x + 2, piece.y - ySub, piece.z + 3, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.stairs.get().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.EAST)).func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, null, piece.x + 2, piece.y - ySub, piece.z + 4, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.stairs.get().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.WEST)).func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, null, piece.x + 5, piece.y - ySub, piece.z + 3, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.stairs.get().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.WEST)).func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, null, piece.x + 5, piece.y - ySub, piece.z + 4, theme, 0, true);
        for (int x = 3; x < 5; ++x) {
            for (int z = 3; z < 5; ++z) {
                int groundHeight = DungeonPieces.getGroudHeightFrom(world, piece.x + x, piece.z + z, piece.y - ySub);
                for (int y = piece.y - ySub; y > groundHeight; --y) {
                    piece.setBlockState(buildTheme.column.get(), world, null, piece.x + x, y, piece.z + z, theme, 0, true);
                }
            }
        }
    }

    public static BlockPos shiftPosition(BlockPos start, Direction direction, int amount) {
        switch (direction) {
            case DOWN: {
                return new BlockPos(start.func_177958_n(), start.func_177956_o() - amount, start.func_177952_p());
            }
            case EAST: {
                return new BlockPos(start.func_177958_n() + amount, start.func_177956_o(), start.func_177952_p());
            }
            case NORTH: {
                return new BlockPos(start.func_177958_n(), start.func_177956_o(), start.func_177952_p() - amount);
            }
            case SOUTH: {
                return new BlockPos(start.func_177958_n(), start.func_177956_o(), start.func_177952_p() + amount);
            }
            case WEST: {
                return new BlockPos(start.func_177958_n() - amount, start.func_177956_o(), start.func_177952_p());
            }
            case UP: {
                return new BlockPos(start.func_177958_n(), start.func_177956_o() + amount, start.func_177952_p());
            }
        }
        return start;
    }

    public static int getGroudHeight(IWorld world, int x, int z) {
        for (int y = 255; y > 0; --y) {
            if (!world.func_180495_p(new BlockPos(x, y, z)).func_200132_m()) continue;
            return y;
        }
        return 0;
    }

    public static int getGroudHeightFrom(IWorld world, int x, int z, int yStart) {
        for (int y = yStart; y > 0; --y) {
            if (!world.func_180495_p(new BlockPos(x, y, z)).func_200132_m()) continue;
            return y;
        }
        return 0;
    }

    public static abstract class DungeonPiece
    extends StructurePiece {
        public Rotation field_186169_c;
        public int connectedSides;
        public int posX;
        public int posZ;
        public int theme;
        public int subTheme;
        public int x;
        public int y;
        public int z;
        public int stage;
        public boolean[] sides = new boolean[6];

        public DungeonPiece(IStructurePieceType p_i51343_1_, CompoundNBT p_i51343_2_) {
            super(p_i51343_1_, p_i51343_2_);
            this.sides[0] = p_i51343_2_.func_74767_n("north");
            this.sides[1] = p_i51343_2_.func_74767_n("east");
            this.sides[2] = p_i51343_2_.func_74767_n("south");
            this.sides[3] = p_i51343_2_.func_74767_n("west");
            this.sides[4] = p_i51343_2_.func_74767_n("up");
            this.sides[5] = p_i51343_2_.func_74767_n("down");
            this.connectedSides = p_i51343_2_.func_74762_e("connectedSides");
            this.posX = p_i51343_2_.func_74762_e("posX");
            this.posZ = p_i51343_2_.func_74762_e("posZ");
            this.x = p_i51343_2_.func_74762_e("x");
            this.y = p_i51343_2_.func_74762_e("y");
            this.z = p_i51343_2_.func_74762_e("z");
            this.theme = p_i51343_2_.func_74762_e("theme");
            this.subTheme = p_i51343_2_.func_74762_e("subTheme");
            this.stage = p_i51343_2_.func_74762_e("stage");
            this.field_186169_c = RotationHelper.getRotationFromInt(p_i51343_2_.func_74762_e("rotation"));
            this.field_74887_e = new MutableBoundingBox(this.x, this.y, this.z, this.x + 7, this.y + 7, this.z + 7);
        }

        public abstract int getType();

        public void openSide(Direction side) {
            switch (side) {
                case NORTH: {
                    if (this.sides[0]) {
                        return;
                    }
                    this.sides[0] = true;
                    ++this.connectedSides;
                    return;
                }
                case EAST: {
                    if (this.sides[1]) {
                        return;
                    }
                    this.sides[1] = true;
                    ++this.connectedSides;
                    return;
                }
                case SOUTH: {
                    if (this.sides[2]) {
                        return;
                    }
                    this.sides[2] = true;
                    ++this.connectedSides;
                    return;
                }
                case WEST: {
                    if (this.sides[3]) {
                        return;
                    }
                    this.sides[3] = true;
                    ++this.connectedSides;
                    return;
                }
                case UP: {
                    if (this.sides[4]) {
                        return;
                    }
                    this.sides[4] = true;
                    ++this.connectedSides;
                    return;
                }
                case DOWN: {
                    if (this.sides[5]) {
                        return;
                    }
                    this.sides[5] = true;
                    ++this.connectedSides;
                    return;
                }
            }
            DungeonCrawl.LOGGER.warn("Failed to open a segment side: Unknown side " + side);
        }

        public void setRotation(Rotation rotation) {
            this.field_186169_c = rotation;
        }

        public Rotation func_214809_Y_() {
            return this.field_186169_c;
        }

        public void setPosition(int x, int z) {
            this.posX = x;
            this.posZ = z;
        }

        public void setRealPosition(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.field_74887_e = new MutableBoundingBox(x, y, z, x + 7, y + 7, z + 7);
        }

        public void func_143011_b(CompoundNBT tagCompound) {
            tagCompound.func_74757_a("north", this.sides[0]);
            tagCompound.func_74757_a("east", this.sides[1]);
            tagCompound.func_74757_a("south", this.sides[2]);
            tagCompound.func_74757_a("west", this.sides[3]);
            tagCompound.func_74757_a("up", this.sides[4]);
            tagCompound.func_74757_a("down", this.sides[5]);
            tagCompound.func_74768_a("connectedSides", this.connectedSides);
            tagCompound.func_74768_a("posX", this.posX);
            tagCompound.func_74768_a("posZ", this.posZ);
            tagCompound.func_74768_a("x", this.x);
            tagCompound.func_74768_a("y", this.y);
            tagCompound.func_74768_a("z", this.z);
            tagCompound.func_74768_a("stage", this.stage);
            tagCompound.func_74768_a("theme", this.theme);
            tagCompound.func_74768_a("subTheme", this.subTheme);
            tagCompound.func_74768_a("rotation", RotationHelper.getIntFromRotation(this.field_186169_c));
        }

        public void setBlockState(BlockState state, IWorld world, Treasure.Type treasureType, int x, int y, int z, int theme, int lootLevel, boolean fillAir) {
            BlockPos pos = new BlockPos(x, y, z);
            if (state == null) {
                return;
            }
            if (!fillAir && world.func_175623_d(pos)) {
                return;
            }
            IBlockPlacementHandler.getHandler(state.func_177230_c()).setupBlock(world, state, pos, world.func_201674_k(), treasureType, theme, lootLevel);
            if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.func_177230_c())) {
                world.func_217349_x(pos).func_201594_d(pos);
            }
        }

        public void build(DungeonSegmentModel model, IWorld world, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Treasure.Type treasureType, int lootLevel, boolean fillAir) {
            for (int x = 0; x < model.width; ++x) {
                for (int y = 0; y < model.height; ++y) {
                    for (int z = 0; z < model.length; ++z) {
                        BlockState state = model.model[x][y][z] == null ? field_202556_l : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, subTheme, WeightedRandomBlock.RANDOM, lootLevel);
                        if (state == null) continue;
                        this.setBlockState(state, world, treasureType, pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z, this.theme, lootLevel, model.model[x][y][z] != null ? DungeonSegmentModelBlockType.isSolid(model.model[x][y][z].type) : false);
                    }
                }
            }
        }

        public void buildRotated(DungeonSegmentModel model, IWorld world, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Treasure.Type treasureType, int lootLevel, Rotation rotation, boolean fillAir) {
            switch (rotation) {
                case CLOCKWISE_90: {
                    for (int x = 0; x < model.width; ++x) {
                        for (int y = 0; y < model.height; ++y) {
                            for (int z = 0; z < model.length; ++z) {
                                BlockState state = model.model[x][y][z] == null ? field_202556_l : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, subTheme, WeightedRandomBlock.RANDOM, lootLevel, Rotation.CLOCKWISE_90);
                                if (state == null) continue;
                                this.setBlockState(state, world, treasureType, pos.func_177958_n() + model.length - z - 1, pos.func_177956_o() + y, pos.func_177952_p() + x, this.theme, lootLevel, model.model[x][y][z] != null ? DungeonSegmentModelBlockType.isSolid(model.model[x][y][z].type) : false);
                            }
                        }
                    }
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    for (int x = 0; x < model.width; ++x) {
                        for (int y = 0; y < model.height; ++y) {
                            for (int z = 0; z < model.length; ++z) {
                                BlockState state = model.model[x][y][z] == null ? field_202556_l : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, subTheme, WeightedRandomBlock.RANDOM, lootLevel, Rotation.COUNTERCLOCKWISE_90);
                                if (state == null) continue;
                                this.setBlockState(state, world, treasureType, pos.func_177958_n() + z, pos.func_177956_o() + y, pos.func_177952_p() + model.width - x - 1, this.theme, lootLevel, model.model[x][y][z] != null ? DungeonSegmentModelBlockType.isSolid(model.model[x][y][z].type) : false);
                            }
                        }
                    }
                    break;
                }
                case CLOCKWISE_180: {
                    for (int x = 0; x < model.width; ++x) {
                        for (int y = 0; y < model.height; ++y) {
                            for (int z = 0; z < model.length; ++z) {
                                BlockState state = model.model[x][y][z] == null ? field_202556_l : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, subTheme, WeightedRandomBlock.RANDOM, lootLevel, Rotation.CLOCKWISE_180);
                                if (state == null) continue;
                                this.setBlockState(state, world, treasureType, pos.func_177958_n() + model.width - x - 1, pos.func_177956_o() + y, pos.func_177952_p() + model.length - z - 1, this.theme, lootLevel, model.model[x][y][z] != null ? DungeonSegmentModelBlockType.isSolid(model.model[x][y][z].type) : false);
                            }
                        }
                    }
                    break;
                }
                case NONE: {
                    this.build(model, world, pos, theme, subTheme, treasureType, lootLevel, fillAir);
                    break;
                }
                default: {
                    DungeonCrawl.LOGGER.warn("Failed to build a rotated dungeon segment: Unsupported rotation " + rotation);
                }
            }
        }

        public void buildRotatedPart(DungeonSegmentModel model, IWorld world, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Treasure.Type treasureType, int lootLevel, Rotation rotation, int xStart, int yStart, int zStart, int width, int height, int length, boolean fillAir) {
            switch (rotation) {
                case CLOCKWISE_90: {
                    for (int x = 0; x < width; ++x) {
                        for (int y = 0; y < height; ++y) {
                            for (int z = 0; z < length; ++z) {
                                BlockState state = model.model[x + xStart][y + yStart][z + zStart] == null ? field_202556_l : DungeonSegmentModelBlock.getBlockState(model.model[x + xStart][y + yStart][z + zStart], theme, subTheme, world.func_201674_k(), lootLevel, Rotation.CLOCKWISE_90);
                                if (state == null) continue;
                                this.setBlockState(state, world, treasureType, pos.func_177958_n() + length - z - 1, pos.func_177956_o() + y, pos.func_177952_p() + x, this.theme, lootLevel, model.model[x][y][z] != null ? DungeonSegmentModelBlockType.isSolid(model.model[x][y][z].type) : false);
                            }
                        }
                    }
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    for (int x = 0; x < width; ++x) {
                        for (int y = 0; y < height; ++y) {
                            for (int z = 0; z < length; ++z) {
                                BlockState state = model.model[x + xStart][y + yStart][z + zStart] == null ? field_202556_l : DungeonSegmentModelBlock.getBlockState(model.model[x + xStart][y + yStart][z + zStart], theme, subTheme, world.func_201674_k(), lootLevel, Rotation.COUNTERCLOCKWISE_90);
                                if (state == null) continue;
                                this.setBlockState(state, world, treasureType, pos.func_177958_n() + z, pos.func_177956_o() + y, pos.func_177952_p() + width - x - 1, this.theme, lootLevel, model.model[x][y][z] != null ? DungeonSegmentModelBlockType.isSolid(model.model[x][y][z].type) : false);
                            }
                        }
                    }
                    break;
                }
                case CLOCKWISE_180: {
                    for (int x = 0; x < width; ++x) {
                        for (int y = 0; y < height; ++y) {
                            for (int z = 0; z < length; ++z) {
                                BlockState state = model.model[x + xStart][y + yStart][z + zStart] == null ? field_202556_l : DungeonSegmentModelBlock.getBlockState(model.model[x + xStart][y + yStart][z + zStart], theme, subTheme, world.func_201674_k(), lootLevel, Rotation.CLOCKWISE_180);
                                if (state == null) continue;
                                this.setBlockState(state, world, treasureType, pos.func_177958_n() + width - x - 1, pos.func_177956_o() + y, pos.func_177952_p() + length - z - 1, this.theme, lootLevel, model.model[x][y][z] != null ? DungeonSegmentModelBlockType.isSolid(model.model[x][y][z].type) : false);
                            }
                        }
                    }
                    break;
                }
                case NONE: {
                    DungeonCrawl.LOGGER.error("Called buildRotatedPart for model {} without a rotation.", (Object)model.id);
                    break;
                }
                default: {
                    DungeonCrawl.LOGGER.warn("Failed to build a rotated dungeon segment part: Unsupported rotation " + rotation);
                }
            }
        }

        public static Direction getOneWayDirection(DungeonPiece piece) {
            if (piece.sides[0]) {
                return Direction.NORTH;
            }
            if (piece.sides[1]) {
                return Direction.EAST;
            }
            if (piece.sides[2]) {
                return Direction.SOUTH;
            }
            if (piece.sides[3]) {
                return Direction.WEST;
            }
            return Direction.NORTH;
        }

        public int getAirBlocks(IWorld worldIn, int x, int y, int z, int width, int length) {
            int airBlocks = 0;
            for (int i = x; i < x + width; ++i) {
                for (int j = z; j < z + length; ++j) {
                    Block block = worldIn.func_180495_p(new BlockPos(i, y, j)).func_177230_c();
                    if (block != Blocks.field_150350_a && block != Blocks.field_201941_jj) continue;
                    ++airBlocks;
                }
            }
            return airBlocks;
        }

        public int getBlocks(IWorld worldIn, Block type, int x, int y, int z, int width, int length) {
            int blocks = 0;
            for (int i = x; i < x + width; ++i) {
                for (int j = z; j < z + length; ++j) {
                    Block block = worldIn.func_180495_p(new BlockPos(i, y, j)).func_177230_c();
                    if (block != type) continue;
                    ++blocks;
                }
            }
            return blocks;
        }

        public void openAdditionalSides(@Nullable DungeonPiece piece) {
            if (piece != null) {
                for (int i = 0; i < piece.sides.length; ++i) {
                    if (this.sides[i] || !piece.sides[i]) continue;
                    this.sides[i] = true;
                }
            }
        }

        public static void spawnMobs(IWorld world, DungeonPiece piece, int width, int length, int[] floors) {
            for (int floor : floors) {
                for (int x = 1; x < width; ++x) {
                    for (int z = 1; z < length; ++z) {
                        EntityType<?> mob;
                        Entity entity;
                        BlockPos pos = new BlockPos(piece.x + x, piece.y + floor + 1, piece.z + z);
                        if (!piece.field_74887_e.func_175898_b((Vec3i)pos) || !world.func_180495_p(pos).isAir((IBlockReader)world, pos) || !(world.func_201674_k().nextDouble() < (Double)Config.MOB_SPAWN_RATE.get()) || !((entity = (mob = Spawner.getRandomEntityType(world.func_201674_k())).func_200721_a(world.func_201672_e())) instanceof MonsterEntity)) continue;
                        MonsterEntity mobEntity = (MonsterEntity)entity;
                        mobEntity.func_70691_i(mobEntity.func_110138_aP());
                        mobEntity.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
                        Spawner.equipMonster(mobEntity, world.func_201674_k(), piece.stage);
                        mobEntity.func_213386_a(world, world.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                        world.func_217376_c((Entity)mobEntity);
                    }
                }
            }
        }

        public static Direction getOpenSide(DungeonPiece piece, int n) {
            int c = 0;
            for (int i = 0; i < 4; ++i) {
                if (!piece.sides[i] || c++ != n) continue;
                return DungeonPiece.getDirectionFromInt(i);
            }
            DungeonCrawl.LOGGER.error("getOpenSide(" + (Object)((Object)piece) + ", " + n + ") malfunctioned. This error did most likely occur due to an error in the mod and might result in wrongly formed dungeons. (" + piece.connectedSides + " open sides)");
            return Direction.NORTH;
        }

        public static Direction getDirectionFromInt(int dir) {
            switch (dir) {
                case 0: {
                    return Direction.NORTH;
                }
                case 1: {
                    return Direction.EAST;
                }
                case 2: {
                    return Direction.SOUTH;
                }
                case 3: {
                    return Direction.WEST;
                }
            }
            return Direction.NORTH;
        }
    }

    public static class StairsBot
    extends DungeonPiece {
        public StairsBot(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.STAIRSBOT, p_i51343_2_);
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            DungeonSegmentModel model = DungeonBuilder.getModel(this, randomIn);
            if (model == null) {
                return false;
            }
            this.build(model, worldIn, new BlockPos(this.x, this.y, this.z), Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, false);
            this.addWalls(this, worldIn, Theme.get(this.theme));
            return true;
        }

        @Override
        public int getType() {
            return 1;
        }

        public void addWalls(DungeonPiece piece, IWorld world, Theme theme) {
            int z;
            int y;
            int x;
            if (!piece.sides[0]) {
                for (x = 2; x < 6; ++x) {
                    for (y = 2; y < 6; ++y) {
                        piece.setBlockState(theme.solid.get(), world, null, piece.x + x, piece.y + y, piece.z, this.theme, 0, true);
                    }
                }
            } else {
                for (x = 2; x < 6; ++x) {
                    for (y = 2; y < 6; ++y) {
                        if (world.func_180495_p(new BlockPos(piece.x + x, piece.y + y, piece.z)).func_200132_m()) continue;
                        piece.setBlockState(Blocks.field_150411_aY.func_176223_P(), world, null, piece.x + x, piece.y + y, piece.z, this.theme, 0, true);
                    }
                }
            }
            if (!piece.sides[1]) {
                for (z = 2; z < 6; ++z) {
                    for (y = 2; y < 6; ++y) {
                        piece.setBlockState(theme.solid.get(), world, null, piece.x + 7, piece.y + y, piece.z + z, this.theme, 0, true);
                    }
                }
            } else {
                for (z = 2; z < 6; ++z) {
                    for (y = 2; y < 6; ++y) {
                        if (world.func_180495_p(new BlockPos(piece.x + 7, piece.y + y, piece.z + z)).func_200132_m()) continue;
                        piece.setBlockState(Blocks.field_150411_aY.func_176223_P(), world, null, piece.x + 7, piece.y + y, piece.z + z, this.theme, 0, true);
                    }
                }
            }
            if (!piece.sides[2]) {
                for (x = 2; x < 6; ++x) {
                    for (y = 2; y < 6; ++y) {
                        piece.setBlockState(theme.solid.get(), world, null, piece.x + x, piece.y + y, piece.z + 7, this.theme, 0, true);
                    }
                }
            } else {
                for (x = 2; x < 6; ++x) {
                    for (y = 2; y < 6; ++y) {
                        if (world.func_180495_p(new BlockPos(piece.x + x, piece.y + y, piece.z + 7)).func_200132_m()) continue;
                        piece.setBlockState(Blocks.field_150411_aY.func_176223_P(), world, null, piece.x + x, piece.y + y, piece.z + 7, this.theme, 0, true);
                    }
                }
            }
            if (!piece.sides[3]) {
                for (z = 2; z < 6; ++z) {
                    for (y = 2; y < 6; ++y) {
                        piece.setBlockState(theme.solid.get(), world, null, piece.x, piece.y + y, piece.z + z, this.theme, 0, true);
                    }
                }
            } else {
                for (z = 2; z < 6; ++z) {
                    for (y = 2; y < 6; ++y) {
                        if (world.func_180495_p(new BlockPos(piece.x, piece.y + y, piece.z + z)).func_200132_m()) continue;
                        piece.setBlockState(Blocks.field_150411_aY.func_176223_P(), world, null, piece.x, piece.y + y, piece.z + z, this.theme, 0, true);
                    }
                }
            }
        }
    }

    public static class Stairs
    extends DungeonPiece {
        public Stairs(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.STAIRS, p_i51343_2_);
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            int y1;
            DungeonSegmentModel model = DungeonBuilder.getModel(this, randomIn);
            if (model == null) {
                return false;
            }
            Theme buildTheme = Theme.get(this.theme);
            this.build(model, worldIn, new BlockPos(this.x, this.y, this.z), buildTheme, Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, true);
            for (int x1 = 0; x1 < 8; ++x1) {
                for (y1 = 0; y1 < 8; ++y1) {
                    this.setBlockState(buildTheme.solid.get(), worldIn, null, this.x + x1, this.y + y1, this.z + 7, this.theme, 0, true);
                }
            }
            for (int z1 = 0; z1 < 8; ++z1) {
                for (y1 = 0; y1 < 8; ++y1) {
                    this.setBlockState(buildTheme.solid.get(), worldIn, null, this.x + 7, this.y + y1, this.z + z1, this.theme, 0, true);
                }
            }
            return true;
        }

        @Override
        public int getType() {
            return 2;
        }
    }

    public static class StairsTop
    extends DungeonPiece {
        public StairsTop(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.STAIRSTOP, p_i51343_2_);
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            DungeonSegmentModel model = DungeonBuilder.getModel(this, randomIn);
            if (model == null) {
                return false;
            }
            this.build(model, worldIn, new BlockPos(this.x, this.y, this.z), Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, true);
            DungeonPieces.addWalls(this, worldIn, this.theme);
            return true;
        }

        @Override
        public int getType() {
            return 3;
        }
    }

    public static class EntranceBuilder
    extends DungeonPiece {
        public EntranceBuilder(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.ENTRANCE_BUILDER, p_i51343_2_);
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            int ch;
            int height = this.theme == 3 ? worldIn.func_181545_F() : DungeonPieces.getGroudHeight(worldIn, this.x + 4, this.z + 4);
            Theme buildTheme = Theme.get(this.theme);
            Theme.SubTheme sub = Theme.getSub(this.subTheme);
            for (ch = this.y; ch < height; ch += 8) {
                this.build(DungeonSegmentModelRegistry.STAIRS, worldIn, new BlockPos(this.x, ch, this.z), buildTheme, sub, Treasure.Type.DEFAULT, this.stage, true);
            }
            Random rand = worldIn.func_201674_k();
            if (rand == null) {
                DungeonCrawl.LOGGER.warn("Failed to receive a random object from worldIn: {}, {}", (Object)worldIn, worldIn.getClass());
                rand = new Random();
            }
            DungeonSegmentModel entrance = DungeonBuilder.ENTRANCE.roll(rand);
            Tuple<Integer, Integer> offset = DungeonBuilder.ENTRANCE_OFFSET_DATA.get(entrance.id);
            DungeonCrawl.LOGGER.info("Entrance data: Position: ({}|{}|{}), Model: {}, Entrance id: {}, Offset: {}; ({}|{})", (Object)this.x, (Object)ch, (Object)this.z, (Object)entrance, (Object)entrance.id, offset, offset.func_76341_a(), offset.func_76340_b());
            this.build(entrance, worldIn, new BlockPos(this.x + (Integer)offset.func_76341_a(), ch, this.z + (Integer)offset.func_76340_b()), buildTheme, sub, Treasure.Type.SUPPLY, this.stage, true);
            DungeonBuilder.ENTRANCE_PROCESSORS.getOrDefault(entrance.id, DungeonBuilder.DEFAULT_PROCESSOR).process(worldIn, new BlockPos(this.x + (Integer)offset.func_76341_a(), ch, this.z + (Integer)offset.func_76340_b()), this.theme, this);
            return true;
        }

        @Override
        public int getType() {
            return 11;
        }
    }

    public static class Hole
    extends DungeonPiece {
        boolean lava;

        public Hole(TemplateManager p_i51343_1_, CompoundNBT p_i51343_2_) {
            super(Dungeon.HOLE, p_i51343_2_);
            this.lava = p_i51343_2_.func_74767_n("lava");
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            this.build(this.lava ? DungeonSegmentModelRegistry.HOLE_LAVA : DungeonSegmentModelRegistry.HOLE, worldIn, new BlockPos(this.x, this.y - 15, this.z), Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, true);
            DungeonPieces.addWalls(this, worldIn, this.theme);
            if (this.theme == 3 && this.getBlocks(worldIn, Blocks.field_150355_j, this.x, this.y - 16, this.z, 8, 8) > 5) {
                DungeonPieces.addColumns(this, worldIn, 16, this.theme);
            }
            return false;
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("lava", this.lava);
        }
    }

    public static class CorridorTrap
    extends DungeonPiece {
        public CorridorTrap(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.CORRIDOR_TRAP, p_i51343_2_);
        }

        @Override
        public int getType() {
            return 6;
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            this.buildRotated(DungeonSegmentModelRegistry.CORRIDOR_TRAP, worldIn, new BlockPos(this.x, this.y, this.z), Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, this.func_214809_Y_(), true);
            return true;
        }
    }

    public static class CorridorRoom
    extends DungeonPiece {
        public CorridorRoom(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.CORRIDOR_ROOM, p_i51343_2_);
        }

        @Override
        public int getType() {
            return 7;
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            this.buildRotated(DungeonSegmentModelRegistry.CORRIDOR_ROOM, worldIn, new BlockPos(this.x, this.y - 6, this.z), Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, this.func_214809_Y_(), true);
            if (this.theme == 3 && this.getBlocks(worldIn, Blocks.field_150355_j, this.x, this.y - 7, this.z, 8, 8) > 5) {
                DungeonPieces.addColumns(this, worldIn, 7, this.theme);
            }
            return true;
        }
    }

    public static class Corridor
    extends DungeonPiece {
        public int specialType;

        public Corridor(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.CORRIDOR, p_i51343_2_);
            this.specialType = p_i51343_2_.func_74762_e("specialType");
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            if (this.theme != 3 && this.getAirBlocks(worldIn, this.x, this.y, this.z, 8, 8) > 8) {
                boolean ew = this.field_186169_c == Rotation.NONE || this.field_186169_c == Rotation.CLOCKWISE_180;
                switch (this.connectedSides) {
                    case 2: {
                        if (this.sides[0] && this.sides[2] || this.sides[1] && this.sides[3]) {
                            this.buildRotated(DungeonSegmentModelRegistry.BRIDGE, worldIn, new BlockPos(ew ? this.x : this.x + 1, this.y - 1, ew ? this.z + 1 : this.z), Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, this.field_186169_c, true);
                        } else {
                            this.buildRotated(DungeonSegmentModelRegistry.BRIDGE_TURN, worldIn, new BlockPos(this.x + (this.sides[1] ? 1 : 0), this.y - 1, this.z + (this.sides[2] ? 1 : 0)), Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, this.field_186169_c, true);
                        }
                        return true;
                    }
                    case 3: {
                        this.buildRotated(DungeonSegmentModelRegistry.BRIDGE_SIDE, worldIn, new BlockPos(this.sides[1] ? (this.sides[3] ? this.x : this.x + 1) : this.x, this.y - 1, this.sides[2] ? (this.sides[0] ? this.z : this.z + 1) : this.z), Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, this.field_186169_c, true);
                        return true;
                    }
                    case 4: {
                        this.buildRotated(DungeonSegmentModelRegistry.BRIDGE_ALL_SIDES, worldIn, new BlockPos(this.x, this.y - 1, this.z), Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, this.field_186169_c, true);
                        return true;
                    }
                }
                return true;
            }
            DungeonSegmentModel model = DungeonBuilder.getModel(this, randomIn);
            if (model == null) {
                return false;
            }
            this.buildRotated(model, worldIn, new BlockPos(this.x, this.y, this.z), Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, this.func_214809_Y_(), true);
            if (((Boolean)Config.NO_SPAWNERS.get()).booleanValue()) {
                Corridor.spawnMobs(worldIn, this, model.width, model.length, new int[]{1});
            }
            if (!(this.theme != 3 || (this.connectedSides != 2 || (this.sides[0] && this.sides[2] || this.sides[1] && this.sides[3]) && !(randomIn.nextDouble() < 0.2)) && this.connectedSides <= 2 || this.getBlocks(worldIn, Blocks.field_150355_j, this.x, this.y - 1, this.z, 8, 8) <= 5)) {
                DungeonPieces.addColumns(this, worldIn, 1, this.theme);
            }
            return true;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("specialType", this.specialType);
        }
    }

    public static class Room
    extends DungeonPiece {
        public Room(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.ROOM, p_i51343_2_);
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            DungeonSegmentModel model = DungeonBuilder.getModel(this, randomIn);
            if (model == null) {
                return false;
            }
            this.build(model, worldIn, new BlockPos(this.x, this.y, this.z), Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, true);
            DungeonPieces.addWalls(this, worldIn, this.theme);
            if (((Boolean)Config.NO_SPAWNERS.get()).booleanValue()) {
                Room.spawnMobs(worldIn, this, model.width, model.length, new int[]{1});
            }
            if (this.theme == 3 && this.getBlocks(worldIn, Blocks.field_150355_j, this.x, this.y - 1, this.z, 8, 8) > 5) {
                DungeonPieces.addColumns(this, worldIn, 1, this.theme);
            }
            return false;
        }

        @Override
        public int getType() {
            return 5;
        }
    }

    public static class HoleTrap
    extends DungeonPiece {
        public HoleTrap(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.HOLE_TRAP, p_i51343_2_);
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            this.buildRotated(null, worldIn, new BlockPos(this.x, this.y, this.z), Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, this.field_186169_c, true);
            return true;
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    public static class SideRoom
    extends DungeonPiece {
        public Treasure.Type treasureType;
        public int modelID;
        public int offsetX;
        public int offsetY;
        public int offsetZ;

        public SideRoom(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.SIDE_ROOM, p_i51343_2_);
            this.modelID = p_i51343_2_.func_74762_e("modelID");
            this.offsetX = p_i51343_2_.func_74762_e("offsetX");
            this.offsetY = p_i51343_2_.func_74762_e("offsetY");
            this.offsetZ = p_i51343_2_.func_74762_e("offsetZ");
            this.treasureType = Treasure.Type.fromInt(p_i51343_2_.func_74762_e("treasureType"));
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            DungeonSegmentModel model = DungeonSegmentModelRegistry.MAP.get(this.modelID);
            if (model != null) {
                this.buildRotated(model, worldIn, new BlockPos(this.x + this.offsetX, this.y + this.offsetY, this.z + this.offsetZ), Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, this.field_186169_c, true);
                if (((Boolean)Config.NO_SPAWNERS.get()).booleanValue()) {
                    SideRoom.spawnMobs(worldIn, this, model.width, model.length, new int[]{1});
                }
                return true;
            }
            DungeonCrawl.LOGGER.error("Side Room Model doesnt exist: {}", (Object)this.modelID);
            return false;
        }

        public void setOffset(int x, int y, int z) {
            this.offsetX = x;
            this.offsetY = y;
            this.offsetZ = z;
        }

        public void setOffset(Triple<Integer, Integer, Integer> offset) {
            this.offsetX = (Integer)offset.l;
            this.offsetY = (Integer)offset.m;
            this.offsetZ = (Integer)offset.r;
        }

        @Override
        public int getType() {
            return 13;
        }

        @Override
        public void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("modelID", this.modelID);
            tagCompound.func_74768_a("offsetX", this.offsetX);
            tagCompound.func_74768_a("offsetY", this.offsetY);
            tagCompound.func_74768_a("offsetZ", this.offsetZ);
            tagCompound.func_74768_a("treasureType", Treasure.Type.toInt(this.treasureType));
        }
    }

    public static class PartWithEntity
    extends DungeonPiece {
        public boolean walls;
        private int modelID;
        private int startX;
        private int startY;
        private int startZ;
        private int width;
        private int height;
        private int length;
        private int entityX;
        private int entityY;
        private int entityZ;
        public int treasureType;
        public ResourceLocation entityName;
        public CompoundNBT nbt;

        public PartWithEntity(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.PART_WITH_ENTITY, p_i51343_2_);
            this.entityName = new ResourceLocation(p_i51343_2_.func_74779_i("entityName"));
            this.modelID = p_i51343_2_.func_74762_e("model");
            this.startX = p_i51343_2_.func_74762_e("startX");
            this.startY = p_i51343_2_.func_74762_e("startY");
            this.startZ = p_i51343_2_.func_74762_e("startZ");
            this.width = p_i51343_2_.func_74762_e("width");
            this.height = p_i51343_2_.func_74762_e("height");
            this.length = p_i51343_2_.func_74762_e("length");
            this.treasureType = p_i51343_2_.func_74762_e("treasureType");
            this.entityX = p_i51343_2_.func_74762_e("entityX");
            this.entityY = p_i51343_2_.func_74762_e("entityY");
            this.entityZ = p_i51343_2_.func_74762_e("entityZ");
            this.walls = p_i51343_2_.func_74767_n("walls");
            this.nbt = p_i51343_2_.func_74775_l("entityNBT");
        }

        public void set(int modelID, int startX, int startY, int startZ, int width, int height, int length, int entityX, int entityY, int entityZ) {
            this.modelID = modelID;
            this.startX = startX;
            this.startY = startY;
            this.startZ = startZ;
            this.width = width;
            this.height = height;
            this.length = length;
            this.entityX = entityX;
            this.entityY = entityY;
            this.entityZ = entityZ;
        }

        public void adjustSize() {
            DungeonSegmentModel model = DungeonSegmentModelRegistry.MAP.get(this.modelID);
            if (model == null) {
                DungeonCrawl.LOGGER.warn("Failed to adjust the size of a dungeon part. ID: {}", (Object)this.modelID);
                return;
            }
            this.width = this.startX + this.width > model.width ? this.width - (this.startX + this.width - model.width) : this.width;
            this.height = this.startY + this.height > model.height ? this.height - (this.startY + this.height - model.height) : this.height;
            this.length = this.startZ + this.length > model.length ? this.length - (this.startZ + this.length - model.length) : this.length;
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            EntityType entityType;
            this.adjustSize();
            DungeonSegmentModel model = DungeonSegmentModelRegistry.MAP.get(this.modelID);
            BlockPos pos = new BlockPos(this.x, this.y, this.z);
            Treasure.Type type = Treasure.Type.fromInt(this.treasureType);
            Theme buildTheme = Theme.get(this.theme);
            Theme.SubTheme sub = Theme.getSub(this.subTheme);
            if (this.field_186169_c == Rotation.NONE) {
                for (int x = this.startX; x < this.startX + this.width; ++x) {
                    for (int y = this.startY; y < this.startY + this.height; ++y) {
                        for (int z = this.startZ; z < this.startZ + this.length; ++z) {
                            BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], buildTheme, sub, worldIn.func_201674_k(), this.stage);
                            if (state == null) continue;
                            this.setBlockState(state, worldIn, type, pos.func_177958_n() + x - this.startX, pos.func_177956_o() + y - this.startY, pos.func_177952_p() + z - this.startZ, this.theme, this.stage, true);
                        }
                    }
                }
            } else {
                this.buildRotatedPart(model, worldIn, pos, buildTheme, sub, Treasure.Type.fromInt(this.treasureType), this.stage, this.field_186169_c, this.startX, this.startY, this.startZ, this.width, this.height, this.length, true);
            }
            if (this.walls) {
                DungeonPieces.addWalls(this, worldIn, this.theme);
            }
            if (this.theme == 3 && this.getBlocks(worldIn, Blocks.field_150355_j, this.x, this.y - 1, this.z, 8, 8) > 5) {
                DungeonPieces.addColumns(this, worldIn, 1, this.theme);
            }
            if ((entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(this.entityName)) == null) {
                DungeonCrawl.LOGGER.warn("The entity type {} does not exist.", (Object)this.entityName.toString());
                return true;
            }
            Entity get = entityType.func_200721_a(worldIn.func_201672_e());
            if (get != null && get instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)get;
                entity.func_70691_i(entity.func_110138_aP());
                entity.func_70012_b((double)(this.x + this.entityX), (double)(this.y + this.entityY), (double)(this.z + this.entityZ), 0.0f, 0.0f);
                if (entity instanceof MobEntity) {
                    MobEntity mob = (MobEntity)entity;
                    mob.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((Entity)entity)), SpawnReason.STRUCTURE, (ILivingEntityData)null, (CompoundNBT)null);
                    if (this.nbt != null) {
                        CompoundNBT data = new CompoundNBT();
                        mob.func_213281_b(data);
                        mob.func_70037_a(data.func_197643_a(this.nbt));
                    }
                } else if (this.nbt != null) {
                    entity.func_70037_a(this.nbt);
                }
                worldIn.func_217376_c((Entity)entity);
            } else {
                DungeonCrawl.LOGGER.warn("Failed to spawn a living entity at {}.");
            }
            return true;
        }

        @Override
        public void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("model", this.modelID);
            tagCompound.func_74768_a("startX", this.startX);
            tagCompound.func_74768_a("startY", this.startY);
            tagCompound.func_74768_a("startZ", this.startZ);
            tagCompound.func_74768_a("width", this.width);
            tagCompound.func_74768_a("height", this.height);
            tagCompound.func_74768_a("length", this.length);
            tagCompound.func_74768_a("treasureType", this.treasureType);
            tagCompound.func_74768_a("entityX", this.entityX);
            tagCompound.func_74768_a("entityY", this.entityY);
            tagCompound.func_74768_a("entityZ", this.entityZ);
            tagCompound.func_74757_a("walls", this.walls);
            tagCompound.func_74778_a("entityName", this.entityName.toString());
            if (this.nbt != null) {
                tagCompound.func_218657_a("entityNBT", (INBT)this.nbt);
            }
        }

        @Override
        public int getType() {
            return 14;
        }
    }

    public static class Part
    extends DungeonPiece {
        public boolean walls;
        private int modelID;
        private int startX;
        private int startY;
        private int startZ;
        private int width;
        private int height;
        private int length;
        public int treasureType;

        public Part(TemplateManager manager, CompoundNBT p_i51343_2_) {
            super(Dungeon.PART, p_i51343_2_);
            this.modelID = p_i51343_2_.func_74762_e("model");
            this.startX = p_i51343_2_.func_74762_e("startX");
            this.startY = p_i51343_2_.func_74762_e("startY");
            this.startZ = p_i51343_2_.func_74762_e("startZ");
            this.width = p_i51343_2_.func_74762_e("width");
            this.height = p_i51343_2_.func_74762_e("height");
            this.length = p_i51343_2_.func_74762_e("length");
            this.treasureType = p_i51343_2_.func_74762_e("treasureType");
            this.walls = p_i51343_2_.func_74767_n("walls");
        }

        public void set(int modelID, int startX, int startY, int startZ, int width, int height, int length) {
            this.modelID = modelID;
            this.startX = startX;
            this.startY = startY;
            this.startZ = startZ;
            this.width = width;
            this.height = height;
            this.length = length;
            if (this.treasureType == 0) {
                this.treasureType = Treasure.Type.toInt(Treasure.LARGE_ROOM_TREASURE_TYPES.getOrDefault(modelID, Treasure.Type.DEFAULT));
            }
        }

        public void adjustSize() {
            DungeonSegmentModel model = DungeonSegmentModelRegistry.MAP.get(this.modelID);
            if (model == null) {
                DungeonCrawl.LOGGER.warn("Failed to adjust the size of a dungeon part. ID: {}", (Object)this.modelID);
                return;
            }
            this.width = this.startX + this.width > model.width ? this.width - (this.startX + this.width - model.width) : this.width;
            this.height = this.startY + this.height > model.height ? this.height - (this.startY + this.height - model.height) : this.height;
            this.length = this.startZ + this.length > model.length ? this.length - (this.startZ + this.length - model.length) : this.length;
        }

        @Override
        public int getType() {
            return 12;
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> p_225577_2_, Random randomIn, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            this.adjustSize();
            DungeonSegmentModel model = DungeonSegmentModelRegistry.MAP.get(this.modelID);
            BlockPos pos = new BlockPos(this.x, this.y, this.z);
            Treasure.Type type = Treasure.Type.fromInt(this.treasureType);
            Theme buildTheme = Theme.get(this.theme);
            Theme.SubTheme sub = Theme.getSub(this.subTheme);
            if (this.field_186169_c == Rotation.NONE) {
                for (int x = this.startX; x < this.startX + this.width; ++x) {
                    for (int y = this.startY; y < this.startY + this.height; ++y) {
                        for (int z = this.startZ; z < this.startZ + this.length; ++z) {
                            BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], buildTheme, sub, worldIn.func_201674_k(), this.stage);
                            if (state == null) continue;
                            this.setBlockState(state, worldIn, type, pos.func_177958_n() + x - this.startX, pos.func_177956_o() + y - this.startY, pos.func_177952_p() + z - this.startZ, this.theme, this.stage, true);
                        }
                    }
                }
            } else {
                this.buildRotatedPart(model, worldIn, pos, buildTheme, sub, Treasure.Type.fromInt(this.treasureType), this.stage, this.field_186169_c, this.startX, this.startY, this.startZ, this.width, this.height, this.length, true);
            }
            if (this.walls) {
                DungeonPieces.addWalls(this, worldIn, this.theme);
            }
            if (((Boolean)Config.NO_SPAWNERS.get()).booleanValue()) {
                Part.spawnMobs(worldIn, this, this.width, this.length, new int[]{1, 5});
            }
            if (this.theme == 3 && this.getBlocks(worldIn, Blocks.field_150355_j, this.x, this.y - 1, this.z, 8, 8) > 5) {
                DungeonPieces.addColumns(this, worldIn, 1, this.theme);
            }
            return true;
        }

        @Override
        public void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("model", this.modelID);
            tagCompound.func_74768_a("startX", this.startX);
            tagCompound.func_74768_a("startY", this.startY);
            tagCompound.func_74768_a("startZ", this.startZ);
            tagCompound.func_74768_a("width", this.width);
            tagCompound.func_74768_a("height", this.height);
            tagCompound.func_74768_a("length", this.length);
            tagCompound.func_74768_a("treasureType", this.treasureType);
            tagCompound.func_74757_a("walls", this.walls);
        }
    }
}

