/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.config;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.JsonConfig;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.util.IJsonConfigurable;

public class SpecialItemTags
implements IJsonConfigurable {
    public static final HashMap<String, TagProcessor> TAG_PROCESSORS;
    public static final String EFFECT_ENCHANT = "enchant";
    public static final String EFFECT_ENCHANTMENT_MULTIPLIER = "multiply_enchantment_level";
    public static final String EFFECT_RANDOM_ENCHANT = "enchant_randomly";
    public static final HashMap<String, Object> DEFAULTS;
    public static final String KEY_GENERIC = "generic";
    public static final String KEY_ARMOR = "armor";
    public static final String KEY_TOOL = "tool";
    public static final String KEY_SWORD = "sword";
    public static final String KEY_RANGED_WEAPON = "ranged_weapon";
    public static final String KEY_PREFIX = "generic_prefix";
    public static final String KEY_PREFIX_ARMOR = "armor_prefix";
    public static final String KEY_PREFIX_TOOL = "tool_prefix";
    public static final String KEY_PREFIX_SWORD = "sword_prefix";
    public static final String KEY_PREFIX_RANGED_WEAPON = "ranged_weapon_prefix";
    public static final String[] KEYS;
    public static SpecialItemTag[] GENERIC;
    public static SpecialItemTag[] ARMOR;
    public static SpecialItemTag[] TOOL;
    public static SpecialItemTag[] SWORD;
    public static SpecialItemTag[] RANGED_WEAPON;
    public static SpecialItemTag[] PREFIX_GENERIC;
    public static SpecialItemTag[] PREFIX_ARMOR;
    public static SpecialItemTag[] PREFIX_TOOL;
    public static SpecialItemTag[] PREFIX_SWORD;
    public static SpecialItemTag[] PREFIX_RANGED_WEAPON;

    public static ItemStack rollForTagsAndApply(Item item, int lootLevel, Random rand) {
        ItemStack stack = new ItemStack((IItemProvider)item);
        String name = stack.func_200301_q().getString();
        return SpecialItemTags.rollForTagsAndApply(item, lootLevel, rand, name);
    }

    public static ItemStack rollForTagsAndApply(Item item, int lootLevel, Random rand, String name) {
        ItemData data = new ItemData(RandomEquipment.getStageMultiplier(lootLevel));
        ItemStack stack = new ItemStack((IItemProvider)item);
        SpecialItemTag prefix = null;
        SpecialItemTag tag = null;
        if (item instanceof ArmorItem) {
            prefix = PREFIX_ARMOR.length > 3 || rand.nextDouble() > (double)PREFIX_ARMOR.length * 0.25 ? PREFIX_ARMOR[rand.nextInt(PREFIX_ARMOR.length)] : null;
            tag = ARMOR.length > 3 || rand.nextDouble() > (double)ARMOR.length * 0.25 ? ARMOR[rand.nextInt(ARMOR.length)] : null;
        } else if (item instanceof SwordItem) {
            prefix = PREFIX_SWORD.length > 0 ? PREFIX_SWORD[rand.nextInt(PREFIX_SWORD.length)] : null;
            tag = SWORD.length > 0 ? SWORD[rand.nextInt(SWORD.length)] : null;
        } else if (item instanceof ToolItem) {
            prefix = PREFIX_TOOL.length > 0 ? PREFIX_TOOL[rand.nextInt(PREFIX_TOOL.length)] : null;
            tag = TOOL.length > 0 ? TOOL[rand.nextInt(TOOL.length)] : null;
        } else if (item instanceof BowItem || item instanceof CrossbowItem) {
            prefix = PREFIX_RANGED_WEAPON.length > 0 ? PREFIX_RANGED_WEAPON[rand.nextInt(PREFIX_RANGED_WEAPON.length)] : null;
            tag = RANGED_WEAPON.length > 0 ? RANGED_WEAPON[rand.nextInt(RANGED_WEAPON.length)] : null;
        } else {
            prefix = PREFIX_GENERIC.length > 0 ? PREFIX_GENERIC[rand.nextInt(PREFIX_GENERIC.length)] : null;
            SpecialItemTag specialItemTag = tag = GENERIC.length > 0 ? GENERIC[rand.nextInt(GENERIC.length)] : null;
        }
        if (prefix != null) {
            SpecialItemTags.applyTag(prefix, stack, data, rand, lootLevel);
            name = prefix.name + " " + name;
        }
        if (tag != null) {
            SpecialItemTags.applyTag(tag, stack, data, rand, lootLevel);
            name = name + " of " + tag.name;
        }
        stack.func_200302_a((ITextComponent)new StringTextComponent(name));
        return stack;
    }

    public static void applyTag(SpecialItemTag tag, ItemStack stack, ItemData data, Random rand, int lootLevel) {
        TAG_PROCESSORS.get(tag.effect).apply(stack, tag, data, rand, lootLevel);
    }

    public static void buildList(SpecialItemTag[] list) {
        for (SpecialItemTag tag : list) {
            tag.build();
        }
    }

    public static boolean hasEnchantment(ItemStack stack, String enchantment) {
        for (INBT nbt : stack.func_77986_q()) {
            if (!((CompoundNBT)nbt).func_74779_i("id").equals(enchantment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public File getFile() {
        return FMLPaths.CONFIGDIR.get().resolve("DungeonCrawl/loot/specialItemTags.json").toFile();
    }

    @Override
    public void load(JsonObject object, File file) {
        GENERIC = (SpecialItemTag[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_GENERIC, this), SpecialItemTag[].class);
        ARMOR = (SpecialItemTag[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_ARMOR, this), SpecialItemTag[].class);
        TOOL = (SpecialItemTag[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_TOOL, this), SpecialItemTag[].class);
        SWORD = (SpecialItemTag[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_SWORD, this), SpecialItemTag[].class);
        RANGED_WEAPON = (SpecialItemTag[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_RANGED_WEAPON, this), SpecialItemTag[].class);
        PREFIX_GENERIC = (SpecialItemTag[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_PREFIX, this), SpecialItemTag[].class);
        PREFIX_ARMOR = (SpecialItemTag[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_PREFIX_ARMOR, this), SpecialItemTag[].class);
        PREFIX_TOOL = (SpecialItemTag[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_PREFIX_TOOL, this), SpecialItemTag[].class);
        PREFIX_SWORD = (SpecialItemTag[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_PREFIX_SWORD, this), SpecialItemTag[].class);
        PREFIX_RANGED_WEAPON = (SpecialItemTag[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_PREFIX_RANGED_WEAPON, this), SpecialItemTag[].class);
        SpecialItemTags.buildList(GENERIC);
        SpecialItemTags.buildList(ARMOR);
        SpecialItemTags.buildList(TOOL);
        SpecialItemTags.buildList(SWORD);
        SpecialItemTags.buildList(RANGED_WEAPON);
        SpecialItemTags.buildList(PREFIX_GENERIC);
        SpecialItemTags.buildList(PREFIX_ARMOR);
        SpecialItemTags.buildList(PREFIX_TOOL);
        SpecialItemTags.buildList(PREFIX_SWORD);
        SpecialItemTags.buildList(PREFIX_RANGED_WEAPON);
    }

    @Override
    public JsonObject create(JsonObject object) {
        for (String key : KEYS) {
            object.add(key, DungeonCrawl.GSON.toJsonTree(DEFAULTS.get(key)));
        }
        return object;
    }

    @Override
    public HashMap<String, Object> getDefaults() {
        return DEFAULTS;
    }

    @Override
    public String[] getKeys() {
        return KEYS;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public boolean deleteOldVersion() {
        return false;
    }

    static {
        KEYS = new String[]{KEY_GENERIC, KEY_ARMOR, KEY_TOOL, KEY_SWORD, KEY_RANGED_WEAPON, KEY_PREFIX, KEY_PREFIX_ARMOR, KEY_PREFIX_TOOL, KEY_PREFIX_SWORD, KEY_PREFIX_RANGED_WEAPON};
        TAG_PROCESSORS = new HashMap();
        TAG_PROCESSORS.put(EFFECT_ENCHANT, (item, tag, data, rand, stage) -> {
            for (ResourceLocation enchantment : tag.enchantmentResources) {
                Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantment);
                if (ench == null || !EnchantmentHelper.func_201840_a(EnchantmentHelper.func_82781_a((ItemStack)item).keySet(), (Enchantment)ench)) continue;
                if (tag.level != null) {
                    item.func_77966_a(ench, tag.level.intValue());
                    continue;
                }
                RandomEquipment.enchantItem(item, ench, data.enchantmentLevelMultiplier);
            }
        });
        TAG_PROCESSORS.put(EFFECT_ENCHANTMENT_MULTIPLIER, (item, tag, data, rand, stage) -> {
            data.enchantmentLevelMultiplier = tag.enchantmentMultiplier;
        });
        TAG_PROCESSORS.put(EFFECT_RANDOM_ENCHANT, (item, tag, data, rand, stage) -> {
            List enchantments = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)item, (int)(5 + 10 * stage), (stage > 0 ? 1 : 0) != 0);
            for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)item).entrySet()) {
                EnchantmentHelper.func_185282_a((List)enchantments, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
            }
            if (enchantments.size() < 1) {
                return;
            }
            EnchantmentData enchantment = (EnchantmentData)enchantments.get(rand.nextInt(enchantments.size()));
            double stageMultiplier = RandomEquipment.getStageMultiplier(stage);
            int level = (int)(data.enchantmentLevelMultiplier > stageMultiplier ? (double)enchantment.field_76302_b.func_77325_b() * data.enchantmentLevelMultiplier : (double)enchantment.field_76302_b.func_77325_b() * stageMultiplier);
            if (level < 1) {
                level = 1;
            }
            item.func_77966_a(enchantment.field_76302_b, level);
        });
        DEFAULTS = new HashMap();
        DEFAULTS.put(KEY_GENERIC, new SpecialItemTag[0]);
        DEFAULTS.put(KEY_ARMOR, new SpecialItemTag[]{new SpecialItemTag("Deflection", EFFECT_ENCHANT, 0, "minecraft:thorns"), new SpecialItemTag("Protection", EFFECT_ENCHANT, 0, "minecraft:protection"), new SpecialItemTag("the Apprentice", EFFECT_RANDOM_ENCHANT, 0), new SpecialItemTag("the Master Blacksmith", EFFECT_ENCHANT, 4, 3, "minecraft:protection", "minecraft:unbreaking")});
        DEFAULTS.put(KEY_TOOL, new SpecialItemTag[]{new SpecialItemTag("the Harvester", EFFECT_ENCHANT, 0, "minecraft:efficiency")});
        DEFAULTS.put(KEY_SWORD, new SpecialItemTag[]{new SpecialItemTag("the Cinder Lord", EFFECT_ENCHANT, 0, "minecraft:fire_aspect"), new SpecialItemTag("the Rogue Knight", EFFECT_ENCHANT, 0, "minecraft:sweeping"), new SpecialItemTag("the Monster Slayer", EFFECT_ENCHANT, 0, "minecraft:smite"), new SpecialItemTag("the Goblin Slayer", EFFECT_ENCHANT, 0, "minecraft:sharpness")});
        DEFAULTS.put(KEY_RANGED_WEAPON, new SpecialItemTag[0]);
        DEFAULTS.put(KEY_PREFIX, new SpecialItemTag[]{new SpecialItemTag("Arcane", EFFECT_RANDOM_ENCHANT, 0)});
        DEFAULTS.put(KEY_PREFIX_ARMOR, new SpecialItemTag[]{new SpecialItemTag("Tempered", EFFECT_ENCHANT, 0, "minecraft:protection"), new SpecialItemTag("Fire Proof", EFFECT_ENCHANT, 0, "minecraft:fire_protection"), new SpecialItemTag("Resistant", EFFECT_ENCHANT, 0, "minecraft:blast_protection"), new SpecialItemTag("Reinforced", EFFECT_ENCHANT, 0, "minecraft:projectile_protection"), new SpecialItemTag("Cursed", EFFECT_ENCHANT, 0, "minecraft:vanishing_curse"), new SpecialItemTag("Cursed", EFFECT_ENCHANT, 0, "minecraft:binding_curse"), new SpecialItemTag("Reforged", EFFECT_ENCHANTMENT_MULTIPLIER, 1, 0.5), new SpecialItemTag("Surplus", EFFECT_ENCHANTMENT_MULTIPLIER, 1, 0.75), new SpecialItemTag("Legendary", EFFECT_ENCHANTMENT_MULTIPLIER, 1, 1.0), new SpecialItemTag("Genuine", EFFECT_ENCHANTMENT_MULTIPLIER, 1, 1.0)});
        DEFAULTS.put(KEY_PREFIX_TOOL, new SpecialItemTag[]{new SpecialItemTag("Durable", EFFECT_ENCHANT, 0, "minecraft:unbreaking"), new SpecialItemTag("Hardened", EFFECT_ENCHANT, 0, "minecraft:unbreaking"), new SpecialItemTag("Blessed", EFFECT_ENCHANT, 0, "minecraft:efficiency"), new SpecialItemTag("Reforged", EFFECT_ENCHANTMENT_MULTIPLIER, 1, 0.5)});
        DEFAULTS.put(KEY_PREFIX_SWORD, new SpecialItemTag[]{new SpecialItemTag("Holy", EFFECT_ENCHANT, 0, "minecraft:smite"), new SpecialItemTag("Tempered", EFFECT_ENCHANT, 0, "minecraft:sharpness", "minecraft:unbreaking"), new SpecialItemTag("Reforged", EFFECT_ENCHANTMENT_MULTIPLIER, 1, 0.5)});
        DEFAULTS.put(KEY_PREFIX_RANGED_WEAPON, new SpecialItemTag[]{new SpecialItemTag("Refined", EFFECT_ENCHANT, 0, "minecraft:power", "minecraft:unbreaking"), new SpecialItemTag("Powerful", EFFECT_ENCHANT, 0, "minecraft:punch")});
    }

    @FunctionalInterface
    public static interface TagProcessor {
        public void apply(ItemStack var1, SpecialItemTag var2, ItemData var3, Random var4, int var5);
    }

    public static class SpecialItemTag {
        public String name;
        public String effect;
        public int rarity;
        public String[] enchantments;
        public ResourceLocation[] enchantmentResources;
        public Double enchantmentMultiplier;
        public Integer level;

        public SpecialItemTag(String name, String effect, int rarity) {
            this.name = name;
            this.effect = effect;
            this.rarity = rarity;
        }

        public SpecialItemTag(String name, String effect, int rarity, String ... enchantments) {
            this(name, effect, rarity);
            this.enchantments = enchantments;
        }

        public SpecialItemTag(String name, String effect, int rarity, int level, String ... enchantments) {
            this(name, effect, rarity);
            this.enchantments = enchantments;
            this.level = level;
        }

        public SpecialItemTag(String name, String effect, int rarity, double enchantmentMultiplier) {
            this(name, effect, rarity);
            this.enchantmentMultiplier = enchantmentMultiplier;
        }

        public SpecialItemTag build() {
            if (this.enchantments != null) {
                this.enchantmentResources = new ResourceLocation[this.enchantments.length];
                for (int i = 0; i < this.enchantments.length; ++i) {
                    this.enchantmentResources[i] = new ResourceLocation(this.enchantments[i]);
                }
            }
            return this;
        }
    }

    public static class ItemData {
        public double enchantmentLevelMultiplier;

        public ItemData() {
            this.enchantmentLevelMultiplier = 1.0;
        }

        public ItemData(double enchantmentLevelMultiplier) {
            this.enchantmentLevelMultiplier = enchantmentLevelMultiplier;
        }
    }
}

