/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.voxelshape.block_shape_cache;

import me.jellysquid.mods.lithium.common.block.ExtendedBlockShapeCache;
import me.jellysquid.mods.lithium.common.util.BitUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockState.Cache.class})
public class MixinBlockCache
implements ExtendedBlockShapeCache {
    private byte hasSolidSide;
    private byte hasEnoughSolidSide;
    private byte sideSolidFullSquare;
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final VoxelShape field_220083_b = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape field_220084_c = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(BlockState state, CallbackInfo ci) {
        VoxelShape shape = state.func_196952_d((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
        for (Direction dir : DIRECTIONS) {
            if (state.func_203425_a(BlockTags.field_206952_E)) continue;
            VoxelShape face = shape.func_212434_a(dir);
            this.hasSolidSide = (byte)(this.hasSolidSide | BitUtil.bit(dir.ordinal(), MixinBlockCache.calculateSideCoversSquare(face, field_220084_c)));
            this.hasEnoughSolidSide = (byte)(this.hasEnoughSolidSide | BitUtil.bit(dir.ordinal(), MixinBlockCache.calculateSideCoversSquare(face, field_220083_b)));
            this.sideSolidFullSquare = (byte)(this.sideSolidFullSquare | BitUtil.bit(dir.ordinal(), MixinBlockCache.calculateIsFaceFullSquare(face)));
        }
    }

    @Override
    public boolean hasEnoughSolidSide(Direction facing) {
        return BitUtil.contains(this.hasSolidSide, facing.ordinal());
    }

    @Override
    public boolean hasSolidSide(Direction facing) {
        return BitUtil.contains(this.hasEnoughSolidSide, facing.ordinal());
    }

    @Override
    public boolean isFaceFullSquare(Direction facing) {
        return BitUtil.contains(this.sideSolidFullSquare, facing.ordinal());
    }

    private static boolean calculateSideCoversSquare(VoxelShape shape, VoxelShape square) {
        return shape == VoxelShapes.func_197868_b() || !VoxelShapes.func_197879_c((VoxelShape)shape, (VoxelShape)square, (IBooleanFunction)IBooleanFunction.field_223232_c_);
    }

    private static boolean calculateIsFaceFullSquare(VoxelShape shape) {
        return shape == VoxelShapes.func_197868_b() || !VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223236_g_);
    }
}

