/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.client.fast_loading_screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.IdentityHashMap;
import me.jellysquid.mods.lithium.common.util.math.Color4;
import net.minecraft.client.gui.screen.WorldLoadProgressScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.listener.TrackingChunkStatusListener;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={WorldLoadProgressScreen.class})
public class MixinWorldLoadProgressScreen {
    @Mutable
    @Shadow
    @Final
    private static Object2IntMap<ChunkStatus> field_213042_c;
    private static IdentityHashMap<ChunkStatus, Color4> COLORS_FAST;
    private static final Color4 NULL_STATUS_COLOR;
    private static final Color4 DEFAULT_STATUS_COLOR;

    @Overwrite
    public static void func_213038_a(TrackingChunkStatusListener tracker, int mapX, int mapY, int mapScale, int mapPadding) {
        if (COLORS_FAST == null) {
            COLORS_FAST = new IdentityHashMap(field_213042_c.size());
            COLORS_FAST.put(null, NULL_STATUS_COLOR);
            field_213042_c.object2IntEntrySet().forEach(entry -> COLORS_FAST.put((ChunkStatus)entry.getKey(), Color4.fromRGBA(entry.getIntValue() | 0xFF000000)));
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int centerSize = tracker.func_219522_c();
        int size = tracker.func_219523_d();
        int tileSize = mapScale + mapPadding;
        if (mapPadding != 0) {
            int mapRenderCenterSize = centerSize * tileSize - mapPadding;
            int radius = mapRenderCenterSize / 2 + 1;
            MixinWorldLoadProgressScreen.addRect(buffer, mapX - radius, mapY - radius, mapX - radius + 1, mapY + radius, DEFAULT_STATUS_COLOR);
            MixinWorldLoadProgressScreen.addRect(buffer, mapX + radius - 1, mapY - radius, mapX + radius, mapY + radius, DEFAULT_STATUS_COLOR);
            MixinWorldLoadProgressScreen.addRect(buffer, mapX - radius, mapY - radius, mapX + radius, mapY - radius + 1, DEFAULT_STATUS_COLOR);
            MixinWorldLoadProgressScreen.addRect(buffer, mapX - radius, mapY + radius - 1, mapX + radius, mapY + radius, DEFAULT_STATUS_COLOR);
        }
        int mapRenderSize = size * tileSize - mapPadding;
        int mapStartX = mapX - mapRenderSize / 2;
        int mapStartY = mapY - mapRenderSize / 2;
        ChunkStatus prevStatus = null;
        Color4 prevColor = NULL_STATUS_COLOR;
        for (int x = 0; x < size; ++x) {
            int tileX = mapStartX + x * tileSize;
            for (int z = 0; z < size; ++z) {
                Color4 color;
                int tileY = mapStartY + z * tileSize;
                ChunkStatus status = tracker.func_219525_a(x, z);
                if (prevStatus == status) {
                    color = prevColor;
                } else {
                    color = COLORS_FAST.get(status);
                    prevStatus = status;
                    prevColor = color;
                }
                MixinWorldLoadProgressScreen.addRect(buffer, tileX, tileY, tileX + mapScale, tileY + mapScale, color);
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_227619_H_();
        GlStateManager.func_227737_l_();
    }

    private static void addRect(BufferBuilder buffer, double x1, double y1, double x2, double y2, Color4 color) {
        buffer.func_225582_a_(x1, y2, 0.0).func_225586_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(x2, y2, 0.0).func_225586_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(x2, y1, 0.0).func_225586_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(x1, y1, 0.0).func_225586_a_(color.r, color.g, color.b, color.a).func_181675_d();
    }

    static {
        NULL_STATUS_COLOR = Color4.fromRGBA(-16777216);
        DEFAULT_STATUS_COLOR = Color4.fromRGBA(-16772609);
    }
}

