/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.init.CoreConfig;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CoreCommonEvents {
    private static boolean registered = false;

    public static void register() {
        if (registered) {
            return;
        }
        MinecraftForge.EVENT_BUS.register(CoreCommonEvents.class);
        registered = true;
    }

    private CoreCommonEvents() {
    }

    @SubscribeEvent
    public static void handleFarmlandTrampleEvent(BlockEvent.FarmlandTrampleEvent event) {
        int encFeatherFalling;
        if (event.isCanceled()) {
            return;
        }
        if (!CoreConfig.improvedFeatherFalling) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (encFeatherFalling = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_180309_e, (LivingEntity)((LivingEntity)entity))) > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleItemFishedEvent(ItemFishedEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!CoreConfig.enableFishingExhaustion) {
            return;
        }
        PlayerEntity player = event.getHookEntity().field_146042_b;
        if (player == null || player instanceof FakePlayer) {
            return;
        }
        player.func_71020_j(CoreConfig.amountFishingExhaustion);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handlePickupXpEvent(PlayerXpEvent.PickupXp event) {
        ItemStack itemstack;
        if (event.isCanceled()) {
            return;
        }
        if (!CoreConfig.improvedMending) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ExperienceOrbEntity orb = event.getOrb();
        player.field_71090_bL = 2;
        player.func_71001_a((Entity)orb, 1);
        Map.Entry<EquipmentSlotType, ItemStack> entry = CoreCommonEvents.getMostDamagedItem(player);
        if (entry != null && !(itemstack = entry.getValue()).func_190926_b() && itemstack.func_77951_h()) {
            int i = Math.min((int)((float)orb.field_70530_e * itemstack.getXpRepairRatio()), itemstack.func_77952_i());
            orb.field_70530_e -= CoreCommonEvents.durabilityToXp(i);
            itemstack.func_196085_b(itemstack.func_77952_i() - i);
        }
        if (orb.field_70530_e > 0) {
            player.func_195068_e(orb.field_70530_e);
        }
        orb.func_70106_y();
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleSaplingGrowTreeEvent(SaplingGrowTreeEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!CoreConfig.enableSaplingGrowthMod) {
            return;
        }
        if (event.getRand().nextInt(CoreConfig.amountSaplingGrowthMod) != 0) {
            event.setResult(Event.Result.DENY);
        }
    }

    private static Map.Entry<EquipmentSlotType, ItemStack> getMostDamagedItem(PlayerEntity player) {
        Map map = Enchantments.field_185296_A.func_222181_a((LivingEntity)player);
        Map.Entry mostDamaged = null;
        if (map.isEmpty()) {
            return null;
        }
        double durability = 0.0;
        for (Map.Entry entry : map.entrySet()) {
            ItemStack stack = (ItemStack)entry.getValue();
            if (stack.func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) <= 0 || !(CoreCommonEvents.calcDurabilityRatio(stack) > durability)) continue;
            mostDamaged = entry;
            durability = CoreCommonEvents.calcDurabilityRatio(stack);
        }
        return mostDamaged;
    }

    private static int durabilityToXp(int durability) {
        return durability / 2;
    }

    private static int xpToDurability(int xp) {
        return xp * 2;
    }

    private static double calcDurabilityRatio(ItemStack stack) {
        return (double)stack.func_77952_i() / (double)stack.func_77958_k();
    }
}

