/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.impl;

import com.feed_the_beast.mods.ftbchunks.api.ChunkDimPos;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunk;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkGroupImpl;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkPlayerDataImpl;
import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import java.time.Instant;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;

public class ClaimedChunkImpl
implements ClaimedChunk {
    public static TicketType<ChunkPos> TICKET_TYPE = TicketType.func_219484_a((String)"ftbchunks", Comparator.comparingLong(ChunkPos::func_201841_a));
    public static final int MAGIC_NUMBER = 2;
    public final ClaimedChunkPlayerDataImpl playerData;
    public final ChunkDimPos pos;
    public Instant forceLoaded;
    public ClaimedChunkGroupImpl group;
    public Instant time;

    public ClaimedChunkImpl(ClaimedChunkPlayerDataImpl p, ChunkDimPos cp) {
        this.playerData = p;
        this.pos = cp;
        this.forceLoaded = null;
        this.time = Instant.now();
    }

    @Override
    public ClaimedChunkPlayerDataImpl getPlayerData() {
        return this.playerData;
    }

    @Override
    public ChunkDimPos getPos() {
        return this.pos;
    }

    @Override
    @Nullable
    public ClaimedChunkGroupImpl getGroup() {
        return this.group;
    }

    @Override
    public Instant getTimeClaimed() {
        return this.time;
    }

    @Override
    public void setClaimedTime(Instant t) {
        this.time = t;
    }

    @Override
    @Nullable
    public Instant getForceLoadedTime() {
        return this.forceLoaded;
    }

    @Override
    public void setForceLoadedTime(@Nullable Instant time) {
        this.forceLoaded = time;
    }

    private boolean isAlly(ServerPlayerEntity player) {
        return player.func_184102_h().func_71264_H() || player.func_211513_k(2) || this.playerData.isAlly(player);
    }

    @Override
    public boolean canEdit(ServerPlayerEntity player, BlockState blockState) {
        return this.isAlly(player) || FTBChunksAPIImpl.EDIT_TAG.func_199685_a_((Object)blockState.func_177230_c());
    }

    @Override
    public boolean canInteract(ServerPlayerEntity player, BlockState blockState) {
        return this.isAlly(player) || FTBChunksAPIImpl.INTERACT_TAG.func_199685_a_((Object)blockState.func_177230_c());
    }

    @Override
    public boolean canEntitySpawn(Entity entity) {
        return true;
    }

    @Override
    public boolean allowExplosions() {
        return false;
    }

    public void postSetForceLoaded(boolean load) {
        ServerWorld world = this.getPlayerData().getManager().getMinecraftServer().func_71218_a(this.getPos().dimension);
        world.func_217458_b(this.getPos().x, this.getPos().z, load);
    }
}

