/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks;

import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ColorMapLoader
extends ReloadListener<JsonObject> {
    protected JsonObject prepare(IResourceManager resourceManager, IProfiler profiler) {
        Gson gson = new GsonBuilder().setLenient().create();
        JsonObject object = new JsonObject();
        try {
            for (IResource resource : resourceManager.func_199004_b(new ResourceLocation("ftbchunks", "ftbchunks_colors.json"))) {
                try {
                    InputStreamReader reader = new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        for (Map.Entry entry : ((JsonObject)gson.fromJson((Reader)reader, JsonObject.class)).entrySet()) {
                            object.add((String)entry.getKey(), (JsonElement)entry.getValue());
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return object;
    }

    protected void apply(JsonObject object, IResourceManager resourceManager, IProfiler profiler) {
        FTBChunksAPIImpl.COLOR_MAP.clear();
        for (Map.Entry entry : object.entrySet()) {
            Color4I color;
            if (!((JsonElement)entry.getValue()).isJsonPrimitive() || (color = Color4I.fromJson((JsonElement)((JsonElement)entry.getValue()))).isEmpty()) continue;
            if (((String)entry.getKey()).startsWith("#")) {
                Tag tag = BlockTags.func_199896_a().func_199910_a(new ResourceLocation(((String)entry.getKey()).substring(1)));
                if (tag == null) continue;
                for (Block block : tag.func_199885_a()) {
                    FTBChunksAPIImpl.COLOR_MAP.put(block, color);
                }
                continue;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)entry.getKey()));
            if (block == Blocks.field_150350_a) continue;
            FTBChunksAPIImpl.COLOR_MAP.put(block, color);
        }
    }
}

