/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.managers;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveAll;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipeByModid;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipeByName;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipeByOutput;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipeByRegex;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker.impl.managers.CTCraftingTableManager;
import com.blamejared.crafttweaker.impl.recipes.wrappers.WrapperRecipe;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.registries.IRecipeManager")
@Document(value="vanilla/api/managers/IRecipeManager")
public interface IRecipeManager
extends CommandStringDisplayable {
    public static final Gson JSON_RECIPE_GSON = new GsonBuilder().create();

    @ZenCodeType.Method
    default public void addJSONRecipe(String name, IData data) {
        name = this.validateRecipeName(name);
        if (!(data instanceof MapData)) {
            throw new IllegalArgumentException("Json recipe's IData should be a MapData!");
        }
        MapData mapData = (MapData)data;
        JsonObject recipeObject = (JsonObject)JSON_RECIPE_GSON.fromJson(mapData.toJsonString(), JsonObject.class);
        String recipeTypeKey = this.getBracketResourceLocation().toString();
        if (recipeObject.has("type")) {
            if (!recipeObject.get("type").getAsString().equals(recipeTypeKey)) {
                throw new IllegalArgumentException("Cannot override recipe type! Given: \"" + recipeObject.get("type").getAsString() + "\", Expected: \"" + recipeTypeKey + "\"");
            }
        } else {
            recipeObject.addProperty("type", recipeTypeKey);
        }
        IRecipe iRecipe = RecipeManager.func_215377_a((ResourceLocation)new ResourceLocation("crafttweaker", name), (JsonObject)recipeObject);
        CraftTweakerAPI.apply(new ActionAddRecipe(this, iRecipe, ""));
    }

    @ZenCodeType.Method
    default public WrapperRecipe getRecipeByName(String name) {
        IRecipe<?> recipe = this.getRecipes().get(new ResourceLocation(name));
        if (recipe == null) {
            throw new IllegalArgumentException("No recipe found with name: \"" + name + "\" in type: \"" + this.getRecipeType().toString() + "\"");
        }
        return new WrapperRecipe(recipe);
    }

    default public List<WrapperRecipe> getRecipesByOutput(IItemStack output) {
        return this.getRecipes().values().stream().filter(iRecipe -> new MCItemStackMutable(iRecipe.func_77571_b()).matches(output)).map(WrapperRecipe::new).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    default public void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByOutput(this, output));
    }

    @ZenCodeType.Method
    default public void removeByName(String name) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByName(this, new ResourceLocation(name)));
    }

    @ZenCodeType.Method
    default public void removeByModid(String modid) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByModid(this, modid));
    }

    @ZenCodeType.Method
    default public void removeByModid(String modid, RecipeFilter exclude) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByModid(this, modid, exclude));
    }

    @ZenCodeType.Method
    default public void removeByRegex(String regex) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByRegex(this, regex));
    }

    @ZenCodeType.Method
    default public void removeAll() {
        CraftTweakerAPI.apply(new ActionRemoveAll(this));
    }

    public IRecipeType getRecipeType();

    default public Map<ResourceLocation, IRecipe<?>> getRecipes() {
        return CTCraftingTableManager.recipeManager.field_199522_d.getOrDefault(this.getRecipeType(), Collections.emptyMap());
    }

    default public String validateRecipeName(String name) {
        if (!(name = this.fixRecipeName(name)).chars().allMatch(ch -> ch == 95 || ch == 45 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch == 47 || ch == 46)) {
            throw new IllegalArgumentException("Given name does not fit the \"[a-z0-9/._-]\" regex! Name: \"" + name + "\"");
        }
        return name;
    }

    default public String fixRecipeName(String name) {
        String temp;
        String fixed = name;
        if (fixed.indexOf(58) >= 0) {
            temp = fixed.replaceAll(":", ".");
            CraftTweakerAPI.logWarning("Invalid recipe name \"%s\", recipe names cannot have a \":\"! New recipe name: \"%s\"", fixed, temp);
            fixed = temp;
        }
        if (fixed.indexOf(32) >= 0) {
            temp = fixed.replaceAll(" ", ".");
            CraftTweakerAPI.logWarning("Invalid recipe name \"%s\", recipe names cannot have a \" \"! New recipe name: \"%s\"", fixed, temp);
            fixed = temp;
        }
        if (!fixed.toLowerCase().equals(fixed)) {
            temp = fixed.toLowerCase();
            CraftTweakerAPI.logWarning("Invalid recipe name \"%s\", recipe names have to be lowercase! New recipe name: \"%s\"", fixed, temp);
            fixed = temp;
        }
        return fixed;
    }

    default public ResourceLocation getBracketResourceLocation() {
        return Registry.field_218367_H.func_177774_c((Object)this.getRecipeType());
    }

    @Override
    default public String getCommandString() {
        return "<recipetype:" + this.getRecipeType().toString() + ">";
    }

    @FunctionalInterface
    @ZenRegister
    public static interface RecipeFunctionMatrix {
        public IItemStack process(IItemStack var1, IItemStack[][] var2);
    }

    @FunctionalInterface
    @ZenRegister
    public static interface RecipeFunctionArray {
        public IItemStack process(IItemStack var1, IItemStack[] var2);
    }

    @FunctionalInterface
    @ZenRegister
    public static interface RecipeFunctionSingle {
        public IItemStack process(IItemStack var1, IItemStack var2);
    }

    @FunctionalInterface
    @ZenRegister
    public static interface RecipeFilter {
        public boolean test(String var1);
    }
}

