/*
 * Decompiled with CFR 0.152.
 */
package net.quetzi.morpheus.helpers;

import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.quetzi.morpheus.Morpheus;
import net.quetzi.morpheus.helpers.Config;
import net.quetzi.morpheus.world.WorldSleepState;

public class MorpheusEventHandler {
    @SubscribeEvent
    public void loggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().func_130014_f_().field_72995_K) {
            if (!Morpheus.playerSleepStatus.containsKey(event.getPlayer().field_71093_bK.func_186068_a())) {
                Morpheus.playerSleepStatus.put(event.getPlayer().field_71093_bK.func_186068_a(), new WorldSleepState(event.getPlayer().field_71093_bK.func_186068_a()));
            }
            Morpheus.playerSleepStatus.get(event.getPlayer().field_71093_bK.func_186068_a()).setPlayerAwake(event.getPlayer().func_146103_bH().getName());
        }
    }

    @SubscribeEvent
    public void loggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getPlayer().func_130014_f_().field_72995_K && Morpheus.playerSleepStatus.get(event.getPlayer().field_71093_bK.func_186068_a()) != null) {
            Morpheus.playerSleepStatus.get(event.getPlayer().field_71093_bK.func_186068_a()).removePlayer(event.getPlayer().func_146103_bH().getName());
        }
    }

    @SubscribeEvent
    public void changedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getPlayer().func_130014_f_().field_72995_K) {
            if (!Morpheus.playerSleepStatus.containsKey(event.getTo().func_186068_a())) {
                Morpheus.playerSleepStatus.put(event.getTo().func_186068_a(), new WorldSleepState(event.getTo().func_186068_a()));
            }
            if (Morpheus.playerSleepStatus.get(event.getFrom().func_186068_a()) != null) {
                Morpheus.playerSleepStatus.get(event.getFrom().func_186068_a()).removePlayer(event.getPlayer().func_146103_bH().getName());
            }
            Morpheus.playerSleepStatus.get(event.getTo().func_186068_a()).setPlayerAwake(event.getPlayer().func_146103_bH().getName());
        }
    }

    @SubscribeEvent
    public void worldTickEvent(TickEvent.WorldTickEvent event) {
        int dimid = event.world.func_201675_m().func_186058_p().func_186068_a();
        if (!event.world.field_72995_K && event.world.func_82737_E() % 20L == 10L && event.phase == TickEvent.Phase.END) {
            if (event.world.func_217369_A().size() > 0) {
                if (!Morpheus.playerSleepStatus.containsKey(dimid)) {
                    Morpheus.playerSleepStatus.put(dimid, new WorldSleepState(dimid));
                }
                if (Morpheus.playerSleepStatus.get(dimid).getPlayerCount() > event.world.func_217369_A().size()) {
                    Morpheus.playerSleepStatus.get(dimid).resetPlayers();
                }
                Morpheus.checker.updatePlayerStates(event.world);
            } else {
                Morpheus.playerSleepStatus.remove(dimid);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void bedClicked(PlayerInteractEvent.RightClickBlock event) {
        if (((Boolean)Config.SERVER.setSpawnDaytime.get()).booleanValue()) {
            BlockState state;
            PlayerEntity player = event.getPlayer();
            BlockPos pos = event.getPos();
            if (!event.getWorld().field_72995_K && event.getWorld().func_72935_r() && !player.func_213453_ef() && (player.getBedLocation(player.field_71093_bK) == null || this.getDistance(pos, player.func_180425_c()) < 4.0) && (state = event.getWorld().func_180495_p(pos)).func_177230_c() instanceof BedBlock && event.getWorld().func_201675_m().func_76567_e() && event.getWorld().func_201675_m().func_186058_p() != DimensionType.field_223228_b_ && !((Boolean)state.func_177229_b((IProperty)BedBlock.field_176471_b)).booleanValue()) {
                player.setSpawnPoint(pos, false, true, event.getWorld().func_201675_m().func_186058_p());
                event.setCanceled(true);
            }
        }
    }

    private double getDistance(BlockPos posA, BlockPos posB) {
        return Math.sqrt(Math.pow(posA.func_177958_n() - posB.func_177958_n(), 2.0) + Math.pow(posA.func_177956_o() - posB.func_177956_o(), 2.0) + Math.pow(posA.func_177952_p() - posB.func_177952_p(), 2.0));
    }
}

