/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.asm;

import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.deadly.loot.affix.Affix;
import shadows.apotheosis.deadly.loot.affix.AffixHelper;

public class DeadlyHooks {
    public static UUID getRealUUID(UUID uuid) {
        if (!Apotheosis.enableDeadly) {
            return uuid;
        }
        if (Access.getADM().equals(uuid)) {
            return Access.getADM();
        }
        if (Access.getASM().equals(uuid)) {
            return Access.getASM();
        }
        return uuid;
    }

    public static int getProtectionLevel(Iterable<ItemStack> stacks, DamageSource source) {
        int prot = 0;
        for (ItemStack s : stacks) {
            Map<Affix, Float> affixes = AffixHelper.getAffixes(s);
            for (Map.Entry<Affix, Float> e : affixes.entrySet()) {
                prot += e.getKey().getProtectionLevel(e.getValue().floatValue(), source);
            }
        }
        return prot;
    }

    public static float getExtraDamageFor(ItemStack stack, CreatureAttribute type) {
        float dmg = 0.0f;
        Map<Affix, Float> affixes = AffixHelper.getAffixes(stack);
        for (Map.Entry<Affix, Float> e : affixes.entrySet()) {
            dmg += e.getKey().getExtraDamageFor(e.getValue().floatValue(), type);
        }
        return dmg;
    }

    public static void onEntityDamaged(LivingEntity user, Entity target) {
        if (user != null) {
            for (ItemStack s : user.func_184209_aF()) {
                Map<Affix, Float> affixes = AffixHelper.getAffixes(s);
                for (Map.Entry<Affix, Float> e : affixes.entrySet()) {
                    target.field_70172_ad = 0;
                    int old = 0;
                    e.getKey().onEntityDamaged(user, target, e.getValue().floatValue());
                    target.field_70172_ad = old;
                }
            }
        }
    }

    public static void onUserHurt(LivingEntity user, Entity attacker) {
        if (user != null) {
            for (ItemStack s : user.func_184209_aF()) {
                Map<Affix, Float> affixes = AffixHelper.getAffixes(s);
                for (Map.Entry<Affix, Float> e : affixes.entrySet()) {
                    e.getKey().onUserHurt(user, attacker, e.getValue().floatValue());
                }
            }
        }
    }

    private static class Access
    extends Item {
        public Access(Item.Properties properties) {
            super(properties);
        }

        public static UUID getADM() {
            return Item.field_111210_e;
        }

        public static UUID getASM() {
            return Item.field_185050_h;
        }
    }
}

