/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets.modes;

import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.registry.OurBlocks;
import com.direwolf20.buildinggadgets.common.tiles.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class AbstractMode {
    private boolean isExchanging;

    public AbstractMode(boolean isExchanging) {
        this.isExchanging = isExchanging;
    }

    abstract List<BlockPos> collect(UseContext var1, PlayerEntity var2, BlockPos var3);

    public List<BlockPos> getCollection(UseContext context, PlayerEntity player) {
        BlockPos startPos = this.withOffset(context.getStartPos(), context.getHitSide(), context.isPlaceOnTop());
        BlockState lookingAtState = this.isExchanging() ? context.getWorldState(startPos) : null;
        return this.collect(context, player, startPos).stream().filter(e -> this.isExchanging ? this.exchangingValidator((BlockPos)e, lookingAtState, context) : this.validator(player, (BlockPos)e, context)).sorted(Comparator.comparing(pos -> player.func_180425_c().func_177951_i((Vec3i)pos))).collect(Collectors.toList());
    }

    public boolean validator(PlayerEntity player, BlockPos pos, UseContext context) {
        if (!context.getWorldState(pos).func_196953_a(context.createBlockUseContext(player))) {
            return false;
        }
        if (World.func_189509_E((BlockPos)pos)) {
            return false;
        }
        return (Boolean)Config.GENERAL.allowOverwriteBlocks.get() != false ? context.getWorldState(pos).func_185904_a().func_76222_j() : context.getWorldState(pos).func_185904_a() != Material.field_151579_a;
    }

    private boolean exchangingValidator(BlockPos pos, BlockState lookingAtState, UseContext context) {
        BlockState worldBlockState = context.getWorldState(pos);
        TileEntity te = context.getWorld().func_175625_s(pos);
        if (worldBlockState != lookingAtState && !context.isFuzzy() || worldBlockState == OurBlocks.effectBlock.func_176223_P() || worldBlockState == context.getSetState()) {
            return false;
        }
        if (!(te == null || te instanceof ConstructionBlockTileEntity && te.func_195044_w() != context.getSetState())) {
            return false;
        }
        if (worldBlockState.func_185887_b((IBlockReader)context.getWorld(), pos) < 0.0f) {
            return false;
        }
        if (worldBlockState.func_185904_a() == Material.field_151579_a || worldBlockState.func_185904_a().func_76224_d()) {
            return false;
        }
        boolean hasSingeValid = false;
        for (Direction direction : Direction.values()) {
            BlockPos offset = pos.func_177972_a(direction);
            if (!context.getWorld().func_175623_d(offset) && context.getWorld().func_180495_p(offset).func_196954_c((IBlockReader)context.getWorld(), offset) == VoxelShapes.func_197868_b()) continue;
            hasSingeValid = true;
            break;
        }
        return hasSingeValid;
    }

    public BlockPos withOffset(BlockPos pos, Direction side, boolean placeOnTop) {
        return placeOnTop ? pos.func_177967_a(side, 1) : pos;
    }

    public boolean isExchanging() {
        return this.isExchanging;
    }

    public static class UseContext {
        private World world;
        private BlockState setState;
        private BlockPos startPos;
        private Direction hitSide;
        private boolean isFuzzy;
        private boolean placeOnTop;
        private int range;
        private boolean rayTraceFluid;

        public UseContext(World world, BlockState setState, BlockPos startPos, ItemStack gadget, Direction hitSide, boolean placeOnTop) {
            this.world = world;
            this.setState = setState;
            this.startPos = startPos;
            this.range = GadgetUtils.getToolRange(gadget);
            this.isFuzzy = AbstractGadget.getFuzzy(gadget);
            this.rayTraceFluid = AbstractGadget.shouldRayTraceFluid(gadget);
            this.hitSide = hitSide;
            this.placeOnTop = placeOnTop;
        }

        public UseContext(World world, BlockState setState, BlockPos startPos, ItemStack gadget, Direction hitSide) {
            this(world, setState, startPos, gadget, hitSide, false);
        }

        public BlockItemUseContext createBlockUseContext(PlayerEntity player) {
            return new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, VectorHelper.getLookingAt(player, this.rayTraceFluid)));
        }

        public BlockState getWorldState(BlockPos pos) {
            return this.world.func_180495_p(pos);
        }

        public World getWorld() {
            return this.world;
        }

        public BlockState getSetState() {
            return this.setState;
        }

        public boolean isFuzzy() {
            return this.isFuzzy;
        }

        public boolean isRayTraceFluid() {
            return this.rayTraceFluid;
        }

        public boolean isPlaceOnTop() {
            return this.placeOnTop;
        }

        public int getRange() {
            return this.range;
        }

        public BlockPos getStartPos() {
            return this.startPos;
        }

        public Direction getHitSide() {
            return this.hitSide;
        }

        public String toString() {
            return "UseContext{world=" + this.world + ", setState=" + this.setState + ", startPos=" + this.startPos + ", hitSide=" + this.hitSide + ", isFuzzy=" + this.isFuzzy + ", placeOnTop=" + this.placeOnTop + ", range=" + this.range + ", rayTraceFluid=" + this.rayTraceFluid + '}';
        }
    }
}

