/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.ExplosionCraftingRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ExplosionCraftingRecipeImpl
extends ExplosionCraftingRecipe {
    private static final NonNullList<ItemStack> EMPTY_RESULT = NonNullList.func_191196_a();
    private final Ingredient input;
    private final List<ItemStack> outputs;
    private final int lossRate;

    public ExplosionCraftingRecipeImpl(ResourceLocation id, Ingredient input, int lossRate, ItemStack ... outputs) {
        super(id);
        this.input = input;
        this.outputs = Arrays.asList(outputs);
        this.lossRate = lossRate;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public int getAmount() {
        return this.input.func_193365_a().length > 0 ? this.input.func_193365_a()[0].func_190916_E() : 0;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public int getLossRate() {
        return this.lossRate;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack) && stack.func_190916_E() >= this.getAmount();
    }

    public static NonNullList<ItemStack> tryToCraft(World world, ItemStack stack) {
        ExplosionCraftingRecipe recipe = PneumaticCraftRecipeType.EXPLOSION_CRAFTING.findFirst(world, r -> r.matches(stack));
        return recipe == null ? EMPTY_RESULT : ExplosionCraftingRecipeImpl.createOutput(recipe, stack);
    }

    private static NonNullList<ItemStack> createOutput(ExplosionCraftingRecipe recipe, ItemStack stack) {
        Random rand = new Random();
        int lossRate = recipe.getLossRate();
        NonNullList res = NonNullList.func_191196_a();
        int inputCount = Math.round((float)stack.func_190916_E() / (float)recipe.getAmount());
        if (inputCount >= 3 || rand.nextDouble() >= (double)lossRate / 100.0) {
            for (ItemStack s : recipe.getOutputs()) {
                ItemStack newStack = s.func_77946_l();
                if (inputCount >= 3) {
                    newStack.func_190920_e((int)((double)inputCount * (rand.nextDouble() * Math.min((double)lossRate * 0.02, 0.2) + (Math.max(0.9, 1.0 - (double)lossRate * 0.01) - (double)lossRate * 0.01))));
                }
                res.add((Object)newStack);
            }
        }
        return res;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input.func_199564_a(buffer);
        buffer.func_150787_b(this.outputs.size());
        this.outputs.forEach(arg_0 -> ((PacketBuffer)buffer).func_150788_a(arg_0));
        buffer.func_150787_b(this.lossRate);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.EXPLOSION_CRAFTING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return PneumaticCraftRecipeType.EXPLOSION_CRAFTING;
    }

    public String func_193358_e() {
        return PneumaticCraftRecipeType.EXPLOSION_CRAFTING.toString();
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)Blocks.field_150335_W);
    }

    public static class Serializer<T extends ExplosionCraftingRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.func_199802_a((JsonElement)json.get("input"));
            int loss_rate = JSONUtils.func_151208_a((JsonObject)json, (String)"loss_rate", (int)0);
            JsonArray outputs = json.get("results").getAsJsonArray();
            NonNullList results = NonNullList.func_191196_a();
            for (JsonElement e : outputs) {
                results.add((Object)ShapedRecipe.func_199798_a((JsonObject)e.getAsJsonObject()));
            }
            return this.factory.create(recipeId, input, loss_rate, (ItemStack[])results.toArray((Object[])new ItemStack[0]));
        }

        @Nullable
        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            int nOutputs = buffer.func_150792_a();
            ArrayList<ItemStack> l = new ArrayList<ItemStack>();
            for (int i = 0; i < nOutputs; ++i) {
                l.add(buffer.func_150791_c());
            }
            int lossRate = buffer.func_150792_a();
            return this.factory.create(recipeId, input, lossRate, l.toArray(new ItemStack[0]));
        }

        public void write(PacketBuffer buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends ExplosionCraftingRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, int var3, ItemStack ... var4);
        }
    }
}

