/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.HashSet;
import java.util.Set;
import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IItemDropper;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class ProgWidgetDropItem
extends ProgWidgetInventoryBase
implements IItemDropper {
    private boolean dropStraight;

    public ProgWidgetDropItem() {
        super(ModProgWidgets.DROP_ITEM);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.MAGENTA;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_DROP_ITEM;
    }

    @Override
    public boolean dropStraight() {
        return this.dropStraight;
    }

    @Override
    public void setDropStraight(boolean dropStraight) {
        this.dropStraight = dropStraight;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("dropStraight", this.dropStraight);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.dropStraight = tag.func_74767_n("dropStraight");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.dropStraight);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.dropStraight = buf.readBoolean();
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAIImExBase<ProgWidgetDropItem>(drone, (ProgWidgetDropItem)widget){
            private final Set<BlockPos> visitedPositions;
            {
                this.visitedPositions = new HashSet<BlockPos>();
            }

            @Override
            public boolean func_75250_a() {
                boolean shouldExecute = false;
                for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                    ItemStack stack = this.drone.getInv().getStackInSlot(i);
                    if (!((ProgWidgetDropItem)this.progWidget).isItemValidForFilters(stack)) continue;
                    shouldExecute = super.func_75250_a();
                    break;
                }
                return shouldExecute;
            }

            @Override
            protected boolean moveIntoBlock() {
                return true;
            }

            @Override
            protected boolean isValidPosition(BlockPos pos) {
                return !this.visitedPositions.contains(pos);
            }

            @Override
            protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
                this.visitedPositions.add(pos);
                for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                    ItemStack stack = this.drone.getInv().getStackInSlot(i);
                    if (!((ProgWidgetDropItem)this.progWidget).isItemValidForFilters(stack)) continue;
                    if (this.useCount() && this.getRemainingCount() < stack.func_190916_E()) {
                        stack = stack.func_77979_a(this.getRemainingCount());
                        this.decreaseCount(this.getRemainingCount());
                    } else {
                        this.decreaseCount(stack.func_190916_E());
                        this.drone.getInv().setStackInSlot(i, ItemStack.field_190927_a);
                    }
                    ItemEntity item = new ItemEntity(this.drone.world(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                    if (((ProgWidgetDropItem)this.progWidget).dropStraight()) {
                        item.func_213293_j(0.0, 0.0, 0.0);
                    }
                    this.drone.world().func_217376_c((Entity)item);
                    if (this.useCount() && this.getRemainingCount() == 0) break;
                }
                return false;
            }
        };
    }

    @Override
    protected boolean isUsingSides() {
        return false;
    }

    @Override
    public String getExtraStringInfo() {
        return this.dropStraight() ? "Straight" : "Random";
    }
}

