/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.common.ai.NodeProcessorDrone;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityPathNavigateDrone
extends FlyingPathNavigator
implements IPathNavigator {
    private final EntityDrone pathfindingEntity;
    public boolean pathThroughLiquid;
    private boolean forceTeleport;
    private int teleportCounter = -1;
    private BlockPos telPos;
    private static final int TELEPORT_TICKS = 120;

    public EntityPathNavigateDrone(EntityDrone pathfindingEntity, World par2World) {
        super((MobEntity)pathfindingEntity, par2World);
        this.pathfindingEntity = pathfindingEntity;
    }

    public boolean func_75497_a(Entity p_75497_1_, double p_75497_2_) {
        return super.func_75497_a(p_75497_1_, p_75497_2_) || this.isGoingToTeleport();
    }

    public Path func_75494_a(Entity par1Entity, int p2) {
        BlockPos pos = new BlockPos(par1Entity.func_226277_ct_(), par1Entity.func_174813_aQ().field_72338_b, par1Entity.func_226281_cx_());
        if ((par1Entity instanceof ItemEntity && !this.pathfindingEntity.isBlockValidPathfindBlock(pos) || par1Entity instanceof AbstractMinecartEntity) && this.pathfindingEntity.isBlockValidPathfindBlock(pos.func_177984_a())) {
            pos = pos.func_177984_a();
        }
        return this.func_179680_a(pos, p2);
    }

    void setForceTeleport(boolean forceTeleport) {
        this.forceTeleport = forceTeleport;
    }

    @Nullable
    public Path func_179680_a(BlockPos pos, int p2) {
        PathPoint lastPoint;
        if (!this.pathfindingEntity.isBlockValidPathfindBlock(pos)) {
            return null;
        }
        if (this.pathfindingEntity.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < 0.75) {
            return new Path((List)Lists.newArrayList((Object[])new PathPoint[]{new PathPoint(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())}), pos, true);
        }
        this.telPos = pos;
        if (this.forceTeleport) {
            this.teleportCounter = 0;
            return null;
        }
        this.pathfindingEntity.setStandby(false);
        Path path = super.func_179680_a(pos, 0);
        if (path != null && (lastPoint = path.func_75870_c()) != null && (lastPoint.field_75839_a != pos.func_177958_n() || lastPoint.field_75837_b != pos.func_177956_o() || lastPoint.field_75838_c != pos.func_177952_p())) {
            path = null;
        }
        if (path == null) {
            if (this.teleportCounter == -1) {
                this.teleportCounter = 0;
            }
        } else {
            this.teleportCounter = -1;
        }
        return path;
    }

    @Override
    public boolean isGoingToTeleport() {
        return this.teleportCounter >= 0;
    }

    public boolean func_75500_f() {
        return super.func_75500_f() && !this.isGoingToTeleport();
    }

    public void func_75501_e() {
        if (this.isGoingToTeleport()) {
            if (this.teleportCounter == 0 || this.teleportCounter == 60) {
                NetworkHandler.sendToAllAround(new PacketPlaySound((SoundEvent)ModSounds.HUD_INIT.get(), SoundCategory.PLAYERS, this.pathfindingEntity.func_226277_ct_(), this.pathfindingEntity.func_226278_cu_(), this.pathfindingEntity.func_226281_cx_(), 0.1f, this.teleportCounter == 0 ? 0.7f : 1.0f, true), this.pathfindingEntity.field_70170_p);
            }
            if (this.teleportCounter < 80) {
                Random rand = this.pathfindingEntity.func_70681_au();
                float f = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                float f1 = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                float f2 = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                NetworkHandler.sendToAllAround(new PacketSpawnParticle((IParticleData)ParticleTypes.field_197599_J, this.pathfindingEntity.func_226277_ct_(), this.pathfindingEntity.func_226278_cu_(), this.pathfindingEntity.func_226281_cx_(), f, f1, f2), this.pathfindingEntity.field_70170_p);
            }
            if (++this.teleportCounter > 120) {
                if (this.pathfindingEntity.isBlockValidPathfindBlock(this.telPos)) {
                    this.teleport();
                }
                this.teleportCounter = -1;
                this.func_75484_a(null, 0.0);
                this.pathfindingEntity.func_70605_aq().func_75642_a((double)this.telPos.func_177958_n(), (double)this.telPos.func_177956_o(), (double)this.telPos.func_177952_p(), this.pathfindingEntity.getSpeed());
                this.pathfindingEntity.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).ifPresent(h -> h.addAir(-10000));
            }
        } else if (!this.func_75500_f()) {
            Vec3d vec32;
            this.func_75508_h();
            if (!this.func_75500_f() && (vec32 = this.field_75514_c.func_75878_a((Entity)this.field_75515_a)) != null) {
                this.field_75515_a.func_70605_aq().func_75642_a(vec32.field_72450_a, vec32.field_72448_b, vec32.field_72449_c, this.field_75511_d);
            }
        }
    }

    public void teleport() {
        Random rand = this.pathfindingEntity.func_70681_au();
        double width = this.pathfindingEntity.func_213311_cf();
        double height = this.pathfindingEntity.func_213302_cg();
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (rand.nextFloat() - 0.5f) * 0.2f;
            float f1 = (rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = this.pathfindingEntity.func_226277_ct_() + ((double)this.telPos.func_177958_n() + 0.5 - this.pathfindingEntity.func_226277_ct_()) * d6 + (rand.nextDouble() - 0.5) * width * 2.0;
            double d8 = this.pathfindingEntity.func_226278_cu_() + ((double)this.telPos.func_177956_o() - this.pathfindingEntity.func_226278_cu_()) * d6 + rand.nextDouble() * height;
            double d9 = this.pathfindingEntity.func_226281_cx_() + ((double)this.telPos.func_177952_p() + 0.5 - this.pathfindingEntity.func_226281_cx_()) * d6 + (rand.nextDouble() - 0.5) * width * 2.0;
            NetworkHandler.sendToAllAround(new PacketSpawnParticle((IParticleData)ParticleTypes.field_197599_J, d7, d8, d9, f, f1, f2), this.pathfindingEntity.field_70170_p);
        }
        this.pathfindingEntity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        this.pathfindingEntity.func_70107_b((double)this.telPos.func_177958_n() + 0.5, (double)this.telPos.func_177956_o() + 0.5, (double)this.telPos.func_177952_p() + 0.5);
    }

    @Override
    public boolean moveToXYZ(double x, double y, double z) {
        boolean success = this.func_75492_a(x, y, z, this.pathfindingEntity.getSpeed());
        if (success) {
            this.forceRidingEntityPaths();
        }
        return success;
    }

    @Override
    public boolean moveToEntity(Entity entity) {
        boolean success = this.func_75497_a(entity, this.pathfindingEntity.getSpeed());
        if (success) {
            this.forceRidingEntityPaths();
        }
        return success;
    }

    public boolean func_75484_a(Path pathentityIn, double speedIn) {
        return super.func_75484_a(pathentityIn, this.pathfindingEntity.getSpeed());
    }

    private void forceRidingEntityPaths() {
        for (Entity ridingEntity : this.pathfindingEntity.func_184188_bt()) {
            if (!(ridingEntity instanceof MobEntity)) continue;
            MobEntity ridingLiving = (MobEntity)ridingEntity;
            ridingLiving.func_70661_as().func_75484_a(this.pathfindingEntity.func_70661_as().func_75505_d(), this.pathfindingEntity.getSpeed());
        }
    }

    @Override
    public boolean hasNoPath() {
        return this.func_75500_f();
    }

    public boolean func_75493_a(Vec3d p_75493_1_, Vec3d p_75493_2_, int p_75493_3_, int p_75493_4_, int p_75493_5_) {
        return false;
    }

    protected PathFinder func_179679_a(int r) {
        this.field_179695_a = new NodeProcessorDrone();
        return new PathFinder(this.field_179695_a, Integer.MAX_VALUE);
    }

    protected Vec3d func_75502_i() {
        return this.pathfindingEntity.getDronePos();
    }

    protected boolean func_75485_k() {
        return true;
    }
}

